/*
 * Decompiled with CFR 0.152.
 */
package hdi.util;

import hdi.util.DateRange;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.List;
import lombok.Generated;

public class TimePeriod {
    public static final TimePeriod THIS_YEAR = new TimePeriod("This Year").unitType(ChronoUnit.YEARS).endPeriodOffset(0).startPeriodOffset(1);
    public static final TimePeriod LAST_YEAR = new TimePeriod(null).unitType(ChronoUnit.YEARS).endPeriodOffset(1).startPeriodOffset(1);
    public static final TimePeriod YEAR_BEFORE_LAST = new TimePeriod(null).unitType(ChronoUnit.YEARS).endPeriodOffset(2).startPeriodOffset(1);
    public static final TimePeriod PREV_PREV_YEAR = new TimePeriod(null).unitType(ChronoUnit.YEARS).endPeriodOffset(3).startPeriodOffset(1);
    public static final TimePeriod PREV_PREV_PREV_YEAR = new TimePeriod(null).unitType(ChronoUnit.YEARS).endPeriodOffset(4).startPeriodOffset(1);
    public static final TimePeriod THIS_MONTH = new TimePeriod("This Month").unitType(ChronoUnit.MONTHS).endPeriodOffset(0).startPeriodOffset(1);
    public static final TimePeriod LAST_MONTH = new TimePeriod("Last Month").unitType(ChronoUnit.MONTHS).endPeriodOffset(1).startPeriodOffset(1);
    public static final TimePeriod MONTH_BEFORE_LAST = new TimePeriod("Previous Month").unitType(ChronoUnit.MONTHS).endPeriodOffset(2).startPeriodOffset(1);
    public static final TimePeriod SIX_MONTHS = new TimePeriod("Six Months").unitType(ChronoUnit.MONTHS).endPeriodOffset(0).startPeriodOffset(6);
    public static final TimePeriod THREE_MONTHS = new TimePeriod("Three Months").unitType(ChronoUnit.MONTHS).endPeriodOffset(0).startPeriodOffset(3);
    public static final TimePeriod PREV_THREE_MONTHS = new TimePeriod("Prev. Three Months").unitType(ChronoUnit.MONTHS).endPeriodOffset(3).startPeriodOffset(3);
    public static final TimePeriod LAST_QUARTER = new TimePeriod("Last Quarter").unitType(ChronoUnit.MONTHS).endPeriodOffset(1).startPeriodOffset(3);
    public static final TimePeriod CUSTOM = new TimePeriod("Custom Dates", Type.CUSTOM);
    public static final TimePeriod ALL = new TimePeriod("None (All Dates)", Type.ALL);
    public static List<TimePeriod> CLAIM_PERIODS = List.of(ALL, THIS_MONTH, LAST_MONTH, THREE_MONTHS, PREV_THREE_MONTHS, SIX_MONTHS, THIS_YEAR, LAST_YEAR, CUSTOM);
    private String header;
    private Type type;
    private int endPeriodOffset = -1;
    private int startPeriodOffset = -1;
    private ChronoUnit unitType;

    private TimePeriod() {
    }

    public TimePeriod(String header, Type type) {
        this.header = header;
        this.type = type;
    }

    public TimePeriod(String header) {
        this(header, Type.PREDEFINED);
    }

    public String header() {
        if (this.header != null) {
            return this.header;
        }
        if (this.unitType == ChronoUnit.YEARS) {
            LocalDate today = LocalDate.now();
            LocalDate endDate = this.getStartDate(today);
            return Integer.toString(endDate.getYear());
        }
        return null;
    }

    public DateRange getDateRange() {
        LocalDate now = LocalDate.now();
        return new DateRange(this.getStartDate(now), this.getEndDate(now));
    }

    public LocalDate getEndDate(LocalDate fromThisDate) {
        if (this.endPeriodOffset == 0) {
            return fromThisDate;
        }
        LocalDate endDate = fromThisDate.minus(this.endPeriodOffset, this.unitType);
        endDate = TimePeriod.getLastDateForTheUnitType(endDate, this.unitType);
        return endDate;
    }

    public LocalDate getStartDate(LocalDate fromThisDate) {
        LocalDate startDate = fromThisDate.minus(this.endPeriodOffset + this.startPeriodOffset, this.unitType);
        startDate = TimePeriod.getLastDateForTheUnitType(startDate, this.unitType);
        return startDate.plusDays(1L);
    }

    public static LocalDate getLastDateForTheUnitType(LocalDate date, ChronoUnit chronoUnit) {
        if (chronoUnit == ChronoUnit.MONTHS) {
            date = LocalDate.of(date.getYear(), date.getMonth(), 1);
            date = date.plusDays(date.lengthOfMonth() - 1);
        } else if (chronoUnit == ChronoUnit.YEARS) {
            date = LocalDate.of(date.getYear(), 12, 1);
            date = date.plusDays(date.lengthOfMonth() - 1);
        }
        return date;
    }

    @Generated
    public Type type() {
        return this.type;
    }

    @Generated
    public int endPeriodOffset() {
        return this.endPeriodOffset;
    }

    @Generated
    public int startPeriodOffset() {
        return this.startPeriodOffset;
    }

    @Generated
    public ChronoUnit unitType() {
        return this.unitType;
    }

    @Generated
    public TimePeriod header(String header) {
        this.header = header;
        return this;
    }

    @Generated
    public TimePeriod type(Type type) {
        this.type = type;
        return this;
    }

    @Generated
    public TimePeriod endPeriodOffset(int endPeriodOffset) {
        this.endPeriodOffset = endPeriodOffset;
        return this;
    }

    @Generated
    public TimePeriod startPeriodOffset(int startPeriodOffset) {
        this.startPeriodOffset = startPeriodOffset;
        return this;
    }

    @Generated
    public TimePeriod unitType(ChronoUnit unitType) {
        this.unitType = unitType;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimePeriod)) {
            return false;
        }
        TimePeriod other = (TimePeriod)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.endPeriodOffset() != other.endPeriodOffset()) {
            return false;
        }
        if (this.startPeriodOffset() != other.startPeriodOffset()) {
            return false;
        }
        String this$header = this.header();
        String other$header = other.header();
        if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
            return false;
        }
        Type this$type = this.type();
        Type other$type = other.type();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        ChronoUnit this$unitType = this.unitType();
        ChronoUnit other$unitType = other.unitType();
        return !(this$unitType == null ? other$unitType != null : !this$unitType.equals(other$unitType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TimePeriod;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.endPeriodOffset();
        result = result * 59 + this.startPeriodOffset();
        String $header = this.header();
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        Type $type = this.type();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        ChronoUnit $unitType = this.unitType();
        result = result * 59 + ($unitType == null ? 43 : $unitType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TimePeriod(header=" + this.header() + ", type=" + String.valueOf((Object)this.type()) + ", endPeriodOffset=" + this.endPeriodOffset() + ", startPeriodOffset=" + this.startPeriodOffset() + ", unitType=" + String.valueOf(this.unitType()) + ")";
    }

    public static enum Type {
        PREDEFINED,
        CUSTOM,
        ALL;

    }
}

