/*
 * Decompiled with CFR 0.152.
 */
package hdi.util;

import hdi.model.orgperson.OrgOrPerson;
import hdi.util.SearchWordsPrefix;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringTokenizer;
import org.apache.commons.text.matcher.StringMatcherFactory;

public class SearchWordsUtils {
    private static final Set<String> excludeFromSearchWords;

    public static void prepPersonSearchWords(Set<String> tokens, OrgOrPerson person) {
        if (person != null) {
            person.prepForPersistence();
            tokens.addAll(person.searchWords());
        }
    }

    public static Set<String> tokenizeTextFields(String ... strings) {
        return SearchWordsUtils.tokenizeTextFields(Arrays.asList(strings));
    }

    public static Set<String> tokenizeTextFields(Collection<String> textFields) {
        textFields = textFields.stream().filter(Objects::nonNull).collect(Collectors.toList());
        String combinedStr = StringUtils.joinWith((String)" ", (Object[])textFields.toArray());
        Set<String> tokens = SearchWordsUtils.tokenizeForSearch(combinedStr);
        LinkedHashSet<String> searcheableTokens = new LinkedHashSet<String>();
        for (String word : tokens) {
            if (excludeFromSearchWords.contains(word)) continue;
            searcheableTokens.add(word);
        }
        return searcheableTokens;
    }

    public static Set<String> tokenizeForSearch(String stringToTokenize) {
        StringTokenizer tokenizer = new StringTokenizer(stringToTokenize);
        tokenizer.setDelimiterMatcher(StringMatcherFactory.INSTANCE.charSetMatcher(" \t\n\r\f)}],!<>./&".toCharArray()));
        Set searchWords = tokenizer.getTokenList().stream().map(String::toLowerCase).collect(Collectors.toSet());
        LinkedHashSet<String> tokens = new LinkedHashSet<String>();
        for (String w : searchWords) {
            w = StringUtils.strip((String)w);
            w = StringUtils.strip((String)w, (String)"{}()[].");
            tokens.add(w);
        }
        return tokens;
    }

    public static void addWordWithPrefix(Collection<String> words, SearchWordsPrefix prefix, String word) {
        if (StringUtils.isBlank((CharSequence)word)) {
            return;
        }
        words.add(prefix.prefixWord(word));
    }

    public static void addWordWithPrefix(Collection<String> words, SearchWordsPrefix prefix, LocalDate date) {
        if (date != null) {
            SearchWordsUtils.addWordWithPrefix(words, prefix, date.format(DateTimeFormatter.BASIC_ISO_DATE));
        }
    }

    public static void addWordsWithPrefix(Collection<String> words, SearchWordsPrefix prefix, Collection<String> wordsToAdd) {
        for (String w : wordsToAdd) {
            SearchWordsUtils.addWordWithPrefix(words, prefix, w);
        }
        if (!wordsToAdd.isEmpty()) {
            words.add(prefix.prefixWord(""));
        }
    }

    static {
        String preposStr = "    About, above, against, across, along, around, among, before, at, behind, beneath, below, beside, beyond, between , by, during, down, except, from, for, inside, in, into, near, like, of, on, off near, to, since, toward, under, though, up, until, upon, within with\n    and is a the code?\n";
        excludeFromSearchWords = SearchWordsUtils.tokenizeForSearch(preposStr);
    }
}

