/*
 * Decompiled with CFR 0.152.
 */
package hdi.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import hdi.GeneralException;
import java.io.IOException;

public class JacksonUtils {
    public static final String ISO_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    public static final ObjectMapper DEFAULT_MAPPER_SNAKE = new ObjectMapper().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(SerializationFeature.INDENT_OUTPUT, true);
    public static final ObjectMapper DEFAULT_MAPPER = new ObjectMapper().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(SerializationFeature.INDENT_OUTPUT, true);

    public static String serializePrettyPrint(Object obj) {
        String jsonAsStr;
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        try {
            jsonAsStr = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new GeneralException(e);
        }
        return jsonAsStr;
    }

    public static String prettyPrintFormatJsonStr(String jsonString) {
        Object object;
        ObjectMapper mapper = new ObjectMapper();
        try {
            object = mapper.readValue(jsonString, Object.class);
        }
        catch (IOException e) {
            throw new GeneralException(e);
        }
        return JacksonUtils.serializePrettyPrint(object);
    }
}

