/*
 * Decompiled with CFR 0.152.
 */
package hdi.util;

import java.io.File;
import java.nio.charset.Charset;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class FilesUtils {
    public static final String APP_CONF_DIR_NAME = "ediconvert";

    public static String getNameWithoutExt(File file) {
        String fileName = file.getName();
        int extPos = fileName.lastIndexOf(46);
        if (extPos >= 0) {
            fileName = fileName.substring(0, extPos);
        }
        return fileName;
    }

    public static String getFileNameWithSuffix(File file, String suffix) {
        String ext = FilenameUtils.getExtension((String)file.getName());
        String baseName = FilenameUtils.getBaseName((String)file.getName());
        String newName = baseName + suffix;
        if (StringUtils.isNotBlank((CharSequence)ext)) {
            newName = newName + "." + ext;
        }
        return newName;
    }

    public static File replaceExt(File file, String ext) {
        Object newName = FilenameUtils.getBaseName((String)file.getName());
        File dir = file.getParentFile();
        if (StringUtils.isNotBlank((CharSequence)ext)) {
            newName = (String)newName + "." + ext;
        }
        return new File(dir, (String)newName);
    }

    public static String replaceExt(String fileName, String ext) {
        return FilesUtils.replaceExt(new File(fileName), ext).getPath();
    }

    public static void downloadFileToTemp(String urlStr, String fileName) {
    }

    public static String readFileToString(File file) {
        return FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
    }

    public static DirAndPatterns inferPatternsFromInputFileOrDir(File ediFileOrDir) {
        String fileName = ediFileOrDir.getName();
        if (StringUtils.containsAny((CharSequence)fileName, (CharSequence[])new CharSequence[]{"*", "?"})) {
            File dir = ediFileOrDir.getParentFile();
            if (dir == null) {
                dir = new File(".");
            }
            return new DirAndPatterns(dir, fileName);
        }
        return null;
    }

    public record DirAndPatterns(File dir, String patterns) {
    }
}

