/*
 * Decompiled with CFR 0.152.
 */
package hdi.util;

import hdi.util.WordStringUtils;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.FalseFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileScanner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FileScanner.class);

    public static Collection<File> scanFiles(String baseDirStr, String includePatterns, boolean isRecursive) {
        List<String> patterns = StringUtils.isNotBlank((CharSequence)includePatterns) ? WordStringUtils.listStringToList(includePatterns) : List.of("*");
        log.debug("Scanning {} for files matching {}, recursive: {}", new Object[]{baseDirStr, patterns, isRecursive});
        WildcardFileFilter.Builder wfb = new WildcardFileFilter.Builder();
        WildcardFileFilter filter = wfb.setIoCase(IOCase.INSENSITIVE).setWildcards(patterns).get();
        File baseDir = new File(baseDirStr);
        IOFileFilter dirFilter = FalseFileFilter.FALSE;
        if (isRecursive) {
            dirFilter = TrueFileFilter.TRUE;
        }
        Collection fileCandidates = FileUtils.listFiles((File)baseDir, (IOFileFilter)filter, (IOFileFilter)dirFilter);
        fileCandidates = fileCandidates.stream().filter(f -> !StringUtils.startsWith((CharSequence)f.getName(), (CharSequence)".")).collect(Collectors.toList());
        log.debug("Found {} files in {}", (Object)fileCandidates.size(), (Object)baseDir.getAbsolutePath());
        return fileCandidates;
    }
}

