/*
 * Decompiled with CFR 0.152.
 */
package hdi.util;

import java.time.LocalDate;
import java.time.Period;
import java.time.temporal.ChronoUnit;
import org.apache.commons.lang3.StringUtils;

public class DateUtils {
    public static LocalDate earliest(LocalDate ... dates) {
        LocalDate foundDate = null;
        for (LocalDate d : dates) {
            if ((foundDate != null || d == null) && (d == null || !d.isBefore(foundDate))) continue;
            foundDate = d;
        }
        return foundDate;
    }

    public static LocalDate latest(LocalDate ... dates) {
        LocalDate foundDate = null;
        for (LocalDate d : dates) {
            if (foundDate != null && (d == null || !d.isAfter(foundDate))) continue;
            foundDate = d;
        }
        return foundDate;
    }

    public static Integer age(LocalDate birthDate, LocalDate ageOnThisDate) {
        if (birthDate != null) {
            Period p = Period.between(birthDate, ageOnThisDate);
            return p.getYears();
        }
        return null;
    }

    public static LocalDate parseYear(String yearStr) {
        int year = DateUtils.extractYear(yearStr);
        if (year < 0) {
            return null;
        }
        return LocalDate.of(year, 1, 1);
    }

    public static LocalDate parseYearMonth(String str) {
        int year = DateUtils.extractYear(str);
        int month = DateUtils.extractMonth(str);
        if (year <= 0 || month <= 0) {
            return null;
        }
        return LocalDate.of(year, month, 1);
    }

    private static int extractYear(String str) {
        if (!StringUtils.isNumeric((CharSequence)(str = StringUtils.left((String)str, (int)4)))) {
            return -1;
        }
        return Integer.parseInt(str);
    }

    private static int extractMonth(String str) {
        if (!StringUtils.isNumeric((CharSequence)(str = StringUtils.right((String)str, (int)2)))) {
            return -1;
        }
        return Integer.parseInt(str);
    }

    public static String dateToPeriod(LocalDate date, ChronoUnit chronoUnit) {
        Object period;
        if (chronoUnit == ChronoUnit.MONTHS) {
            period = date.getYear() + "-" + StringUtils.leftPad((String)Integer.toString(date.getMonthValue()), (int)2, (char)'0');
        } else if (chronoUnit == ChronoUnit.YEARS) {
            period = Integer.toString(date.getYear());
        } else {
            throw new IllegalArgumentException("We only support month and year. Provided: " + String.valueOf(chronoUnit));
        }
        return period;
    }
}

