/*
 * Decompiled with CFR 0.152.
 */
package hdi.ncpdp;

import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.Elt;
import hdi.edi.parser.EltSet;
import hdi.ncpdp.NcpdpSegment;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class NcpdpTransaction {
    private NcpdpSegment detailHeader;
    private final List<NcpdpSegment> segments = new ArrayList<NcpdpSegment>();

    public void addSeg(NcpdpSegment segment) {
        this.segments.add(segment);
    }

    public String toFriendlyString() {
        StringBuilder buf = new StringBuilder();
        if (this.detailHeader != null) {
            buf.append(this.detailHeader).append("\n");
        }
        for (NcpdpSegment seg : this.segments) {
            buf.append(seg.toFriendlyString()).append("\n");
        }
        return buf.toString();
    }

    public EdiSeg toEdiSeg() {
        EdiSeg tranEdiSeg;
        if (this.detailHeader != null) {
            tranEdiSeg = this.detailHeader.toEdiSeg();
        } else {
            tranEdiSeg = new EdiSeg("NCP", "transaction_header");
            EltSet tranEltSet = new EltSet(tranEdiSeg);
            tranEdiSeg.eltSet(tranEltSet);
            tranEltSet.add(Elt.fromSimpleVal("transaction_type", "B1"));
        }
        for (NcpdpSegment ncpdpSeg : this.segments) {
            tranEdiSeg.addChild(ncpdpSeg.toEdiSeg());
        }
        if (!tranEdiSeg.childSegs().isEmpty()) {
            tranEdiSeg.isLoopParent(true);
        }
        return tranEdiSeg;
    }

    @Generated
    public NcpdpSegment detailHeader() {
        return this.detailHeader;
    }

    @Generated
    public List<NcpdpSegment> segments() {
        return this.segments;
    }

    @Generated
    public String toString() {
        return "NcpdpTransaction(detailHeader=" + String.valueOf(this.detailHeader()) + ", segments=" + String.valueOf(this.segments()) + ")";
    }

    @Generated
    public NcpdpTransaction detailHeader(NcpdpSegment detailHeader) {
        this.detailHeader = detailHeader;
        return this;
    }
}

