/*
 * Decompiled with CFR 0.152.
 */
package hdi.ncpdp;

import hdi.edi.openedi.TransactionSchema;
import hdi.ncpdp.NcpdpHeader;
import hdi.ncpdp.NcpdpParsingResults;
import hdi.ncpdp.NcpdpSegment;
import hdi.ncpdp.NcpdpSeparator;
import hdi.ncpdp.NcpdpTransaction;
import java.io.Reader;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcpdpParsingState {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NcpdpParsingState.class);
    private TransactionSchema transactionSchema = new TransactionSchema();
    private final NcpdpParsingResults results = new NcpdpParsingResults();
    private Reader reader;
    private NcpdpSeparator separatorToReparse;
    private boolean isEndOfFileReached;
    private NcpdpSegment curSeg;
    private NcpdpTransaction curTran;
    private boolean isStartOfFile = true;

    public boolean isParsingStart() {
        return this.curTran == null && this.results.transactions().isEmpty() && this.curSeg == null;
    }

    void setHeader(NcpdpHeader header) {
        this.results.header(header);
    }

    void completeSeg() {
        if (this.curSeg == null) {
            return;
        }
        if (this.curTran == null) {
            log.warn("Attempt to complete segment parsing without active transaction. Segment:\n{}", (Object)this.curSeg);
            this.curTran = new NcpdpTransaction();
        }
        this.curTran.addSeg(this.curSeg);
        this.curSeg = null;
    }

    void completeTran() {
        if (this.curTran == null) {
            return;
        }
        this.completeSeg();
        this.results.addTran(this.curTran);
        this.curTran = null;
    }

    @Generated
    public TransactionSchema transactionSchema() {
        return this.transactionSchema;
    }

    @Generated
    public NcpdpParsingResults results() {
        return this.results;
    }

    @Generated
    public Reader reader() {
        return this.reader;
    }

    @Generated
    public NcpdpSeparator separatorToReparse() {
        return this.separatorToReparse;
    }

    @Generated
    public boolean isEndOfFileReached() {
        return this.isEndOfFileReached;
    }

    @Generated
    public NcpdpSegment curSeg() {
        return this.curSeg;
    }

    @Generated
    public NcpdpTransaction curTran() {
        return this.curTran;
    }

    @Generated
    public boolean isStartOfFile() {
        return this.isStartOfFile;
    }

    @Generated
    public NcpdpParsingState transactionSchema(TransactionSchema transactionSchema) {
        this.transactionSchema = transactionSchema;
        return this;
    }

    @Generated
    public NcpdpParsingState reader(Reader reader) {
        this.reader = reader;
        return this;
    }

    @Generated
    public NcpdpParsingState separatorToReparse(NcpdpSeparator separatorToReparse) {
        this.separatorToReparse = separatorToReparse;
        return this;
    }

    @Generated
    public NcpdpParsingState isEndOfFileReached(boolean isEndOfFileReached) {
        this.isEndOfFileReached = isEndOfFileReached;
        return this;
    }

    @Generated
    public NcpdpParsingState curSeg(NcpdpSegment curSeg) {
        this.curSeg = curSeg;
        return this;
    }

    @Generated
    public NcpdpParsingState curTran(NcpdpTransaction curTran) {
        this.curTran = curTran;
        return this;
    }

    @Generated
    public NcpdpParsingState isStartOfFile(boolean isStartOfFile) {
        this.isStartOfFile = isStartOfFile;
        return this;
    }
}

