/*
 * Decompiled with CFR 0.152.
 */
package hdi.ncpdp;

import hdi.ncpdp.NcpdpHeader;
import hdi.ncpdp.NcpdpTrailer;
import hdi.ncpdp.NcpdpTransaction;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcpdpParsingResults {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NcpdpParsingResults.class);
    private NcpdpHeader header;
    private NcpdpTrailer trailer;
    private final List<NcpdpTransaction> transactions = new ArrayList<NcpdpTransaction>();

    public void header(NcpdpHeader header) {
        if (this.header != null) {
            log.warn("Attempt to override control header. There could only be one header. Header:\n{}", (Object)header);
        } else {
            this.header = header;
        }
    }

    public void addTran(NcpdpTransaction tran) {
        this.transactions.add(tran);
    }

    public String toFriendlyString() {
        StringBuilder buf = new StringBuilder();
        if (this.header != null) {
            buf.append(this.header).append("\n");
        }
        for (NcpdpTransaction tran : this.transactions) {
            buf.append(tran.toFriendlyString()).append("\n");
        }
        return buf.toString();
    }

    @Generated
    public NcpdpHeader header() {
        return this.header;
    }

    @Generated
    public NcpdpTrailer trailer() {
        return this.trailer;
    }

    @Generated
    public List<NcpdpTransaction> transactions() {
        return this.transactions;
    }
}

