/*
 * Decompiled with CFR 0.152.
 */
package hdi.ncpdp;

import com.fasterxml.jackson.databind.JsonNode;
import hdi.edi.codecollector.CodeEntityCollector;
import hdi.edi.codecollector.CodeEntityHolder;
import hdi.edi.codecollector.CodeEntityResolver;
import hdi.edi.fileinfo.FileInfo;
import hdi.edi.openedi.OpenEdiNames;
import hdi.edi.openedi.OpenEdiSchemaHolder;
import hdi.edi.openedi.TransactionSchema;
import hdi.edi.parser.EdiParserException;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parserhelper.EdiSegJsonConverter;
import hdi.ncpdp.FixedWidthParser;
import hdi.ncpdp.NcpdpField;
import hdi.ncpdp.NcpdpHeader;
import hdi.ncpdp.NcpdpParsingResults;
import hdi.ncpdp.NcpdpParsingState;
import hdi.ncpdp.NcpdpSegment;
import hdi.ncpdp.NcpdpSeparator;
import hdi.ncpdp.NcpdpTransaction;
import hdi.ncpdp.ReadInfo;
import hdi.util.Loggers;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NcpdpParser
implements Loggers,
OpenEdiNames {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NcpdpParser.class);
    public static final String DEFAULT_TRANSACTION_ID = "B1";
    public static final String DETAIL_HEADER_ID = "G1";
    private final OpenEdiSchemaHolder openEdiSchemaHolder = new OpenEdiSchemaHolder();
    private final CodeEntityCollector codeEntityCollector = new CodeEntityCollector();
    private CodeEntityResolver codeResolver;
    private final EdiSegJsonConverter jsonConverter = new EdiSegJsonConverter();
    public static final String NCPDP_SEPARATOR_MESSAGE = "Valid separators (hex): Segment: <1E>. Field: <1C>. Transaction or header: <02>";
    private static final String FAKE_TRAN_REF_NUM_FOR_HEADER = StringUtils.repeat((char)' ', (int)10);
    public static final String TRANSACTION_CODE_NAME = "transaction_code";
    private final FixedWidthParser fixedWidthParser = new FixedWidthParser();

    public NcpdpParser(CodeEntityResolver codeResolver) {
        this.codeResolver = codeResolver;
    }

    public EdiParsingResults parseAsEdi(FileInfo fileInfo, int numberOfTransactions) {
        EdiParsingResults ediResults = new EdiParsingResults(fileInfo);
        NcpdpParsingResults ncpdpResults = this.parseAll(fileInfo, numberOfTransactions);
        for (NcpdpTransaction tran : ncpdpResults.transactions()) {
            ediResults.segs().add(tran.toEdiSeg());
        }
        CodeEntityHolder codeEntHolder = this.codeEntityCollector.processEdi(ediResults.segs());
        if (this.codeResolver != null) {
            this.codeResolver.resolve(codeEntHolder);
        }
        ediResults.addCodeEntities(codeEntHolder.codes());
        return ediResults;
    }

    public JsonNode parseAsJson(FileInfo fileInfo, int numberOfTransactions) {
        EdiParsingResults parsingResults = this.parseAsEdi(fileInfo, numberOfTransactions);
        return this.jsonConverter.convertNcpdpSegs(parsingResults.segs());
    }

    public NcpdpParsingResults parseAll(FileInfo fileInfo, int numberOfTransactions) {
        NcpdpParsingState state = new NcpdpParsingState();
        TransactionSchema transactionSchema = this.openEdiSchemaHolder.getSchema(DEFAULT_TRANSACTION_ID, null);
        if (transactionSchema == null) {
            log.warn("Did not find schema for NCPDP transaction {}", (Object)DEFAULT_TRANSACTION_ID);
        } else {
            state.transactionSchema(transactionSchema);
        }
        try (BufferedReader reader = fileInfo.getContent();){
            state.reader(reader);
            this.parseTrans(state, numberOfTransactions);
        }
        return state.results();
    }

    private void parseTrans(NcpdpParsingState state, int numberOfTransToParse) {
        while (true) {
            ReadInfo readInfo = this.readUntilNextSeparator(state);
            NcpdpSeparator separator = readInfo.separator();
            if (state.isParsingStart()) {
                this.validateParsingStart(state, readInfo);
            }
            if (separator != NcpdpSeparator.FIELD) {
                state.completeSeg();
            }
            if (separator != NcpdpSeparator.FIELD && separator != NcpdpSeparator.SEGMENT && separator != NcpdpSeparator.GROUP) {
                state.completeTran();
            }
            if (state.results().transactions().size() >= numberOfTransToParse && numberOfTransToParse > -1 || separator == NcpdpSeparator.END_OF_FILE) break;
            if (separator == NcpdpSeparator.FIELD) {
                this.parseField(state);
                continue;
            }
            if (separator == NcpdpSeparator.SEGMENT) {
                this.parseSeg(state);
                continue;
            }
            if (separator == NcpdpSeparator.START_OF_FILE) {
                this.parseTelcoHeader(state, readInfo.str());
                continue;
            }
            if (separator != NcpdpSeparator.START_OF_HEADER_OR_TRAN) continue;
            this.parseHeaderOrTransaction(state);
        }
    }

    public void validateParsingStart(NcpdpParsingState state, ReadInfo readInfo) {
        NcpdpSeparator sep = readInfo.separator();
        this.validateThatWeFoundSeparators(sep);
        if (sep != NcpdpSeparator.SEGMENT && sep != NcpdpSeparator.START_OF_HEADER_OR_TRAN && sep != NcpdpSeparator.START_OF_FILE) {
            String msgFormat = "Expected a segment or a transaction separator. Found %s separator instead. Valid separators (hex): Segment: <1E>. Field: <1C>. Transaction or header: <02>";
            String msg = String.format(msgFormat, sep.desc());
            throw new EdiParserException(msg, new Object[0]);
        }
    }

    private void validateThatWeFoundSeparators(NcpdpSeparator ncpdpSeparator) {
        if (ncpdpSeparator == NcpdpSeparator.END_OF_FILE) {
            String msg = "Did not find any separators. Is this a valid NCPDP telco file? Valid separators (hex): Segment: <1E>. Field: <1C>. Transaction or header: <02>";
            throw new EdiParserException(msg, new Object[0]);
        }
    }

    private void parseSeg(NcpdpParsingState state) {
        NcpdpSegment seg = new NcpdpSegment(state.transactionSchema());
        state.curSeg(seg);
    }

    private void parseTelcoHeader(NcpdpParsingState state, String charsToPrepend) {
        ReadInfo readInfo = this.readUntilNextSeparator(state);
        this.validateThatWeFoundSeparators(readInfo.separator());
        state.separatorToReparse(readInfo.separator());
        Object headerStrToParse = readInfo.str();
        if (charsToPrepend != null) {
            headerStrToParse = charsToPrepend + (String)headerStrToParse;
        }
        headerStrToParse = FAKE_TRAN_REF_NUM_FOR_HEADER + (String)headerStrToParse;
        this.parseDetailHeader(state, (String)headerStrToParse);
    }

    private void parseHeaderOrTransaction(NcpdpParsingState state) {
        ReadInfo readInfo = this.readUntilNextSeparator(state);
        String headerId = StringUtils.left((String)readInfo.str(), (int)2);
        if ("00".equals(headerId)) {
            this.parseControlHeader(state, readInfo.str());
        } else if ("99".equals(headerId)) {
            this.parseControlTrailer(state, readInfo.str());
        } else if (DETAIL_HEADER_ID.equals(headerId)) {
            state.separatorToReparse(readInfo.separator());
            this.parseDetailHeader(state, readInfo.str());
        } else {
            log.warn("Unknown header or trailer type:\n{}", (Object)readInfo.str());
        }
    }

    private void parseControlHeader(NcpdpParsingState state, String currentStrToParse) {
        NcpdpHeader header = new NcpdpHeader().str(currentStrToParse);
        state.setHeader(header);
    }

    private void parseControlTrailer(NcpdpParsingState state, String currentStrToParse) {
    }

    private void parseDetailHeader(NcpdpParsingState state, String currentStrToParse) {
        NcpdpTransaction tran = new NcpdpTransaction();
        state.curTran(tran);
        NcpdpSegment seg = new NcpdpSegment(DETAIL_HEADER_ID, state.transactionSchema());
        if (StringUtils.contains((CharSequence)currentStrToParse, (CharSequence)DETAIL_HEADER_ID)) {
            currentStrToParse = StringUtils.substringAfter((String)currentStrToParse, (String)DETAIL_HEADER_ID);
        }
        if (seg.schema() != null) {
            List<NcpdpField> fields = this.fixedWidthParser.parseFixedWidthRecord(seg.schema(), currentStrToParse);
            seg.fields().addAll(fields);
            tran.detailHeader(seg);
            Object tranCode = seg.findFieldVal(TRANSACTION_CODE_NAME);
            if (tranCode != null && !tranCode.equals(DEFAULT_TRANSACTION_ID)) {
                TransactionSchema transactionSchema = this.openEdiSchemaHolder.getSchema(tranCode.toString(), null);
                if (transactionSchema == null) {
                    log.warn("Did not find schema for the NCPDP transaction code '{}', will use B1", tranCode);
                } else {
                    log.info("Using OpenEDI transaction schema for the code {} found in the header", tranCode);
                    state.transactionSchema(transactionSchema);
                }
            }
        }
    }

    private void parseField(NcpdpParsingState state) {
        ReadInfo readInfo = this.readUntilNextSeparator(state);
        state.separatorToReparse(readInfo.separator());
        NcpdpSegment seg = state.curSeg();
        if (seg == null) {
            log.warn("Attempt to add field without an existing segment. Field;\n{}", (Object)readInfo.str());
            return;
        }
        NcpdpField field = NcpdpField.parse(seg.schema(), readInfo.str());
        seg.addField(field);
    }

    private ReadInfo readUntilNextSeparator(NcpdpParsingState state) {
        NcpdpSeparator separator;
        StringBuilder buf;
        block6: {
            char c;
            NcpdpSeparator separatorToReparse = state.separatorToReparse();
            if (state.separatorToReparse() != null) {
                state.separatorToReparse(null);
                return new ReadInfo(separatorToReparse, "");
            }
            Reader reader = state.reader();
            buf = new StringBuilder();
            do {
                int cInt;
                if ((cInt = reader.read()) < 0) {
                    separator = NcpdpSeparator.END_OF_FILE;
                    state.isEndOfFileReached(true);
                    break block6;
                }
                c = (char)cInt;
                separator = this.matchesOneOfSeparators(c, NcpdpSeparator.realSeparators);
                if (separator != null) {
                    state.isStartOfFile(false);
                    break block6;
                }
                buf.append(c);
            } while (Character.isWhitespace(c) || !state.isStartOfFile());
            state.isStartOfFile(false);
            separator = NcpdpSeparator.START_OF_FILE;
        }
        return new ReadInfo(separator, buf.toString());
    }

    private NcpdpSeparator matchesOneOfSeparators(char c, Collection<NcpdpSeparator> separators) {
        for (NcpdpSeparator sep : separators) {
            if (c != sep.ch() && c != sep.printableCh()) continue;
            return sep;
        }
        return null;
    }

    @Generated
    public NcpdpParser() {
    }

    @Generated
    public NcpdpParser codeResolver(CodeEntityResolver codeResolver) {
        this.codeResolver = codeResolver;
        return this;
    }
}

