/*
 * Decompiled with CFR 0.152.
 */
package hdi.ncpdp;

import hdi.edi.openedi.ElementSchema;
import hdi.edi.openedi.SegSchema;
import hdi.ncpdp.NcpdpField;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class FixedWidthParser {
    List<NcpdpField> parseFixedWidthRecord(SegSchema fixedWidthRecordSchema, String strToParse) {
        ArrayList<NcpdpField> fields = new ArrayList<NcpdpField>();
        List<ElementSchema> eltSchemas = fixedWidthRecordSchema.elts();
        for (ElementSchema eltSchema : eltSchemas) {
            FieldWithRemainingString fieldWithRemainingStr = this.parseField(eltSchema, strToParse);
            fields.add(fieldWithRemainingStr.field);
            strToParse = fieldWithRemainingStr.remainingString;
        }
        return fields;
    }

    private FieldWithRemainingString parseField(ElementSchema eltSchema, String strToParse) {
        Integer length = eltSchema.maxLength();
        if (length == null) {
            throw new IllegalStateException("This element schema must contain max length: " + String.valueOf(eltSchema));
        }
        String fieldStr = StringUtils.left((String)strToParse, (int)length);
        NcpdpField field = NcpdpField.parseFixedLength(eltSchema, fieldStr);
        String remainingStr = StringUtils.substring((String)strToParse, (int)length);
        return new FieldWithRemainingString(field, remainingStr);
    }

    private record FieldWithRemainingString(NcpdpField field, String remainingString) {
    }
}

