/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.status;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.BaseEdiEntity;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.Elt;
import hdi.model.status.StatusActionType;
import hdi.model.status.StatusCodeInfo;
import hdi.util.CollectionUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@EdiObj(seg={"STC"}, desc={"Status Information"})
public class StatusInfo
extends BaseEdiEntity {
    @EdiElt(pos=2, seg="STC")
    private LocalDate effectiveDate;
    @Prop(edi={"STC03"})
    private String actionCode;
    @Prop(edi={"STC03"}, desc={"Status action type (action code translated to constant/enum), ACCEPT or REJECT"})
    private StatusActionType actionType;
    @EdiElt(pos=4, seg="STC")
    private BigDecimal chargeAmount;
    @Prop(objType=ObjType.STATUS_CODE_INFO, edi={"STC01,STC10,STC11"})
    private List<StatusCodeInfo> statusCodeInfos;
    @EdiElt(pos=12, seg="STC")
    private String message;

    @Override
    public void populateFromSegInitial(EdiSeg seg, EdiParsingResults results) {
        super.populateFromSegInitial(seg, results);
        this.populateStatusCodeInfo(seg.eltByPosition(1));
        this.populateStatusCodeInfo(seg.eltByPosition(10));
        this.populateStatusCodeInfo(seg.eltByPosition(11));
    }

    private void populateStatusCodeInfo(Elt statusCodeCompositeElt) {
        if (statusCodeCompositeElt != null && statusCodeCompositeElt.eltSet() != null) {
            StatusCodeInfo statusCodeInfo = new StatusCodeInfo();
            EDI_MAPPER.populateObject(statusCodeInfo, statusCodeCompositeElt.eltSet());
            this.statusCodeInfos = CollectionUtils.addWithInit(this.statusCodeInfos, statusCodeInfo);
        }
    }

    public List<StatusCodeInfo> statusCodeInfos() {
        return this.statusCodeInfos != null ? this.statusCodeInfos : List.of();
    }

    @EdiElt(pos=3, seg="STC")
    public void actionCode(String actionCode) {
        this.actionCode = actionCode;
        this.actionType = StatusActionType.fromEdi(actionCode);
    }

    @Generated
    public LocalDate effectiveDate() {
        return this.effectiveDate;
    }

    @Generated
    public String actionCode() {
        return this.actionCode;
    }

    @Generated
    public StatusActionType actionType() {
        return this.actionType;
    }

    @Generated
    public BigDecimal chargeAmount() {
        return this.chargeAmount;
    }

    @Generated
    public String message() {
        return this.message;
    }

    @Generated
    public String toString() {
        return "StatusInfo(effectiveDate=" + String.valueOf(this.effectiveDate()) + ", actionCode=" + this.actionCode() + ", actionType=" + String.valueOf(this.actionType()) + ", chargeAmount=" + String.valueOf(this.chargeAmount()) + ", statusCodeInfos=" + String.valueOf(this.statusCodeInfos()) + ", message=" + this.message() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatusInfo)) {
            return false;
        }
        StatusInfo other = (StatusInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LocalDate this$effectiveDate = this.effectiveDate();
        LocalDate other$effectiveDate = other.effectiveDate();
        if (this$effectiveDate == null ? other$effectiveDate != null : !((Object)this$effectiveDate).equals(other$effectiveDate)) {
            return false;
        }
        String this$actionCode = this.actionCode();
        String other$actionCode = other.actionCode();
        if (this$actionCode == null ? other$actionCode != null : !this$actionCode.equals(other$actionCode)) {
            return false;
        }
        StatusActionType this$actionType = this.actionType();
        StatusActionType other$actionType = other.actionType();
        if (this$actionType == null ? other$actionType != null : !this$actionType.equals(other$actionType)) {
            return false;
        }
        BigDecimal this$chargeAmount = this.chargeAmount();
        BigDecimal other$chargeAmount = other.chargeAmount();
        if (this$chargeAmount == null ? other$chargeAmount != null : !((Object)this$chargeAmount).equals(other$chargeAmount)) {
            return false;
        }
        List<StatusCodeInfo> this$statusCodeInfos = this.statusCodeInfos();
        List<StatusCodeInfo> other$statusCodeInfos = other.statusCodeInfos();
        if (this$statusCodeInfos == null ? other$statusCodeInfos != null : !((Object)this$statusCodeInfos).equals(other$statusCodeInfos)) {
            return false;
        }
        String this$message = this.message();
        String other$message = other.message();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StatusInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalDate $effectiveDate = this.effectiveDate();
        result = result * 59 + ($effectiveDate == null ? 43 : ((Object)$effectiveDate).hashCode());
        String $actionCode = this.actionCode();
        result = result * 59 + ($actionCode == null ? 43 : $actionCode.hashCode());
        StatusActionType $actionType = this.actionType();
        result = result * 59 + ($actionType == null ? 43 : $actionType.hashCode());
        BigDecimal $chargeAmount = this.chargeAmount();
        result = result * 59 + ($chargeAmount == null ? 43 : ((Object)$chargeAmount).hashCode());
        List<StatusCodeInfo> $statusCodeInfos = this.statusCodeInfos();
        result = result * 59 + ($statusCodeInfos == null ? 43 : ((Object)$statusCodeInfos).hashCode());
        String $message = this.message();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }
}

