/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.status;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import hdi.codeent.CodeEntity;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.model.orgperson.EntityRole;
import lombok.Generated;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@EdiObj(desc={"Contains sub-elements of the composite healthcare claim status element (STC01,STC10,STC11)"})
public class StatusCodeInfo {
    @EdiElt(pos=1)
    @Prop(edi={"STC01-1"})
    private String categoryCode;
    private CodeEntity category;
    @EdiElt(pos=2)
    @Prop(edi={"STC01-2"})
    private String statusCode;
    private CodeEntity status;
    @Prop(edi={"STC01-3"})
    private String entityCode;
    private EntityRole entityRole;

    @EdiElt(pos=3)
    public StatusCodeInfo entityCode(String entityCode) {
        this.entityCode = entityCode;
        this.entityRole = EntityRole.fromEdi(entityCode);
        return this;
    }

    @Generated
    public String toString() {
        return "StatusCodeInfo(categoryCode=" + this.categoryCode() + ", category=" + String.valueOf(this.category()) + ", statusCode=" + this.statusCode() + ", status=" + String.valueOf(this.status()) + ", entityCode=" + this.entityCode() + ", entityRole=" + String.valueOf(this.entityRole()) + ")";
    }

    @Generated
    public String categoryCode() {
        return this.categoryCode;
    }

    @Generated
    public CodeEntity category() {
        return this.category;
    }

    @Generated
    public String statusCode() {
        return this.statusCode;
    }

    @Generated
    public CodeEntity status() {
        return this.status;
    }

    @Generated
    public String entityCode() {
        return this.entityCode;
    }

    @Generated
    public EntityRole entityRole() {
        return this.entityRole;
    }
}

