/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.status;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.EdiEntity;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.model.ObjectType;
import hdi.model.orgperson.OrgOrPerson;
import hdi.model.status.BaseProviderReceiverStatus;
import hdi.model.status.BatchStatus;
import hdi.model.status.ClaimStatus;
import hdi.model.status.ReceiverStatus;
import lombok.Generated;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonPropertyOrder(value={"objectType", "id", "provider", "batchStatus", "transaction"})
@EdiObj(desc={"Status of claims at a provider level. This object is returned only if there is an issue with the billing provider and no individual claim statuses have been provided."})
public class ProviderStatus
extends BaseProviderReceiverStatus {
    @Prop(masterClass=ClaimStatus.class)
    private OrgOrPerson receiver;
    @Prop(masterClass=ClaimStatus.class)
    private BatchStatus receiverBatchStatus;

    public ProviderStatus() {
        super(ObjectType.PROVIDER_STATUS);
    }

    @Override
    protected void populateFromDescendantSeg(EdiSeg seg, EdiEntity segEnt, EdiParsingResults results) {
        super.populateFromDescendantSeg(seg, segEnt, results);
        if (segEnt instanceof ClaimStatus) {
            ClaimStatus claimStatus = (ClaimStatus)segEnt;
            claimStatus.setProviderStatus(this);
            results.statuses().remove(this);
        }
    }

    void setReceiverStatus(ReceiverStatus receiverStatus) {
        this.receiver = receiverStatus.party();
        this.receiverBatchStatus = receiverStatus.batchStatus();
    }

    public OrgOrPerson getProvider() {
        return this.party();
    }

    @Generated
    public OrgOrPerson receiver() {
        return this.receiver;
    }

    @Generated
    public BatchStatus receiverBatchStatus() {
        return this.receiverBatchStatus;
    }

    @Override
    @Generated
    public String toString() {
        return "ProviderStatus(super=" + super.toString() + ", receiver=" + String.valueOf(this.receiver()) + ", receiverBatchStatus=" + String.valueOf(this.receiverBatchStatus()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProviderStatus)) {
            return false;
        }
        ProviderStatus other = (ProviderStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OrgOrPerson this$receiver = this.receiver();
        OrgOrPerson other$receiver = other.receiver();
        if (this$receiver == null ? other$receiver != null : !((Object)this$receiver).equals(other$receiver)) {
            return false;
        }
        BatchStatus this$receiverBatchStatus = this.receiverBatchStatus();
        BatchStatus other$receiverBatchStatus = other.receiverBatchStatus();
        return !(this$receiverBatchStatus == null ? other$receiverBatchStatus != null : !((Object)this$receiverBatchStatus).equals(other$receiverBatchStatus));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProviderStatus;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        OrgOrPerson $receiver = this.receiver();
        result = result * 59 + ($receiver == null ? 43 : ((Object)$receiver).hashCode());
        BatchStatus $receiverBatchStatus = this.receiverBatchStatus();
        result = result * 59 + ($receiverBatchStatus == null ? 43 : ((Object)$receiverBatchStatus).hashCode());
        return result;
    }
}

