/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.status;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import hdi.edi.EdiTransaction;
import hdi.edi.csv.PaymentCsv;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.BaseEdiEntity;
import hdi.edi.edient.EdiEntity;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.model.ClaimOrPayment;
import hdi.model.DateTimePeriod;
import hdi.model.ObjectType;
import hdi.model.Reference;
import hdi.model.claim.Claim;
import hdi.model.enumtype.DateType;
import hdi.model.enumtype.ReferenceType;
import hdi.model.orgperson.EntityRole;
import hdi.model.orgperson.OrgOrPerson;
import hdi.model.status.BatchStatus;
import hdi.model.status.ProviderStatus;
import hdi.model.status.ReceiverProviderClaimStatus;
import hdi.model.status.ReceiverStatus;
import hdi.model.status.ServiceLineStatus;
import hdi.model.status.StatusActionType;
import hdi.model.status.StatusInfo;
import hdi.util.CollectionUtils;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.bson.types.ObjectId;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@EdiObj(loop={"2200D"}, desc={"Status of a single claim. Also contains patient, provider and receiver information."}, jsonExample={"277/277CA-all-fields.json"}, interactiveExample={"277/277ca-all-fields/"})
public class ClaimStatus
extends BaseEdiEntity
implements ReceiverProviderClaimStatus {
    @EdiElt.Exclude
    @Prop(masterClass=PaymentCsv.class)
    private final String id = ObjectId.get().toHexString();
    @EdiElt.Exclude
    @Prop(desc={"Type of this object, always set to 'CLAIM_STATUS'"})
    protected ObjectType objectType = ObjectType.CLAIM_STATUS;
    private OrgOrPerson subscriber;
    @Prop(entityRole=EntityRole.PATIENT, objType=ObjType.PARTY_ID_NAME, loop={"2100D"}, desc={"The insured (subscriber) or patient as stated on 837 claim"})
    private OrgOrPerson patient;
    @EdiElt(pos=2, seg="TRN")
    private String patientControlNumber;
    @Prop(objType=ObjType.STATUS_INFO)
    private List<StatusInfo> statusInfos;
    @Prop(refType={ReferenceType.PAYER_CLAIM_NUMBER})
    private String payerClaimControlNumber;
    @Prop(masterClass=Claim.class)
    private String clearinghouseTraceNumber;
    @Prop(refType={ReferenceType.BILL_TYPE})
    private String billTypeCode;
    @EdiElt.Exclude
    @Prop(dateType={DateType.SERVICE}, desc={"Service date for professional or statement date for institutional"})
    private LocalDate serviceDateFrom;
    @EdiElt.Exclude
    @Prop(dateType={DateType.SERVICE}, desc={"The end date of the service or statement date period. Set to 'serviceDateFrom' if the period is a single date"})
    private LocalDate serviceDateTo;
    @Prop(entityRole=EntityRole.RECEIVER, objType=ObjType.PARTY_ID_NAME, loop={"2000B"}, desc={"The Receiver is the entity that expects the response from the Source. Can be a provider, a provider group, a claims clearinghouse, etc."})
    private OrgOrPerson receiver;
    @Prop(objType=ObjType.BATCH_STATUS, loop={"2200B"})
    private BatchStatus receiverBatchStatus;
    @Prop(entityRole=EntityRole.BILLING_PROVIDER, objType=ObjType.PARTY_ID_NAME, loop={"2100C "}, desc={"Billing provider for 277CA"})
    private OrgOrPerson provider;
    @Prop(objType=ObjType.BATCH_STATUS, loop={"2200C"})
    private BatchStatus providerBatchStatus;
    @Prop(objType=ObjType.SERVICE_LINE_STATUS, loop={"2220D"}, desc={"Rejected service lines"})
    private List<ServiceLineStatus> lineStatuses;
    @EdiElt.Exclude
    @Prop(masterClass=ClaimOrPayment.class)
    private EdiTransaction transaction;

    @Override
    public void populateFromSegInitial(EdiSeg seg, EdiParsingResults results) {
        super.populateFromSegInitial(seg, results);
        this.transaction = new EdiTransaction();
        if (results != null) {
            this.transaction = results.curTransaction();
            this.patient = results.findPartyByRole(EntityRole.PATIENT);
        }
    }

    @Override
    protected void populateFromChildSeg(EdiSeg seg, EdiEntity segEnt) {
        if (segEnt instanceof Reference) {
            Reference reference = (Reference)segEnt;
            if (reference.type() == ReferenceType.PAYER_CLAIM_NUMBER) {
                this.payerClaimControlNumber = reference.identification();
            } else if (reference.type() == ReferenceType.CLAIM_NUMBER) {
                this.clearinghouseTraceNumber = reference.identification();
            } else if (reference.type() == ReferenceType.BILL_TYPE) {
                this.billTypeCode = reference.identification();
            }
        } else if (segEnt instanceof StatusInfo) {
            StatusInfo statusInfo = (StatusInfo)segEnt;
            this.statusInfos = CollectionUtils.addWithInit(this.statusInfos, statusInfo);
        } else if (segEnt instanceof DateTimePeriod) {
            DateTimePeriod dt = (DateTimePeriod)segEnt;
            if (dt.type() == DateType.SERVICE) {
                this.serviceDateFrom = dt.date();
                this.serviceDateTo = dt.dateTo();
                if (this.serviceDateTo == null) {
                    this.serviceDateTo = this.serviceDateFrom;
                }
            }
        } else if (segEnt instanceof ServiceLineStatus) {
            ServiceLineStatus lineStatus = (ServiceLineStatus)segEnt;
            this.lineStatuses = CollectionUtils.addWithInit(this.lineStatuses, lineStatus);
        }
    }

    void setReceiverStatus(ReceiverStatus receiverStatus) {
        this.receiver = receiverStatus.party();
        this.receiverBatchStatus = receiverStatus.batchStatus();
    }

    void setProviderStatus(ProviderStatus providerStatus) {
        this.provider = providerStatus.party();
        this.providerBatchStatus = providerStatus.batchStatus();
    }

    public List<ServiceLineStatus> serviceLineStatuses() {
        return this.lineStatuses == null ? List.of() : this.lineStatuses;
    }

    @Override
    public List<StatusInfo> statusInfos() {
        return this.statusInfos == null ? List.of() : this.statusInfos;
    }

    @JsonIgnore
    public boolean isRejected() {
        for (StatusInfo status : this.statusInfos()) {
            if (status.actionType() != StatusActionType.REJECT) continue;
            return true;
        }
        return false;
    }

    @Override
    public OrgOrPerson party() {
        return this.patient;
    }

    @Override
    public String traceIdentifier() {
        return this.patientControlNumber;
    }

    public void prepForApi() {
        if (this.lineStatuses == null) {
            return;
        }
        for (ServiceLineStatus lineStatus : this.lineStatuses) {
            if (lineStatus.procedure() != null) {
                lineStatus.procedure().trimNiceToHave();
            }
            if (lineStatus.revenueCode() == null) continue;
            lineStatus.revenueCode().trimNiceToHave();
        }
    }

    @Override
    @Generated
    public String id() {
        return this.id;
    }

    @Override
    @Generated
    public ObjectType objectType() {
        return this.objectType;
    }

    @Generated
    public OrgOrPerson subscriber() {
        return this.subscriber;
    }

    @Generated
    public OrgOrPerson patient() {
        return this.patient;
    }

    @Generated
    public String patientControlNumber() {
        return this.patientControlNumber;
    }

    @Generated
    public String payerClaimControlNumber() {
        return this.payerClaimControlNumber;
    }

    @Generated
    public String clearinghouseTraceNumber() {
        return this.clearinghouseTraceNumber;
    }

    @Generated
    public String billTypeCode() {
        return this.billTypeCode;
    }

    @Generated
    public LocalDate serviceDateFrom() {
        return this.serviceDateFrom;
    }

    @Generated
    public LocalDate serviceDateTo() {
        return this.serviceDateTo;
    }

    @Generated
    public OrgOrPerson receiver() {
        return this.receiver;
    }

    @Generated
    public BatchStatus receiverBatchStatus() {
        return this.receiverBatchStatus;
    }

    @Generated
    public OrgOrPerson provider() {
        return this.provider;
    }

    @Generated
    public BatchStatus providerBatchStatus() {
        return this.providerBatchStatus;
    }

    @Generated
    public List<ServiceLineStatus> lineStatuses() {
        return this.lineStatuses;
    }

    @Generated
    public String toString() {
        return "ClaimStatus(subscriber=" + String.valueOf(this.subscriber()) + ", patient=" + String.valueOf(this.patient()) + ", patientControlNumber=" + this.patientControlNumber() + ", statusInfos=" + String.valueOf(this.statusInfos()) + ", payerClaimControlNumber=" + this.payerClaimControlNumber() + ", clearinghouseTraceNumber=" + this.clearinghouseTraceNumber() + ", billTypeCode=" + this.billTypeCode() + ", serviceDateFrom=" + String.valueOf(this.serviceDateFrom()) + ", serviceDateTo=" + String.valueOf(this.serviceDateTo()) + ", receiver=" + String.valueOf(this.receiver()) + ", receiverBatchStatus=" + String.valueOf(this.receiverBatchStatus()) + ", provider=" + String.valueOf(this.provider()) + ", providerBatchStatus=" + String.valueOf(this.providerBatchStatus()) + ", lineStatuses=" + String.valueOf(this.lineStatuses()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClaimStatus)) {
            return false;
        }
        ClaimStatus other = (ClaimStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.id();
        String other$id = other.id();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        ObjectType this$objectType = this.objectType();
        ObjectType other$objectType = other.objectType();
        if (this$objectType == null ? other$objectType != null : !((Object)((Object)this$objectType)).equals((Object)other$objectType)) {
            return false;
        }
        OrgOrPerson this$subscriber = this.subscriber();
        OrgOrPerson other$subscriber = other.subscriber();
        if (this$subscriber == null ? other$subscriber != null : !((Object)this$subscriber).equals(other$subscriber)) {
            return false;
        }
        OrgOrPerson this$patient = this.patient();
        OrgOrPerson other$patient = other.patient();
        if (this$patient == null ? other$patient != null : !((Object)this$patient).equals(other$patient)) {
            return false;
        }
        String this$patientControlNumber = this.patientControlNumber();
        String other$patientControlNumber = other.patientControlNumber();
        if (this$patientControlNumber == null ? other$patientControlNumber != null : !this$patientControlNumber.equals(other$patientControlNumber)) {
            return false;
        }
        List<StatusInfo> this$statusInfos = this.statusInfos();
        List<StatusInfo> other$statusInfos = other.statusInfos();
        if (this$statusInfos == null ? other$statusInfos != null : !((Object)this$statusInfos).equals(other$statusInfos)) {
            return false;
        }
        String this$payerClaimControlNumber = this.payerClaimControlNumber();
        String other$payerClaimControlNumber = other.payerClaimControlNumber();
        if (this$payerClaimControlNumber == null ? other$payerClaimControlNumber != null : !this$payerClaimControlNumber.equals(other$payerClaimControlNumber)) {
            return false;
        }
        String this$clearinghouseTraceNumber = this.clearinghouseTraceNumber();
        String other$clearinghouseTraceNumber = other.clearinghouseTraceNumber();
        if (this$clearinghouseTraceNumber == null ? other$clearinghouseTraceNumber != null : !this$clearinghouseTraceNumber.equals(other$clearinghouseTraceNumber)) {
            return false;
        }
        String this$billTypeCode = this.billTypeCode();
        String other$billTypeCode = other.billTypeCode();
        if (this$billTypeCode == null ? other$billTypeCode != null : !this$billTypeCode.equals(other$billTypeCode)) {
            return false;
        }
        LocalDate this$serviceDateFrom = this.serviceDateFrom();
        LocalDate other$serviceDateFrom = other.serviceDateFrom();
        if (this$serviceDateFrom == null ? other$serviceDateFrom != null : !((Object)this$serviceDateFrom).equals(other$serviceDateFrom)) {
            return false;
        }
        LocalDate this$serviceDateTo = this.serviceDateTo();
        LocalDate other$serviceDateTo = other.serviceDateTo();
        if (this$serviceDateTo == null ? other$serviceDateTo != null : !((Object)this$serviceDateTo).equals(other$serviceDateTo)) {
            return false;
        }
        OrgOrPerson this$receiver = this.receiver();
        OrgOrPerson other$receiver = other.receiver();
        if (this$receiver == null ? other$receiver != null : !((Object)this$receiver).equals(other$receiver)) {
            return false;
        }
        BatchStatus this$receiverBatchStatus = this.receiverBatchStatus();
        BatchStatus other$receiverBatchStatus = other.receiverBatchStatus();
        if (this$receiverBatchStatus == null ? other$receiverBatchStatus != null : !((Object)this$receiverBatchStatus).equals(other$receiverBatchStatus)) {
            return false;
        }
        OrgOrPerson this$provider = this.provider();
        OrgOrPerson other$provider = other.provider();
        if (this$provider == null ? other$provider != null : !((Object)this$provider).equals(other$provider)) {
            return false;
        }
        BatchStatus this$providerBatchStatus = this.providerBatchStatus();
        BatchStatus other$providerBatchStatus = other.providerBatchStatus();
        if (this$providerBatchStatus == null ? other$providerBatchStatus != null : !((Object)this$providerBatchStatus).equals(other$providerBatchStatus)) {
            return false;
        }
        List<ServiceLineStatus> this$lineStatuses = this.lineStatuses();
        List<ServiceLineStatus> other$lineStatuses = other.lineStatuses();
        if (this$lineStatuses == null ? other$lineStatuses != null : !((Object)this$lineStatuses).equals(other$lineStatuses)) {
            return false;
        }
        EdiTransaction this$transaction = this.transaction();
        EdiTransaction other$transaction = other.transaction();
        return !(this$transaction == null ? other$transaction != null : !((Object)this$transaction).equals(other$transaction));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClaimStatus;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.id();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        ObjectType $objectType = this.objectType();
        result = result * 59 + ($objectType == null ? 43 : ((Object)((Object)$objectType)).hashCode());
        OrgOrPerson $subscriber = this.subscriber();
        result = result * 59 + ($subscriber == null ? 43 : ((Object)$subscriber).hashCode());
        OrgOrPerson $patient = this.patient();
        result = result * 59 + ($patient == null ? 43 : ((Object)$patient).hashCode());
        String $patientControlNumber = this.patientControlNumber();
        result = result * 59 + ($patientControlNumber == null ? 43 : $patientControlNumber.hashCode());
        List<StatusInfo> $statusInfos = this.statusInfos();
        result = result * 59 + ($statusInfos == null ? 43 : ((Object)$statusInfos).hashCode());
        String $payerClaimControlNumber = this.payerClaimControlNumber();
        result = result * 59 + ($payerClaimControlNumber == null ? 43 : $payerClaimControlNumber.hashCode());
        String $clearinghouseTraceNumber = this.clearinghouseTraceNumber();
        result = result * 59 + ($clearinghouseTraceNumber == null ? 43 : $clearinghouseTraceNumber.hashCode());
        String $billTypeCode = this.billTypeCode();
        result = result * 59 + ($billTypeCode == null ? 43 : $billTypeCode.hashCode());
        LocalDate $serviceDateFrom = this.serviceDateFrom();
        result = result * 59 + ($serviceDateFrom == null ? 43 : ((Object)$serviceDateFrom).hashCode());
        LocalDate $serviceDateTo = this.serviceDateTo();
        result = result * 59 + ($serviceDateTo == null ? 43 : ((Object)$serviceDateTo).hashCode());
        OrgOrPerson $receiver = this.receiver();
        result = result * 59 + ($receiver == null ? 43 : ((Object)$receiver).hashCode());
        BatchStatus $receiverBatchStatus = this.receiverBatchStatus();
        result = result * 59 + ($receiverBatchStatus == null ? 43 : ((Object)$receiverBatchStatus).hashCode());
        OrgOrPerson $provider = this.provider();
        result = result * 59 + ($provider == null ? 43 : ((Object)$provider).hashCode());
        BatchStatus $providerBatchStatus = this.providerBatchStatus();
        result = result * 59 + ($providerBatchStatus == null ? 43 : ((Object)$providerBatchStatus).hashCode());
        List<ServiceLineStatus> $lineStatuses = this.lineStatuses();
        result = result * 59 + ($lineStatuses == null ? 43 : ((Object)$lineStatuses).hashCode());
        EdiTransaction $transaction = this.transaction();
        result = result * 59 + ($transaction == null ? 43 : ((Object)$transaction).hashCode());
        return result;
    }

    @Override
    @Generated
    public EdiTransaction transaction() {
        return this.transaction;
    }
}

