/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.status;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import hdi.edi.EdiTransaction;
import hdi.edi.csv.PaymentCsv;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.BaseEdiEntity;
import hdi.edi.edient.EdiEntity;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.model.ClaimOrPayment;
import hdi.model.ObjectType;
import hdi.model.orgperson.OrgOrPerson;
import hdi.model.status.BatchStatus;
import hdi.model.status.ReceiverProviderClaimStatus;
import hdi.model.status.StatusInfo;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class BaseProviderReceiverStatus
extends BaseEdiEntity
implements ReceiverProviderClaimStatus {
    @EdiElt.Exclude
    @Prop(masterClass=PaymentCsv.class)
    private String id = ObjectId.get().toHexString();
    @Prop(desc={"Type of this object, set to 'PROVIDER_STATUS' or 'RECEIVER_STATUS'"})
    private final ObjectType objectType;
    @JsonIgnore
    private OrgOrPerson party;
    @Prop(objType=ObjType.BATCH_STATUS)
    private BatchStatus batchStatus;
    @Prop(masterClass=ClaimOrPayment.class)
    private EdiTransaction transaction;

    public BaseProviderReceiverStatus(ObjectType objectType) {
        this.objectType = objectType;
    }

    @Override
    public void populateFromSegInitial(EdiSeg seg, EdiParsingResults results) {
        super.populateFromSegInitial(seg, results);
        this.transaction = new EdiTransaction();
        if (results != null) {
            this.transaction = results.curTransaction();
        }
    }

    @Override
    protected void populateFromDescendantSeg(EdiSeg seg, EdiEntity segEnt, EdiParsingResults results) {
        if (this.isRelatedLoop(seg)) {
            if (segEnt instanceof OrgOrPerson) {
                OrgOrPerson p;
                this.party = p = (OrgOrPerson)segEnt;
            } else if (segEnt instanceof BatchStatus) {
                BatchStatus rps;
                this.batchStatus = rps = (BatchStatus)segEnt;
            }
        }
    }

    protected boolean isRelatedLoop(EdiSeg seg) {
        String myLoopSuffix = StringUtils.right((String)this.seg.loop(), (int)1);
        String segLoopSuffix = StringUtils.right((String)seg.loop(), (int)1);
        return StringUtils.equals((CharSequence)myLoopSuffix, (CharSequence)segLoopSuffix);
    }

    void setTransaction(EdiTransaction ediTransaction) {
        this.transaction = ediTransaction;
    }

    @Override
    public String traceIdentifier() {
        if (this.batchStatus != null) {
            return this.batchStatus.traceIdentifier();
        }
        return null;
    }

    @Override
    public List<StatusInfo> statusInfos() {
        if (this.batchStatus != null) {
            return this.batchStatus.statusInfos();
        }
        return List.of();
    }

    @Override
    @Generated
    public String id() {
        return this.id;
    }

    @Override
    @Generated
    public ObjectType objectType() {
        return this.objectType;
    }

    @Override
    @JsonIgnore
    @Generated
    public OrgOrPerson party() {
        return this.party;
    }

    @Generated
    public BatchStatus batchStatus() {
        return this.batchStatus;
    }

    @Override
    @Generated
    public EdiTransaction transaction() {
        return this.transaction;
    }

    @Generated
    public String toString() {
        return "BaseProviderReceiverStatus(objectType=" + String.valueOf((Object)this.objectType()) + ", party=" + String.valueOf(this.party()) + ", batchStatus=" + String.valueOf(this.batchStatus()) + ", transaction=" + String.valueOf(this.transaction()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseProviderReceiverStatus)) {
            return false;
        }
        BaseProviderReceiverStatus other = (BaseProviderReceiverStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.id();
        String other$id = other.id();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        ObjectType this$objectType = this.objectType();
        ObjectType other$objectType = other.objectType();
        if (this$objectType == null ? other$objectType != null : !((Object)((Object)this$objectType)).equals((Object)other$objectType)) {
            return false;
        }
        OrgOrPerson this$party = this.party();
        OrgOrPerson other$party = other.party();
        if (this$party == null ? other$party != null : !((Object)this$party).equals(other$party)) {
            return false;
        }
        BatchStatus this$batchStatus = this.batchStatus();
        BatchStatus other$batchStatus = other.batchStatus();
        if (this$batchStatus == null ? other$batchStatus != null : !((Object)this$batchStatus).equals(other$batchStatus)) {
            return false;
        }
        EdiTransaction this$transaction = this.transaction();
        EdiTransaction other$transaction = other.transaction();
        return !(this$transaction == null ? other$transaction != null : !((Object)this$transaction).equals(other$transaction));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BaseProviderReceiverStatus;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.id();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        ObjectType $objectType = this.objectType();
        result = result * 59 + ($objectType == null ? 43 : ((Object)((Object)$objectType)).hashCode());
        OrgOrPerson $party = this.party();
        result = result * 59 + ($party == null ? 43 : ((Object)$party).hashCode());
        BatchStatus $batchStatus = this.batchStatus();
        result = result * 59 + ($batchStatus == null ? 43 : ((Object)$batchStatus).hashCode());
        EdiTransaction $transaction = this.transaction();
        result = result * 59 + ($transaction == null ? 43 : ((Object)$transaction).hashCode());
        return result;
    }

    @Generated
    public BaseProviderReceiverStatus id(String id) {
        this.id = id;
        return this;
    }
}

