/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.payment;

import hdi.edi.qualifier.EdiQualifier;
import lombok.Generated;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;

public enum TransactionHandlingType implements EdiQualifier
{
    PAYMENT_AND_ADVICE("C", "Payment accompanies remittance advice"),
    PAYMENT_ONLY("D", "Make payment only"),
    NOTIFICATION_ONLY("H", "Notification only"),
    INFORMATION_ONLY("I", "Remittance information only"),
    PRENOTIFICATION("P", "Prenotification of Future Transfers"),
    SPLIT("U", "Split Payment and Remittance"),
    SPLIT_OR_PAYMENT_AND_ADVICE("X", "Handling Party's Option to Split Payment and Remittance");

    private final String ediValue;
    private final String desc;

    public static TransactionHandlingType fromEdi(String ediCode) {
        for (TransactionHandlingType v : TransactionHandlingType.values()) {
            if (v.ediValue == null || !StringUtils.equalsIgnoreCase((CharSequence)ediCode, (CharSequence)v.ediValue)) continue;
            return v;
        }
        return null;
    }

    @Override
    @Generated
    public String ediValue() {
        return this.ediValue;
    }

    @Override
    @Generated
    public String desc() {
        return this.desc;
    }

    @Generated
    private TransactionHandlingType(String ediValue, String desc) {
        this.ediValue = ediValue;
        this.desc = desc;
    }

    @WritingConverter
    public static class ToBson
    implements Converter<TransactionHandlingType, String> {
        public String convert(TransactionHandlingType enm) {
            return enm.name();
        }
    }

    @ReadingConverter
    public static class FromBson
    implements Converter<String, TransactionHandlingType> {
        public TransactionHandlingType convert(@NotNull String s) {
            return (TransactionHandlingType)EnumUtils.getEnumIgnoreCase(TransactionHandlingType.class, (String)s);
        }
    }
}

