/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.payment;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import hdi.edi.EdiTransaction;
import hdi.edi.csv.PaymentCsv;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.BaseEdiEntity;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.DataType;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.Elt;
import hdi.edi.parser.EltSet;
import hdi.model.ObjectType;
import hdi.model.RootObj;
import hdi.model.orgperson.OrgOrPerson;
import hdi.model.payment.ProviderAdjustmentReasonAmount;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@EdiObj(seg={"PLB"}, jsonExample={"835/835-provider-level-adjustment"}, desc={"Provider level adjustment information for debit or credit transactions such as, accelerated payments, cost report settlements for a fiscal year and timeliness report penalties unrelated to a specific claim or service"})
public class ProviderAdjustment
extends BaseEdiEntity
implements RootObj {
    @EdiElt.Exclude
    @Prop(masterClass=PaymentCsv.class)
    private final String id = ObjectId.get().toHexString();
    @EdiElt.Exclude
    @Prop(desc={"Type of this object, always set to 'PROVIDER_ADJUSTMENT'"})
    protected ObjectType objectType = ObjectType.PROVIDER_ADJUSTMENT;
    @EdiElt(pos=1, seg="PLB", isRequired=true)
    private String providerIdentifier;
    @EdiElt(pos=2, seg="PLB", isRequired=true)
    private LocalDate fiscalPeriodDate;
    @EdiElt.Exclude
    @Prop(objType=ObjType.PROVIDER_ADJUSTMENT_REASON_AMOUNT)
    private List<ProviderAdjustmentReasonAmount> adjustments = new ArrayList<ProviderAdjustmentReasonAmount>();
    @EdiElt.Exclude
    @Prop(masterClass=PaymentCsv.class)
    private OrgOrPerson payer;
    @EdiElt.Exclude
    @Prop(masterClass=PaymentCsv.class)
    private OrgOrPerson payee;
    @EdiElt.Exclude
    @Prop(objType=ObjType.TRANSACTION_835, desc={"Parent EDI transaction for this adjustment"})
    private EdiTransaction transaction;

    @Override
    public void populateFromSegInitial(EdiSeg seg, EdiParsingResults results) {
        super.populateFromSegInitial(seg, results);
        this.adjustments = this.mapPaymentAdjustments(seg, results);
        this.transaction = new EdiTransaction();
        if (results != null && results.curTransaction() != null) {
            this.transaction = new EdiTransaction(results.curTransaction());
            this.payer = this.transaction.sender();
            if (StringUtils.isNotBlank((CharSequence)this.transaction.payerIdentifier()) && this.payer.identifier() == null) {
                this.payer.identifier(this.transaction.payerIdentifier());
            }
            this.payee = this.transaction.receiver();
        }
    }

    private List<ProviderAdjustmentReasonAmount> mapPaymentAdjustments(EdiSeg seg, EdiParsingResults results) {
        ArrayList<ProviderAdjustmentReasonAmount> adjustments = new ArrayList<ProviderAdjustmentReasonAmount>();
        int statPos = 3;
        int lastPos = 13;
        for (int pos = statPos; pos <= lastPos && pos <= seg.eltSet().elts().size(); pos += 2) {
            Elt reasonElt = seg.eltByPosition(pos);
            Elt amountElt = seg.eltByPosition(pos + 1);
            if (reasonElt == null && amountElt == null) continue;
            ProviderAdjustmentReasonAmount paymentAdjustment = this.mapPaymentAdjustment(reasonElt, amountElt);
            adjustments.add(paymentAdjustment);
            if (paymentAdjustment.reason() == null) continue;
            results.addCodeEntity(paymentAdjustment.reason());
        }
        return adjustments;
    }

    private ProviderAdjustmentReasonAmount mapPaymentAdjustment(Elt reasonElt, Elt amountElt) {
        BigDecimal amount = null;
        if (amountElt != null) {
            amount = amountElt.bigDecimalVal();
        }
        String reasonCode = null;
        String referenceIdentification = null;
        if (reasonElt != null) {
            if (reasonElt.dataType() == DataType.ELT_SET) {
                Elt refElt;
                EltSet reasonSet = reasonElt.eltSet();
                Elt reasonCodeElt = reasonSet.eltByPosition(1);
                if (reasonCodeElt != null) {
                    reasonCode = reasonCodeElt.stringVal();
                }
                if ((refElt = reasonSet.eltByPosition(2)) != null) {
                    referenceIdentification = refElt.stringVal();
                }
            } else {
                reasonCode = reasonElt.stringVal();
            }
        }
        return new ProviderAdjustmentReasonAmount(reasonCode, referenceIdentification, amount);
    }

    public void prepForApi() {
        this.trimCodeEntities();
        this.transaction.sender(null);
        this.transaction.receiver(null);
    }

    private void trimCodeEntities() {
        for (ProviderAdjustmentReasonAmount adjustment : this.adjustments) {
            if (adjustment.reason() == null) continue;
            adjustment.reason().trimNiceToHave();
        }
    }

    @Override
    @Generated
    public String id() {
        return this.id;
    }

    @Override
    @Generated
    public ObjectType objectType() {
        return this.objectType;
    }

    @Generated
    public String providerIdentifier() {
        return this.providerIdentifier;
    }

    @Generated
    public LocalDate fiscalPeriodDate() {
        return this.fiscalPeriodDate;
    }

    @Generated
    public List<ProviderAdjustmentReasonAmount> adjustments() {
        return this.adjustments;
    }

    @Generated
    public OrgOrPerson payer() {
        return this.payer;
    }

    @Generated
    public OrgOrPerson payee() {
        return this.payee;
    }

    @Generated
    public String toString() {
        return "ProviderAdjustment(providerIdentifier=" + this.providerIdentifier() + ", fiscalPeriodDate=" + String.valueOf(this.fiscalPeriodDate()) + ", adjustments=" + String.valueOf(this.adjustments()) + ", payer=" + String.valueOf(this.payer()) + ", payee=" + String.valueOf(this.payee()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProviderAdjustment)) {
            return false;
        }
        ProviderAdjustment other = (ProviderAdjustment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.id();
        String other$id = other.id();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        ObjectType this$objectType = this.objectType();
        ObjectType other$objectType = other.objectType();
        if (this$objectType == null ? other$objectType != null : !((Object)((Object)this$objectType)).equals((Object)other$objectType)) {
            return false;
        }
        String this$providerIdentifier = this.providerIdentifier();
        String other$providerIdentifier = other.providerIdentifier();
        if (this$providerIdentifier == null ? other$providerIdentifier != null : !this$providerIdentifier.equals(other$providerIdentifier)) {
            return false;
        }
        LocalDate this$fiscalPeriodDate = this.fiscalPeriodDate();
        LocalDate other$fiscalPeriodDate = other.fiscalPeriodDate();
        if (this$fiscalPeriodDate == null ? other$fiscalPeriodDate != null : !((Object)this$fiscalPeriodDate).equals(other$fiscalPeriodDate)) {
            return false;
        }
        List<ProviderAdjustmentReasonAmount> this$adjustments = this.adjustments();
        List<ProviderAdjustmentReasonAmount> other$adjustments = other.adjustments();
        if (this$adjustments == null ? other$adjustments != null : !((Object)this$adjustments).equals(other$adjustments)) {
            return false;
        }
        OrgOrPerson this$payer = this.payer();
        OrgOrPerson other$payer = other.payer();
        if (this$payer == null ? other$payer != null : !((Object)this$payer).equals(other$payer)) {
            return false;
        }
        OrgOrPerson this$payee = this.payee();
        OrgOrPerson other$payee = other.payee();
        if (this$payee == null ? other$payee != null : !((Object)this$payee).equals(other$payee)) {
            return false;
        }
        EdiTransaction this$transaction = this.transaction();
        EdiTransaction other$transaction = other.transaction();
        return !(this$transaction == null ? other$transaction != null : !((Object)this$transaction).equals(other$transaction));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ProviderAdjustment;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.id();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        ObjectType $objectType = this.objectType();
        result = result * 59 + ($objectType == null ? 43 : ((Object)((Object)$objectType)).hashCode());
        String $providerIdentifier = this.providerIdentifier();
        result = result * 59 + ($providerIdentifier == null ? 43 : $providerIdentifier.hashCode());
        LocalDate $fiscalPeriodDate = this.fiscalPeriodDate();
        result = result * 59 + ($fiscalPeriodDate == null ? 43 : ((Object)$fiscalPeriodDate).hashCode());
        List<ProviderAdjustmentReasonAmount> $adjustments = this.adjustments();
        result = result * 59 + ($adjustments == null ? 43 : ((Object)$adjustments).hashCode());
        OrgOrPerson $payer = this.payer();
        result = result * 59 + ($payer == null ? 43 : ((Object)$payer).hashCode());
        OrgOrPerson $payee = this.payee();
        result = result * 59 + ($payee == null ? 43 : ((Object)$payee).hashCode());
        EdiTransaction $transaction = this.transaction();
        result = result * 59 + ($transaction == null ? 43 : ((Object)$transaction).hashCode());
        return result;
    }

    @Override
    @Generated
    public EdiTransaction transaction() {
        return this.transaction;
    }
}

