/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.payment;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import hdi.codeent.CodeEntity;
import hdi.codeent.PrimaryCodeType;
import hdi.edi.EdiTransaction;
import hdi.edi.csv.PaymentCsv;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.EdiEntity;
import hdi.edi.objmapper.EdiObjectMapper;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.SegmentType;
import hdi.edi.parser.TransactionType;
import hdi.model.Amount;
import hdi.model.ClaimOrPayment;
import hdi.model.ObjectType;
import hdi.model.PlaceOfServiceType;
import hdi.model.Quantity;
import hdi.model.Reference;
import hdi.model.ServiceLine;
import hdi.model.enumtype.AmountType;
import hdi.model.enumtype.ReferenceType;
import hdi.model.enumtype.UbCodeType;
import hdi.model.orgperson.ContactInfo;
import hdi.model.orgperson.EntityRole;
import hdi.model.orgperson.OrgOrPerson;
import hdi.model.patientsubscriber.PatientSubscriber;
import hdi.model.payment.Adjustment;
import hdi.model.payment.ClaimStatus;
import hdi.model.payment.GroupedAdjustments;
import hdi.model.payment.InpatientAdjudication;
import hdi.model.payment.InsurancePlanType;
import hdi.model.payment.OutpatientAdjudication;
import hdi.util.CollectionUtils;
import hdi.util.SearchWordsUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@EdiObj(loop={"2100"}, seg={"CLP"}, jsonExample={"835/835-all-fields"}, interactiveExample={"payments/comprehensive/"})
public class Payment
extends ClaimOrPayment {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Payment.class);
    public static EdiObjectMapper<Payment> mapper = new EdiObjectMapper();
    @Transient
    @JsonIgnore
    private EdiSeg seg;
    @Prop(edi={"CLP02"})
    private String claimStatusCode;
    @Prop(edi={"CLP02"}, desc={"Claim status code translated to a string constant (enum), such as PRIMARY,SECONDARY"})
    private ClaimStatus claimStatus;
    @Prop(masterClass=PaymentCsv.class)
    private BigDecimal patientResponsibilityAmount;
    @Prop(masterClass=PaymentCsv.class)
    private String claimFilingIndicatorCode;
    @Prop(edi={"CLP06"}, desc={"Claim filing indicator code translated to a string constant (enum), such as PPO, HMO"})
    private InsurancePlanType insurancePlanType;
    @EdiElt(value={"payer_claim_control_number"})
    @Prop(masterClass=PaymentCsv.class)
    private String payerControlNumber;
    @Prop(edi={"CLP11"}, desc={"Diagnosis-related group code. Institutional claims only."}, objType=ObjType.CODE)
    private CodeEntity drg;
    @Prop(masterClass=PaymentCsv.class)
    private BigDecimal drgWeight;
    @Prop(masterClass=PaymentCsv.class)
    private BigDecimal dischargeFraction;
    @Prop(masterClass=PaymentCsv.class)
    private List<Reference> otherClaimRelatedIds;
    @Prop(masterClass=PaymentCsv.class, fieldName="supplementalAmts")
    private List<Amount> supplementalAmounts;
    @Prop(masterClass=PaymentCsv.class, fieldName="supplementalQties")
    private List<Quantity> supplementalQuantities;
    @EdiElt.Exclude
    @Prop(masterClass=PaymentCsv.class)
    private OrgOrPerson payer;
    @EdiElt.Exclude
    @Prop(masterClass=PaymentCsv.class)
    private OrgOrPerson payee;
    @EdiElt.Exclude
    @Prop(edi={"MOA"}, objType=ObjType.OUTPATIENT_ADJUDICATION)
    private OutpatientAdjudication outpatientAdjudication;
    @EdiElt.Exclude
    @Prop(edi={"MIA"}, objType=ObjType.INPATIENT_ADJUDICATION)
    private InpatientAdjudication inpatientAdjudication;
    @EdiElt.Exclude
    @Prop(desc={"Claim adjustments"}, edi={"CAS"}, objType=ObjType.ADJUSTMENT)
    private List<Adjustment> adjustments;
    @Prop(masterClass=PaymentCsv.class)
    private LocalDate coverageExpirationDate;
    @Prop(masterClass=PaymentCsv.class)
    private LocalDate claimReceivedDate;
    @EdiElt.Exclude
    @Prop(masterClass=PaymentCsv.class)
    private OrgOrPerson serviceProvider;
    @EdiElt.Exclude
    @Prop(masterClass=PaymentCsv.class)
    private OrgOrPerson crossoverCarrier;
    @EdiElt.Exclude
    @Prop(masterClass=PaymentCsv.class)
    private OrgOrPerson correctedPayer;
    @EdiElt.Exclude
    @Prop(masterClass=PaymentCsv.class, fieldName="correctedPatient")
    private OrgOrPerson correctedInsured;
    @EdiElt.Exclude
    @Prop(objType=ObjType.CONTACT_INFO)
    private List<ContactInfo> claimContacts;
    @JsonIgnore
    private BigDecimal adjustmentAmount;
    @JsonIgnore
    private Set<String> searchWords;

    public Payment() {
        this.objectType = ObjectType.PAYMENT;
        this.transaction = new EdiTransaction();
        this.transaction.transactionType(TransactionType.PAYMENT);
    }

    public void claimFilingIndicatorCode(String claimFilingIndicatorCode) {
        this.claimFilingIndicatorCode = claimFilingIndicatorCode;
        this.insurancePlanType = InsurancePlanType.fromEdi(claimFilingIndicatorCode);
    }

    @Override
    public void populateFromSegInitial(EdiSeg seg, EdiParsingResults results) {
        mapper.populate(this, seg);
        this.transaction = new EdiTransaction();
        if (results != null && results.curTransaction() != null) {
            this.transaction = new EdiTransaction(results.curTransaction());
            this.payer = this.transaction.sender();
            this.payee = this.transaction.receiver();
        }
        this.seg = EdiSeg.cloneKeySegInfo(seg);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void populateFromSeg(EdiSeg seg, EdiParsingResults ediParsingResults) {
        if (!this.seg.isParentOf(seg)) return;
        if (seg.isInType(SegmentType.DTM)) {
            mapper.populate(this, seg);
            return;
        }
        EdiEntity ediEntity = seg.entity();
        if (ediEntity instanceof Reference) {
            Reference reference = (Reference)ediEntity;
            if (StringUtils.startsWithIgnoreCase((CharSequence)seg.name(), (CharSequence)"other_claim_related_id")) {
                if (this.otherClaimRelatedIds == null) {
                    this.otherClaimRelatedIds = new ArrayList<Reference>();
                }
                this.otherClaimRelatedIds.add(reference);
            }
            if (!StringUtils.startsWithIgnoreCase((CharSequence)seg.name(), (CharSequence)"rendering_provider_id")) return;
            if (this.serviceProvider == null) {
                this.serviceProvider = new OrgOrPerson();
                this.serviceProvider.entityRole(EntityRole.RENDERING);
            }
            if (this.serviceProvider.additionalIds() == null) {
                this.serviceProvider.additionalIds(new ArrayList<Reference>());
            }
            this.serviceProvider.additionalIds().add(reference);
            return;
        }
        ediEntity = seg.entity();
        if (ediEntity instanceof OrgOrPerson) {
            OrgOrPerson person = (OrgOrPerson)ediEntity;
            switch (person.entityRole()) {
                case PATIENT: {
                    this.patient = new PatientSubscriber().person(person);
                    return;
                }
                case INSURED_SUBSCRIBER: {
                    this.subscriber = new PatientSubscriber().person(person);
                    return;
                }
                case OTHER_SUBSCRIBER: {
                    this.otherSubscribers = CollectionUtils.addWithInit(this.otherSubscribers, new PatientSubscriber().person(person));
                    return;
                }
                case RENDERING: {
                    this.serviceProvider = person;
                    return;
                }
                case CROSSOVER_CARRIER: {
                    this.crossoverCarrier = person;
                    return;
                }
                case PAYER: {
                    this.correctedPayer = person;
                    return;
                }
                case CORRECTED_INSURED: {
                    this.correctedInsured = person;
                    return;
                }
            }
            return;
        }
        ediEntity = seg.entity();
        if (ediEntity instanceof ContactInfo) {
            ContactInfo contact = (ContactInfo)ediEntity;
            this.claimContacts = CollectionUtils.addWithInit(this.claimContacts, contact);
            return;
        }
        ediEntity = seg.entity();
        if (ediEntity instanceof ServiceLine) {
            ServiceLine line = (ServiceLine)ediEntity;
            seg.codeEntityConsumer(this::updateFacilityCodeSubType);
            this.addLine(line);
            return;
        }
        ediEntity = seg.entity();
        if (ediEntity instanceof OutpatientAdjudication) {
            OutpatientAdjudication moa;
            this.outpatientAdjudication = moa = (OutpatientAdjudication)ediEntity;
            return;
        }
        ediEntity = seg.entity();
        if (ediEntity instanceof InpatientAdjudication) {
            InpatientAdjudication mia;
            this.inpatientAdjudication = mia = (InpatientAdjudication)ediEntity;
            return;
        }
        ediEntity = seg.entity();
        if (ediEntity instanceof GroupedAdjustments) {
            GroupedAdjustments groupedAdjs = (GroupedAdjustments)ediEntity;
            if (this.adjustments == null) {
                this.adjustments = new ArrayList<Adjustment>();
            }
            this.adjustments.addAll(groupedAdjs.adjustments());
            return;
        }
        ediEntity = seg.entity();
        if (ediEntity instanceof Amount) {
            Amount amt = (Amount)ediEntity;
            if (StringUtils.containsIgnoreCase((CharSequence)seg.name(), (CharSequence)"supplemental")) {
                this.supplementalAmounts = CollectionUtils.addWithInit(this.supplementalAmounts, amt);
                return;
            }
        }
        if (!((ediEntity = seg.entity()) instanceof Quantity)) return;
        Quantity qty = (Quantity)ediEntity;
        if (!StringUtils.containsIgnoreCase((CharSequence)seg.name(), (CharSequence)"supplemental")) return;
        this.supplementalQuantities = CollectionUtils.addWithInit(this.supplementalQuantities, qty);
    }

    private void updateFacilityCodeSubType(CodeEntity codeEntity) {
        if (this.facilityCode != null && (codeEntity.subType() == UbCodeType.REVENUE_CODE || codeEntity.subType() == UbCodeType.DRG)) {
            this.facilityCode.subType(UbCodeType.FACILITY_TYPE);
            this.placeOfServiceType = PlaceOfServiceType.fromCode(TransactionType.INST, this.facilityCode.code());
        }
    }

    @Override
    public PatientSubscriber subscriber() {
        return this.subscriber != null ? this.subscriber : this.patient;
    }

    public OrgOrPerson otherSubscriber() {
        if (this.otherSubscribers() != null && !this.otherSubscribers().isEmpty()) {
            return ((PatientSubscriber)this.otherSubscribers.get(0)).person();
        }
        return null;
    }

    @EdiElt(value={"claim_status_code"})
    public void setClaimStatusCode(String claimStatusCode) {
        this.claimStatusCode = claimStatusCode;
        this.claimStatus = ClaimStatus.fromEdi(claimStatusCode);
    }

    @EdiElt(value={"drg_code"})
    public void setDrgCode(String drgCode) {
        this.drg = new CodeEntity(PrimaryCodeType.DRG, UbCodeType.DRG, drgCode);
        this.updateFacilityCodeSubType(this.drg);
    }

    public List<CodeEntity> allCodeEntities() {
        ArrayList<CodeEntity> allCodeEntities = new ArrayList<CodeEntity>(this.allPaymentLevelCodeEntities());
        for (ServiceLine l : this.lines) {
            allCodeEntities.addAll(l.allCodeEntities());
        }
        return allCodeEntities;
    }

    private List<CodeEntity> allPaymentLevelCodeEntities() {
        ArrayList<CodeEntity> allCodeEntities = new ArrayList<CodeEntity>();
        CollectionUtils.addIfNotNull(allCodeEntities, this.facilityCode);
        CollectionUtils.addIfNotNull(allCodeEntities, this.frequencyCode);
        if (this.adjustments != null) {
            for (Adjustment adj : this.adjustments) {
                CollectionUtils.addIfNotNull(allCodeEntities, adj.reason());
            }
        }
        if (this.drg != null) {
            allCodeEntities.add(this.drg);
        }
        if (this.outpatientAdjudication != null) {
            allCodeEntities.addAll(this.outpatientAdjudication.remarks());
        }
        return allCodeEntities;
    }

    @Override
    public void prepForApi() {
        this.generateId();
        this.trimCodeEntities();
        this.prepLineDiagsForApi();
        this.transaction.sender(null);
        this.transaction.receiver(null);
    }

    public void trimCodeEntities() {
        this.allCodeEntities().forEach(CodeEntity::trimNiceToHave);
    }

    @JsonIgnore
    public Reference getReference(ReferenceType type) {
        if (this.otherClaimRelatedIds != null && !this.otherClaimRelatedIds.isEmpty()) {
            for (Reference reference : this.otherClaimRelatedIds) {
                if (reference.type() != type) continue;
                return reference;
            }
        }
        return null;
    }

    @Override
    protected Set<String> prepSearchWords() {
        Set<String> tokens = super.prepSearchWords();
        tokens.add(this.payerControlNumber);
        if (this.claimStatus != null) {
            tokens.add(this.claimStatus.name());
            tokens.add(this.claimStatus.desc());
        }
        tokens.add(this.claimStatusCode);
        if (this.insurancePlanType != null) {
            tokens.add(this.insurancePlanType.name());
            tokens.add(this.insurancePlanType.desc());
        }
        SearchWordsUtils.prepPersonSearchWords(tokens, this.payer);
        SearchWordsUtils.prepPersonSearchWords(tokens, this.payee);
        SearchWordsUtils.prepPersonSearchWords(tokens, this.correctedInsured);
        SearchWordsUtils.prepPersonSearchWords(tokens, this.correctedPayer);
        tokens.add(this.transaction.checkOrEftTraceNumber());
        tokens.add(this.transaction.payerIdentifier());
        if (this.otherClaimRelatedIds != null) {
            for (Reference ref : this.otherClaimRelatedIds) {
                tokens.add(ref.identification());
            }
        }
        return SearchWordsUtils.tokenizeTextFields(tokens);
    }

    @Override
    public void prepForPersistence() {
        super.prepForPersistence();
        this.updateDerived();
    }

    public void updateDerived() {
        this.prepNormalizedCodeEnts(this.allCodeEntities());
        this.populateEarliestAndLatestDates();
        this.preparePeriods();
        if (this.claimStatus != null && this.claimStatusCode == null) {
            this.claimStatusCode = this.claimStatus.ediValue();
        }
        this.adjustmentAmount = this.getTotalAdjustmentAmount();
        this.searchWords = this.prepSearchWords();
    }

    @Override
    public void populateEarliestAndLatestDates() {
        if (this.transaction.paymentDate() != null) {
            this.populateServiceDatesRange();
            this.dateFrom = this.transaction.paymentDate();
            this.dateTo = this.transaction.paymentDate();
        } else {
            super.populateEarliestAndLatestDates();
        }
    }

    @JsonIgnore
    public BigDecimal getTotalAdjustmentAmount() {
        BigDecimal totalAdjustmentAmount = this.getTotalClaimAdjustmentAmount();
        for (ServiceLine line : this.lines) {
            totalAdjustmentAmount = totalAdjustmentAmount.add(line.getTotalAdjustmentAmount());
        }
        return totalAdjustmentAmount;
    }

    @Override
    @JsonIgnore
    public BigDecimal getTotalClaimAdjustmentAmount() {
        BigDecimal totalAdjustmentAmount = BigDecimal.ZERO;
        if (this.adjustments != null) {
            for (Adjustment adjustment : this.adjustments) {
                totalAdjustmentAmount = totalAdjustmentAmount.add(adjustment.amountOrZero());
            }
        }
        return totalAdjustmentAmount;
    }

    @JsonIgnore
    public BigDecimal getCoverageAmount() {
        return Amount.findAmountByType(this.supplementalAmounts, AmountType.COVERAGE_AMOUNT);
    }

    @Override
    public List<Adjustment> adjustments() {
        return this.adjustments == null ? List.of() : this.adjustments;
    }

    public List<CodeEntity> remarks() {
        if (this.outpatientAdjudication != null && this.outpatientAdjudication.remarks() != null) {
            return this.outpatientAdjudication.remarks();
        }
        return List.of();
    }

    public List<Reference> otherClaimRelatedIds() {
        return this.otherClaimRelatedIds == null ? List.of() : this.otherClaimRelatedIds;
    }

    public List<Amount> supplementalAmounts() {
        return this.supplementalAmounts == null ? List.of() : this.supplementalAmounts;
    }

    public List<Quantity> supplementalQuantities() {
        return this.supplementalQuantities == null ? List.of() : this.supplementalQuantities;
    }

    public List<ContactInfo> claimContacts() {
        return this.claimContacts == null ? List.of() : this.claimContacts;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Payment)) {
            return false;
        }
        Payment other = (Payment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$payerControlNumber = this.payerControlNumber();
        String other$payerControlNumber = other.payerControlNumber();
        return !(this$payerControlNumber == null ? other$payerControlNumber != null : !this$payerControlNumber.equals(other$payerControlNumber));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Payment;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $payerControlNumber = this.payerControlNumber();
        result = result * 59 + ($payerControlNumber == null ? 43 : $payerControlNumber.hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Payment(super=" + super.toString() + ", claimStatusCode=" + this.claimStatusCode() + ", claimStatus=" + String.valueOf(this.claimStatus()) + ", patientResponsibilityAmount=" + String.valueOf(this.patientResponsibilityAmount()) + ", claimFilingIndicatorCode=" + this.claimFilingIndicatorCode() + ", insurancePlanType=" + String.valueOf(this.insurancePlanType()) + ", payerControlNumber=" + this.payerControlNumber() + ", drg=" + String.valueOf(this.drg()) + ", drgWeight=" + String.valueOf(this.drgWeight()) + ", dischargeFraction=" + String.valueOf(this.dischargeFraction()) + ", otherClaimRelatedIds=" + String.valueOf(this.otherClaimRelatedIds()) + ", supplementalAmounts=" + String.valueOf(this.supplementalAmounts()) + ", supplementalQuantities=" + String.valueOf(this.supplementalQuantities()) + ", payer=" + String.valueOf(this.payer()) + ", payee=" + String.valueOf(this.payee()) + ", outpatientAdjudication=" + String.valueOf(this.outpatientAdjudication()) + ", inpatientAdjudication=" + String.valueOf(this.inpatientAdjudication()) + ", adjustments=" + String.valueOf(this.adjustments()) + ", coverageExpirationDate=" + String.valueOf(this.coverageExpirationDate()) + ", claimReceivedDate=" + String.valueOf(this.claimReceivedDate()) + ", serviceProvider=" + String.valueOf(this.serviceProvider()) + ", crossoverCarrier=" + String.valueOf(this.crossoverCarrier()) + ", correctedPayer=" + String.valueOf(this.correctedPayer()) + ", correctedInsured=" + String.valueOf(this.correctedInsured()) + ", claimContacts=" + String.valueOf(this.claimContacts()) + ", adjustmentAmount=" + String.valueOf(this.adjustmentAmount()) + ", searchWords=" + String.valueOf(this.searchWords()) + ")";
    }

    @JsonIgnore
    @Generated
    public EdiSeg seg() {
        return this.seg;
    }

    @Generated
    public String claimStatusCode() {
        return this.claimStatusCode;
    }

    @Generated
    public ClaimStatus claimStatus() {
        return this.claimStatus;
    }

    @Generated
    public BigDecimal patientResponsibilityAmount() {
        return this.patientResponsibilityAmount;
    }

    @Generated
    public String claimFilingIndicatorCode() {
        return this.claimFilingIndicatorCode;
    }

    @Generated
    public InsurancePlanType insurancePlanType() {
        return this.insurancePlanType;
    }

    @Generated
    public String payerControlNumber() {
        return this.payerControlNumber;
    }

    @Generated
    public CodeEntity drg() {
        return this.drg;
    }

    @Generated
    public BigDecimal drgWeight() {
        return this.drgWeight;
    }

    @Generated
    public BigDecimal dischargeFraction() {
        return this.dischargeFraction;
    }

    @Generated
    public OrgOrPerson payer() {
        return this.payer;
    }

    @Generated
    public OrgOrPerson payee() {
        return this.payee;
    }

    @Generated
    public OutpatientAdjudication outpatientAdjudication() {
        return this.outpatientAdjudication;
    }

    @Generated
    public InpatientAdjudication inpatientAdjudication() {
        return this.inpatientAdjudication;
    }

    @Generated
    public LocalDate coverageExpirationDate() {
        return this.coverageExpirationDate;
    }

    @Generated
    public LocalDate claimReceivedDate() {
        return this.claimReceivedDate;
    }

    @Generated
    public OrgOrPerson serviceProvider() {
        return this.serviceProvider;
    }

    @Generated
    public OrgOrPerson crossoverCarrier() {
        return this.crossoverCarrier;
    }

    @Generated
    public OrgOrPerson correctedPayer() {
        return this.correctedPayer;
    }

    @Generated
    public OrgOrPerson correctedInsured() {
        return this.correctedInsured;
    }

    @JsonIgnore
    @Generated
    public BigDecimal adjustmentAmount() {
        return this.adjustmentAmount;
    }

    @JsonIgnore
    @Generated
    public Set<String> searchWords() {
        return this.searchWords;
    }

    @JsonIgnore
    @Generated
    public Payment adjustmentAmount(BigDecimal adjustmentAmount) {
        this.adjustmentAmount = adjustmentAmount;
        return this;
    }
}

