/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.payment;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import hdi.codeent.CodeEntity;
import hdi.codeent.PrimaryCodeType;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.BaseEdiEntity;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.Elt;
import hdi.model.enumtype.CarcRarcType;
import hdi.util.NumbersUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@EdiObj(seg={"MOA"}, desc={"Contains Remittance Advice Remark Codes at the claim level and/or Medicare or Medicaid-specific amounts for outpatient claims"})
public class OutpatientAdjudication
extends BaseEdiEntity {
    @Prop(edi={"MOA01"})
    private BigDecimal reimbursementRate;
    @EdiElt(pos=2, seg="MOA", desc="Claim HCPCS Payable Amount")
    private BigDecimal hcpcsPayableAmount;
    @EdiElt(pos=8, seg="MOA")
    private BigDecimal esrdPaymentAmount;
    @EdiElt(pos=9, seg="MOA", desc="Nonpayable Professional Component Amount")
    private BigDecimal nonPayableProfessionalComponentAmount;
    @Prop(desc={"Remark codes"}, edi={"MOA3:7"}, codeLookupQuery="type=carc_rarc&search=cat:rarc", objType=ObjType.CODE)
    private List<CodeEntity> remarks;

    @Override
    public void populateFromSegInitial(EdiSeg seg, EdiParsingResults results) {
        super.populateFromSegInitial(seg, results);
        int statPos = 3;
        int lastPos = 7;
        for (int pos = statPos; pos <= lastPos && pos <= seg.eltSet().elts().size(); ++pos) {
            Elt remarkCode = seg.eltByPosition(pos);
            if (remarkCode == null) continue;
            if (this.remarks == null) {
                this.remarks = new ArrayList<CodeEntity>();
            }
            CodeEntity remark = new CodeEntity(PrimaryCodeType.CARC_RARC, CarcRarcType.RARC, remarkCode.stringVal());
            this.remarks.add(remark);
            results.addCodeEntity(remark);
        }
    }

    public List<CodeEntity> remarks() {
        return this.remarks == null ? List.of() : this.remarks;
    }

    @EdiElt(pos=1, seg="MOA")
    public OutpatientAdjudication reimbursementRate(BigDecimal num) {
        this.reimbursementRate = NumbersUtils.removeTrailingZerosUpToDecimal(num);
        return this;
    }

    @Generated
    public BigDecimal reimbursementRate() {
        return this.reimbursementRate;
    }

    @Generated
    public BigDecimal hcpcsPayableAmount() {
        return this.hcpcsPayableAmount;
    }

    @Generated
    public BigDecimal esrdPaymentAmount() {
        return this.esrdPaymentAmount;
    }

    @Generated
    public BigDecimal nonPayableProfessionalComponentAmount() {
        return this.nonPayableProfessionalComponentAmount;
    }

    @Generated
    public String toString() {
        return "OutpatientAdjudication(reimbursementRate=" + String.valueOf(this.reimbursementRate()) + ", hcpcsPayableAmount=" + String.valueOf(this.hcpcsPayableAmount()) + ", esrdPaymentAmount=" + String.valueOf(this.esrdPaymentAmount()) + ", nonPayableProfessionalComponentAmount=" + String.valueOf(this.nonPayableProfessionalComponentAmount()) + ", remarks=" + String.valueOf(this.remarks()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OutpatientAdjudication)) {
            return false;
        }
        OutpatientAdjudication other = (OutpatientAdjudication)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigDecimal this$reimbursementRate = this.reimbursementRate();
        BigDecimal other$reimbursementRate = other.reimbursementRate();
        if (this$reimbursementRate == null ? other$reimbursementRate != null : !((Object)this$reimbursementRate).equals(other$reimbursementRate)) {
            return false;
        }
        BigDecimal this$hcpcsPayableAmount = this.hcpcsPayableAmount();
        BigDecimal other$hcpcsPayableAmount = other.hcpcsPayableAmount();
        if (this$hcpcsPayableAmount == null ? other$hcpcsPayableAmount != null : !((Object)this$hcpcsPayableAmount).equals(other$hcpcsPayableAmount)) {
            return false;
        }
        BigDecimal this$esrdPaymentAmount = this.esrdPaymentAmount();
        BigDecimal other$esrdPaymentAmount = other.esrdPaymentAmount();
        if (this$esrdPaymentAmount == null ? other$esrdPaymentAmount != null : !((Object)this$esrdPaymentAmount).equals(other$esrdPaymentAmount)) {
            return false;
        }
        BigDecimal this$nonPayableProfessionalComponentAmount = this.nonPayableProfessionalComponentAmount();
        BigDecimal other$nonPayableProfessionalComponentAmount = other.nonPayableProfessionalComponentAmount();
        if (this$nonPayableProfessionalComponentAmount == null ? other$nonPayableProfessionalComponentAmount != null : !((Object)this$nonPayableProfessionalComponentAmount).equals(other$nonPayableProfessionalComponentAmount)) {
            return false;
        }
        List<CodeEntity> this$remarks = this.remarks();
        List<CodeEntity> other$remarks = other.remarks();
        return !(this$remarks == null ? other$remarks != null : !((Object)this$remarks).equals(other$remarks));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OutpatientAdjudication;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigDecimal $reimbursementRate = this.reimbursementRate();
        result = result * 59 + ($reimbursementRate == null ? 43 : ((Object)$reimbursementRate).hashCode());
        BigDecimal $hcpcsPayableAmount = this.hcpcsPayableAmount();
        result = result * 59 + ($hcpcsPayableAmount == null ? 43 : ((Object)$hcpcsPayableAmount).hashCode());
        BigDecimal $esrdPaymentAmount = this.esrdPaymentAmount();
        result = result * 59 + ($esrdPaymentAmount == null ? 43 : ((Object)$esrdPaymentAmount).hashCode());
        BigDecimal $nonPayableProfessionalComponentAmount = this.nonPayableProfessionalComponentAmount();
        result = result * 59 + ($nonPayableProfessionalComponentAmount == null ? 43 : ((Object)$nonPayableProfessionalComponentAmount).hashCode());
        List<CodeEntity> $remarks = this.remarks();
        result = result * 59 + ($remarks == null ? 43 : ((Object)$remarks).hashCode());
        return result;
    }
}

