/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.payment;

import hdi.edi.qualifier.EdiQualifier;
import hdi.util.WordStringUtils;
import lombok.Generated;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;

public enum InsurancePlanType implements EdiQualifier
{
    OTHER_NON_FEDERAL("11", "Other Non-Federal Programs"),
    BCBS("BL", "Blue Cross/Blue Shield"),
    COMMERCIAL("CI", "Commercial Insurance Co."),
    PPO("12", "Preferred Provider Organization (PPO)"),
    POS("13", "Point of Service (POS)"),
    EPO("14", "Exclusive Provider Organization (EPO)"),
    INDEMNITY_INSURANCE("15", "Indemnity Insurance"),
    HMO_MEDICARE("16", "Health Maintenance Organization (HMO) Medicare Risk"),
    HMO("HM", "Health Maintenance Organization (HMO)"),
    MEDICARE_A("MA", "Medicare Plan A"),
    MEDICARE_B("MB", "Medicare Plan B"),
    MEDICAID("MC", "Medicaid"),
    MUTUALLY_DEFINED("ZZ", "Mutually Defined"),
    AUTOMOBILE_MEDICAL("AM", null),
    CHAMPUS("CH", "CHAMPUS"),
    VETERAN_AFFAIRS("VA", null),
    FEDERAL_EMPLOYEE_PROGRAM("FI", null),
    WORKERS_COMPENSATION("WC", null),
    OTHER_FEDERAL("OF", null);

    private final String ediValue;
    private final String desc;

    public static InsurancePlanType fromEdi(String ediCode) {
        for (InsurancePlanType v : InsurancePlanType.values()) {
            if (v.ediValue == null || !StringUtils.equalsIgnoreCase((CharSequence)ediCode, (CharSequence)v.ediValue)) continue;
            return v;
        }
        return null;
    }

    @Override
    public String desc() {
        if (this.desc != null) {
            return this.desc;
        }
        return WordStringUtils.enumNameToDesc(this);
    }

    @Override
    @Generated
    public String ediValue() {
        return this.ediValue;
    }

    @Generated
    private InsurancePlanType(String ediValue, String desc) {
        this.ediValue = ediValue;
        this.desc = desc;
    }

    @WritingConverter
    public static class ToBson
    implements Converter<InsurancePlanType, String> {
        public String convert(InsurancePlanType enm) {
            return enm.name();
        }
    }

    @ReadingConverter
    public static class FromBson
    implements Converter<String, InsurancePlanType> {
        public InsurancePlanType convert(@NotNull String s) {
            return (InsurancePlanType)EnumUtils.getEnumIgnoreCase(InsurancePlanType.class, (String)s);
        }
    }
}

