/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.payment;

import hdi.edi.qualifier.EdiQualifier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum AccountNumberQualifier implements EdiQualifier
{
    DEMAND_DEPOSIT("DA", "Demand deposit"),
    SAVINGS("SG", "Savings");

    private final String ediValue;
    private final String desc;

    public static AccountNumberQualifier fromEdi(String ediCode) {
        for (AccountNumberQualifier v : AccountNumberQualifier.values()) {
            if (v.ediValue == null || !StringUtils.equalsIgnoreCase((CharSequence)ediCode, (CharSequence)v.ediValue)) continue;
            return v;
        }
        return null;
    }

    @Override
    @Generated
    public String ediValue() {
        return this.ediValue;
    }

    @Override
    @Generated
    public String desc() {
        return this.desc;
    }

    @Generated
    private AccountNumberQualifier(String ediValue, String desc) {
        this.ediValue = ediValue;
        this.desc = desc;
    }
}

