/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.patientsubscriber;

import hdi.edi.qualifier.EdiQualifier;
import hdi.util.EdiBsonDoc;
import lombok.Generated;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;

public enum PayerRespSequenceType implements EdiQualifier
{
    FOUR("A", "Payer Responsibility Four"),
    FIVE("B", "Payer Responsibility Five"),
    SIX("C", "Payer Responsibility Six"),
    SEVEN("D", "Payer Responsibility Seven"),
    EIGHT("E", "Payer Responsibility Eight"),
    NINE("F", "Payer Responsibility Nine"),
    TEN("G", "Payer Responsibility Ten"),
    ELEVEN("H", "Payer Responsibility Eleven"),
    PRIMARY("P", "Primary"),
    SECONDARY("S", "Secondary"),
    TERTIARY("T", "Tertiary"),
    UNKNOWN("U", "Unknown");

    private final String ediValue;
    private final String desc;

    public static PayerRespSequenceType fromEdi(String ediCode) {
        for (PayerRespSequenceType v : PayerRespSequenceType.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)ediCode, (CharSequence)v.ediValue)) continue;
            return v;
        }
        return null;
    }

    @Override
    @Generated
    public String ediValue() {
        return this.ediValue;
    }

    @Override
    @Generated
    public String desc() {
        return this.desc;
    }

    @Generated
    private PayerRespSequenceType(String ediValue, String desc) {
        this.ediValue = ediValue;
        this.desc = desc;
    }

    @WritingConverter
    public static class ToBson
    implements Converter<PayerRespSequenceType, Document> {
        public Document convert(PayerRespSequenceType typeEnum) {
            return new EdiBsonDoc(typeEnum.name()).append("description", typeEnum.desc);
        }
    }

    @ReadingConverter
    public static class FromBson
    implements Converter<Document, PayerRespSequenceType> {
        public PayerRespSequenceType convert(Document bson) {
            return (PayerRespSequenceType)EnumUtils.getEnumIgnoreCase(PayerRespSequenceType.class, (String)bson.getString((Object)"name"));
        }
    }
}

