/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.patientsubscriber;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import hdi.edi.dict.VariantType;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.EdiEntity;
import hdi.edi.objmapper.EdiObjectMapper;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.SegmentType;
import hdi.edi.parser.TransactionType;
import hdi.model.Reference;
import hdi.model.enumtype.AmountType;
import hdi.model.enumtype.IdentificationType;
import hdi.model.enumtype.ReferenceType;
import hdi.model.orgperson.EntityRole;
import hdi.model.orgperson.EntityType;
import hdi.model.orgperson.GenderType;
import hdi.model.orgperson.OrgOrPerson;
import hdi.model.patientsubscriber.PayerRespSequenceType;
import hdi.model.patientsubscriber.RelationshipType;
import hdi.model.payment.Adjustment;
import hdi.model.payment.GroupedAdjustments;
import hdi.model.payment.InpatientAdjudication;
import hdi.model.payment.InsurancePlanType;
import hdi.model.payment.OutpatientAdjudication;
import hdi.util.DateUtils;
import hdi.util.FormattingUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.data.annotation.Transient;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class PatientSubscriber
implements EdiEntity {
    @EdiElt.Exclude
    @Transient
    @JsonIgnore
    private EdiSeg seg;
    @Transient
    @EdiElt.Exclude
    public static final EdiObjectMapper<PatientSubscriber> mapper = new EdiObjectMapper();
    @Prop(edi={"SBR01"}, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL}, isRequired=true, variantTypes={VariantType.SUBSCRIBER, VariantType.OTHER_SUBSCRIBER})
    @EdiElt(value={"payer_responsibility_sequence_number_code"})
    private PayerRespSequenceType payerResponsibilitySequence;
    @Prop(edi={"SBR02", "PAT01"}, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL}, variantTypes={VariantType.SUBSCRIBER, VariantType.OTHER_SUBSCRIBER, VariantType.PATIENT})
    @EdiElt(value={"individual_relationship_code"})
    private RelationshipType relationshipType;
    @Prop(edi={"SBR03"}, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL}, variantTypes={VariantType.SUBSCRIBER, VariantType.OTHER_SUBSCRIBER})
    @EdiElt(value={"insured_group_or_policy_number"})
    private String groupOrPolicyNumber;
    @Prop(edi={"SBR04"}, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL}, variantTypes={VariantType.SUBSCRIBER, VariantType.OTHER_SUBSCRIBER})
    @EdiElt(value={"insured_group_name"})
    private String groupName;
    @Prop(edi={"SBR09"}, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL}, variantTypes={VariantType.SUBSCRIBER, VariantType.OTHER_SUBSCRIBER})
    private String claimFilingIndicatorCode;
    @Prop(edi={"SBR09"}, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL}, variantTypes={VariantType.SUBSCRIBER, VariantType.OTHER_SUBSCRIBER})
    private InsurancePlanType insurancePlanType;
    @EdiElt.Exclude
    @Prop(edi={"NM1"}, objType=ObjType.PERSON_WITH_DEMOGRAPHIC)
    private OrgOrPerson person = null;
    @Prop(edi={"PAT06"}, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL}, variantTypes={VariantType.SUBSCRIBER, VariantType.PATIENT})
    @EdiElt(value={"insured_individual_death_date", "patient_death_date"})
    private LocalDate deathDate;
    @Prop(edi={"PAT08"}, desc={"Patient weight in pounds"}, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL}, variantTypes={VariantType.SUBSCRIBER, VariantType.PATIENT})
    private BigDecimal weight;
    @EdiElt(pos=9, seg="PAT")
    @Prop(edi={"PAT09"}, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL}, variantTypes={VariantType.SUBSCRIBER, VariantType.PATIENT})
    private String pregnancyIndicator;
    @EdiElt.Exclude
    @Prop(desc={"Claim-level adjustments from this payer"}, edi={"CAS"}, objType=ObjType.ADJUSTMENT, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL}, variantTypes={VariantType.OTHER_SUBSCRIBER})
    private List<Adjustment> adjustments;
    @Prop(amtType=AmountType.PAYER_PAID, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL}, variantTypes={VariantType.OTHER_SUBSCRIBER})
    private BigDecimal payerPaidAmount;
    @Prop(amtType=AmountType.NON_COVERED, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL}, variantTypes={VariantType.OTHER_SUBSCRIBER})
    private BigDecimal nonCoveredAmount;
    @Prop(amtType=AmountType.OWED, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL}, variantTypes={VariantType.OTHER_SUBSCRIBER})
    private BigDecimal remainingPatientLiabilityAmount;
    @Prop(edi={"MOA"}, objType=ObjType.OUTPATIENT_ADJUDICATION, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL}, variantTypes={VariantType.OTHER_SUBSCRIBER})
    private OutpatientAdjudication outpatientAdjudication;
    @Prop(edi={"MIA"}, objType=ObjType.INPATIENT_ADJUDICATION, tran={TransactionType.INST}, variantTypes={VariantType.OTHER_SUBSCRIBER})
    private InpatientAdjudication inpatientAdjudication;
    @EdiElt(value={"other_payer_prior_authorization_number"})
    @Prop(refType={ReferenceType.PRIOR_AUTHORIZATION_NUMBER}, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL}, variantTypes={VariantType.OTHER_SUBSCRIBER})
    private String payerPriorAuthorizationNumber;
    @EdiElt(value={"other_payer_referral_number"})
    @Prop(refType={ReferenceType.REFERRAL_NUMBER}, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL}, variantTypes={VariantType.OTHER_SUBSCRIBER})
    private String payerReferralNumber;
    @EdiElt(value={"other_payer_predetermination_identifier"})
    @Prop(refType={ReferenceType.PREDETERMINATION_OF_BENEFITS_NUMBER}, tran={TransactionType.DENTAL}, variantTypes={VariantType.OTHER_SUBSCRIBER})
    private String payerPredeterminationOfBenefitsIdentifier;
    @EdiElt(value={"other_payer_claim_control_number"})
    @Prop(refType={ReferenceType.ORIGINAL_REFERENCE_NUMBER}, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL}, variantTypes={VariantType.OTHER_SUBSCRIBER})
    private String payerClaimControlNumber;
    @Prop(refType={ReferenceType.PROPERTY_CASUALTY_CLAIM_NUMBER}, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL}, variantTypes={VariantType.SUBSCRIBER})
    private String propertyCasualtyClaimNumber;
    @EdiElt.Exclude
    @Prop(edi={"NM1"}, loop={"2330B"}, entityRole=EntityRole.PAYER, objType=ObjType.PARTY, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL}, variantTypes={VariantType.SUBSCRIBER, VariantType.OTHER_SUBSCRIBER})
    private OrgOrPerson payer;
    @EdiElt.Exclude
    @Prop(edi={"NM1"}, desc={"Other payer's providers"}, objType=ObjType.PARTY, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL}, variantTypes={VariantType.OTHER_SUBSCRIBER})
    private List<OrgOrPerson> providers;
    @EdiElt.Exclude
    @JsonIgnore
    private boolean isSubscriber;
    @EdiElt.Exclude
    @JsonIgnore
    private String loop;
    public static final String SUBSCRIBER_LOOP = "2000B";
    public static final String SUBSCRIBER_NAME_LOOP = "2010BA";
    public static final String OTHER_SUBSCRIBER_LOOP = "2320";
    public static final String OTHER_SUBSCRIBER_NAME_LOOP = "2330A";
    public static final String OTHER_SUBSCRIBER_CHILD_LOOP_PREFIX = "2330";
    public static final String PATIENT_LOOP = "2000C";
    public static final String PATIENT_NAME_LOOP = "2010CA";

    public static PatientSubscriber createSubscriber(String id, String lastName, String firstName, String groupOrPolicyNumber, LocalDate dateOfBirth, GenderType gender) {
        PatientSubscriber subscriber = new PatientSubscriber();
        subscriber.groupOrPolicyNumber(groupOrPolicyNumber);
        subscriber.person = new OrgOrPerson(EntityRole.INSURED_SUBSCRIBER, EntityType.INDIVIDUAL, IdentificationType.MEMBER_ID, id, lastName, firstName);
        subscriber.person.birthDate(dateOfBirth);
        subscriber.person.gender(gender);
        subscriber.relationshipType = RelationshipType.SELF;
        subscriber.payerResponsibilitySequence = PayerRespSequenceType.PRIMARY;
        return subscriber;
    }

    public static PatientSubscriber createPatient(RelationshipType relationshipType, String lastName, String firstName, LocalDate dateOfBirth, GenderType gender) {
        PatientSubscriber patient = new PatientSubscriber();
        patient.person = new OrgOrPerson(EntityRole.PATIENT, EntityType.INDIVIDUAL, null, null, lastName, firstName);
        patient.person.birthDate(dateOfBirth);
        patient.person.gender(gender);
        patient.relationshipType = relationshipType;
        return patient;
    }

    public void claimFilingIndicatorCode(String claimFilingIndicatorCode) {
        this.claimFilingIndicatorCode = claimFilingIndicatorCode;
        this.insurancePlanType = InsurancePlanType.fromEdi(claimFilingIndicatorCode);
    }

    public PatientSubscriber(PatientSubscriber otherPatientSubscriber) {
        this.payerResponsibilitySequence = otherPatientSubscriber.payerResponsibilitySequence;
        this.relationshipType = otherPatientSubscriber.relationshipType;
        this.groupOrPolicyNumber = otherPatientSubscriber.groupOrPolicyNumber;
        this.groupName = otherPatientSubscriber.groupName;
        this.claimFilingIndicatorCode = otherPatientSubscriber.claimFilingIndicatorCode;
        this.insurancePlanType = otherPatientSubscriber.insurancePlanType;
        this.person = otherPatientSubscriber.person;
        this.deathDate = otherPatientSubscriber.deathDate;
        this.weight = otherPatientSubscriber.weight;
        this.pregnancyIndicator = otherPatientSubscriber.pregnancyIndicator;
        this.payer = otherPatientSubscriber.payer;
        this.payerPaidAmount = otherPatientSubscriber.payerPaidAmount;
        this.nonCoveredAmount = otherPatientSubscriber.nonCoveredAmount;
        this.remainingPatientLiabilityAmount = otherPatientSubscriber.remainingPatientLiabilityAmount;
        if (otherPatientSubscriber.adjustments != null) {
            this.adjustments = new ArrayList<Adjustment>(otherPatientSubscriber.adjustments);
        }
        if (otherPatientSubscriber.providers != null) {
            this.providers = new ArrayList<OrgOrPerson>(otherPatientSubscriber.providers);
        }
        this.isSubscriber = otherPatientSubscriber.isSubscriber;
        this.payerClaimControlNumber = otherPatientSubscriber.payerClaimControlNumber;
        this.loop = otherPatientSubscriber.loop;
        this.payerPriorAuthorizationNumber = otherPatientSubscriber.payerPriorAuthorizationNumber;
        this.payerReferralNumber = otherPatientSubscriber.payerReferralNumber;
        this.payerPredeterminationOfBenefitsIdentifier = otherPatientSubscriber.payerPredeterminationOfBenefitsIdentifier;
        this.propertyCasualtyClaimNumber = otherPatientSubscriber.propertyCasualtyClaimNumber;
    }

    @Override
    public void populateFromSegInitial(EdiSeg seg, EdiParsingResults results) {
        mapper.populate(this, seg);
        if (seg.isInType(SegmentType.SBR)) {
            this.isSubscriber = true;
        }
        this.seg = EdiSeg.cloneKeySegInfo(seg);
    }

    @Override
    public boolean populateFromSegMaster(EdiSeg seg, EdiParsingResults results) {
        if (this.isSubscriber && seg.isInType(SegmentType.PAT) && seg.isInLoop(SUBSCRIBER_LOOP)) {
            mapper.populate(this, seg);
            return true;
        }
        return false;
    }

    public Integer age(LocalDate onThisDate) {
        Integer age = null;
        if (this.person != null) {
            age = DateUtils.age(this.person.birthDate(), onThisDate);
        }
        return age;
    }

    public String nameAndRelationship() {
        if (this.person == null) {
            return null;
        }
        String nameVal = this.name();
        if (this.relationshipType != null && this.relationshipType != RelationshipType.SELF) {
            nameVal = FormattingUtils.concat(nameVal, this.relationshipType().desc(), " (", ")");
        }
        return nameVal;
    }

    public String name() {
        if (this.person == null) {
            return null;
        }
        return this.person.fullName();
    }

    @Override
    public String summaryString() {
        return this.nameAndRelationship();
    }

    @Override
    public void populateFromSeg(EdiSeg seg, EdiParsingResults ediParsingResults) {
        if (this.seg.isInLoop(SUBSCRIBER_LOOP) && seg.isInLoop(SUBSCRIBER_NAME_LOOP) || this.seg.isInLoop(OTHER_SUBSCRIBER_LOOP) && seg.isInLoop(OTHER_SUBSCRIBER_NAME_LOOP) || this.seg.isInLoop(PATIENT_LOOP) && seg.isInLoop(PATIENT_NAME_LOOP)) {
            EdiEntity ediEntity;
            if (seg.isInType(SegmentType.NM1) && this.person == null && (ediEntity = seg.entity()) instanceof OrgOrPerson) {
                OrgOrPerson party;
                this.person = party = (OrgOrPerson)ediEntity;
                if (this.isSubscriber) {
                    this.person.entityRole(EntityRole.INSURED_SUBSCRIBER);
                }
            } else {
                Reference ref;
                ediEntity = seg.entity();
                if (ediEntity instanceof Reference && ReferenceType.PROPERTY_CASUALTY_CLAIM_NUMBER == (ref = (Reference)ediEntity).type()) {
                    this.propertyCasualtyClaimNumber = ref.identification();
                }
            }
        }
        if (this.seg.isParentOf(seg)) {
            if (seg.isInType(SegmentType.AMT)) {
                mapper.populate(this, seg);
            } else {
                EdiEntity ediEntity = seg.entity();
                if (ediEntity instanceof GroupedAdjustments) {
                    GroupedAdjustments groupedAdjs = (GroupedAdjustments)ediEntity;
                    if (this.adjustments == null) {
                        this.adjustments = new ArrayList<Adjustment>();
                    }
                    this.adjustments.addAll(groupedAdjs.adjustments());
                } else {
                    OrgOrPerson namedEntity;
                    ediEntity = seg.entity();
                    if (ediEntity instanceof OrgOrPerson && (namedEntity = (OrgOrPerson)ediEntity).entityRole().isProvider()) {
                        if (this.providers == null) {
                            this.providers = new ArrayList<OrgOrPerson>();
                        }
                        this.providers.add(namedEntity);
                    } else {
                        OrgOrPerson namedEntity2;
                        ediEntity = seg.entity();
                        if (ediEntity instanceof OrgOrPerson && (namedEntity2 = (OrgOrPerson)ediEntity).entityRole() == EntityRole.PAYER) {
                            this.payer = namedEntity2;
                        } else {
                            ediEntity = seg.entity();
                            if (ediEntity instanceof OutpatientAdjudication) {
                                OutpatientAdjudication moa;
                                this.outpatientAdjudication = moa = (OutpatientAdjudication)ediEntity;
                            } else {
                                ediEntity = seg.entity();
                                if (ediEntity instanceof InpatientAdjudication) {
                                    InpatientAdjudication mia;
                                    this.inpatientAdjudication = mia = (InpatientAdjudication)ediEntity;
                                }
                            }
                        }
                    }
                }
            }
        }
        if (this.seg.isAncestorOf(seg) && seg.isInType(SegmentType.REF) && seg.isInLoop("2330B")) {
            mapper.populate(this, seg);
        }
    }

    public void prepForPersistence() {
        if (this.person != null) {
            this.person.prepForPersistence();
        }
    }

    @Override
    public void loop(String loop) {
        this.loop = loop;
    }

    @JsonIgnore
    @Generated
    public EdiSeg seg() {
        return this.seg;
    }

    @Generated
    public PayerRespSequenceType payerResponsibilitySequence() {
        return this.payerResponsibilitySequence;
    }

    @Generated
    public RelationshipType relationshipType() {
        return this.relationshipType;
    }

    @Generated
    public String groupOrPolicyNumber() {
        return this.groupOrPolicyNumber;
    }

    @Generated
    public String groupName() {
        return this.groupName;
    }

    @Generated
    public String claimFilingIndicatorCode() {
        return this.claimFilingIndicatorCode;
    }

    @Generated
    public InsurancePlanType insurancePlanType() {
        return this.insurancePlanType;
    }

    @Generated
    public OrgOrPerson person() {
        return this.person;
    }

    @Generated
    public LocalDate deathDate() {
        return this.deathDate;
    }

    @Generated
    public BigDecimal weight() {
        return this.weight;
    }

    @Generated
    public String pregnancyIndicator() {
        return this.pregnancyIndicator;
    }

    @Generated
    public List<Adjustment> adjustments() {
        return this.adjustments;
    }

    @Generated
    public BigDecimal payerPaidAmount() {
        return this.payerPaidAmount;
    }

    @Generated
    public BigDecimal nonCoveredAmount() {
        return this.nonCoveredAmount;
    }

    @Generated
    public BigDecimal remainingPatientLiabilityAmount() {
        return this.remainingPatientLiabilityAmount;
    }

    @Generated
    public OutpatientAdjudication outpatientAdjudication() {
        return this.outpatientAdjudication;
    }

    @Generated
    public InpatientAdjudication inpatientAdjudication() {
        return this.inpatientAdjudication;
    }

    @Generated
    public String payerPriorAuthorizationNumber() {
        return this.payerPriorAuthorizationNumber;
    }

    @Generated
    public String payerReferralNumber() {
        return this.payerReferralNumber;
    }

    @Generated
    public String payerPredeterminationOfBenefitsIdentifier() {
        return this.payerPredeterminationOfBenefitsIdentifier;
    }

    @Generated
    public String payerClaimControlNumber() {
        return this.payerClaimControlNumber;
    }

    @Generated
    public String propertyCasualtyClaimNumber() {
        return this.propertyCasualtyClaimNumber;
    }

    @Generated
    public OrgOrPerson payer() {
        return this.payer;
    }

    @Generated
    public List<OrgOrPerson> providers() {
        return this.providers;
    }

    @JsonIgnore
    @Generated
    public boolean isSubscriber() {
        return this.isSubscriber;
    }

    @Override
    @JsonIgnore
    @Generated
    public String loop() {
        return this.loop;
    }

    @JsonIgnore
    @Generated
    public PatientSubscriber seg(EdiSeg seg) {
        this.seg = seg;
        return this;
    }

    @Generated
    public PatientSubscriber payerResponsibilitySequence(PayerRespSequenceType payerResponsibilitySequence) {
        this.payerResponsibilitySequence = payerResponsibilitySequence;
        return this;
    }

    @Generated
    public PatientSubscriber relationshipType(RelationshipType relationshipType) {
        this.relationshipType = relationshipType;
        return this;
    }

    @Generated
    public PatientSubscriber groupOrPolicyNumber(String groupOrPolicyNumber) {
        this.groupOrPolicyNumber = groupOrPolicyNumber;
        return this;
    }

    @Generated
    public PatientSubscriber groupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    @Generated
    public PatientSubscriber insurancePlanType(InsurancePlanType insurancePlanType) {
        this.insurancePlanType = insurancePlanType;
        return this;
    }

    @Generated
    public PatientSubscriber deathDate(LocalDate deathDate) {
        this.deathDate = deathDate;
        return this;
    }

    @Generated
    public PatientSubscriber weight(BigDecimal weight) {
        this.weight = weight;
        return this;
    }

    @Generated
    public PatientSubscriber pregnancyIndicator(String pregnancyIndicator) {
        this.pregnancyIndicator = pregnancyIndicator;
        return this;
    }

    @Generated
    public PatientSubscriber payerPaidAmount(BigDecimal payerPaidAmount) {
        this.payerPaidAmount = payerPaidAmount;
        return this;
    }

    @Generated
    public PatientSubscriber nonCoveredAmount(BigDecimal nonCoveredAmount) {
        this.nonCoveredAmount = nonCoveredAmount;
        return this;
    }

    @Generated
    public PatientSubscriber remainingPatientLiabilityAmount(BigDecimal remainingPatientLiabilityAmount) {
        this.remainingPatientLiabilityAmount = remainingPatientLiabilityAmount;
        return this;
    }

    @Generated
    public PatientSubscriber outpatientAdjudication(OutpatientAdjudication outpatientAdjudication) {
        this.outpatientAdjudication = outpatientAdjudication;
        return this;
    }

    @Generated
    public PatientSubscriber inpatientAdjudication(InpatientAdjudication inpatientAdjudication) {
        this.inpatientAdjudication = inpatientAdjudication;
        return this;
    }

    @Generated
    public PatientSubscriber payerPriorAuthorizationNumber(String payerPriorAuthorizationNumber) {
        this.payerPriorAuthorizationNumber = payerPriorAuthorizationNumber;
        return this;
    }

    @Generated
    public PatientSubscriber payerReferralNumber(String payerReferralNumber) {
        this.payerReferralNumber = payerReferralNumber;
        return this;
    }

    @Generated
    public PatientSubscriber payerPredeterminationOfBenefitsIdentifier(String payerPredeterminationOfBenefitsIdentifier) {
        this.payerPredeterminationOfBenefitsIdentifier = payerPredeterminationOfBenefitsIdentifier;
        return this;
    }

    @Generated
    public PatientSubscriber payerClaimControlNumber(String payerClaimControlNumber) {
        this.payerClaimControlNumber = payerClaimControlNumber;
        return this;
    }

    @Generated
    public PatientSubscriber propertyCasualtyClaimNumber(String propertyCasualtyClaimNumber) {
        this.propertyCasualtyClaimNumber = propertyCasualtyClaimNumber;
        return this;
    }

    @Generated
    public PatientSubscriber providers(List<OrgOrPerson> providers) {
        this.providers = providers;
        return this;
    }

    @JsonIgnore
    @Generated
    public PatientSubscriber isSubscriber(boolean isSubscriber) {
        this.isSubscriber = isSubscriber;
        return this;
    }

    @Generated
    public String toString() {
        return "PatientSubscriber(payerResponsibilitySequence=" + String.valueOf(this.payerResponsibilitySequence()) + ", relationshipType=" + String.valueOf(this.relationshipType()) + ", groupOrPolicyNumber=" + this.groupOrPolicyNumber() + ", groupName=" + this.groupName() + ", claimFilingIndicatorCode=" + this.claimFilingIndicatorCode() + ", insurancePlanType=" + String.valueOf(this.insurancePlanType()) + ", person=" + String.valueOf(this.person()) + ", deathDate=" + String.valueOf(this.deathDate()) + ", weight=" + String.valueOf(this.weight()) + ", adjustments=" + String.valueOf(this.adjustments()) + ", payerPaidAmount=" + String.valueOf(this.payerPaidAmount()) + ", nonCoveredAmount=" + String.valueOf(this.nonCoveredAmount()) + ", remainingPatientLiabilityAmount=" + String.valueOf(this.remainingPatientLiabilityAmount()) + ", outpatientAdjudication=" + String.valueOf(this.outpatientAdjudication()) + ", inpatientAdjudication=" + String.valueOf(this.inpatientAdjudication()) + ", payerClaimControlNumber=" + this.payerClaimControlNumber() + ", propertyCasualtyClaimNumber=" + this.propertyCasualtyClaimNumber() + ", payer=" + String.valueOf(this.payer()) + ", providers=" + String.valueOf(this.providers()) + ", isSubscriber=" + this.isSubscriber() + ")";
    }

    @Generated
    public PatientSubscriber() {
    }

    @Generated
    public PatientSubscriber person(OrgOrPerson person) {
        this.person = person;
        return this;
    }

    @Generated
    public PatientSubscriber adjustments(List<Adjustment> adjustments) {
        this.adjustments = adjustments;
        return this;
    }

    @Generated
    public PatientSubscriber payer(OrgOrPerson payer) {
        this.payer = payer;
        return this;
    }
}

