/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.orgperson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import hdi.codeent.CodeEntity;
import hdi.edi.dict.VariantType;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.EdiEntity;
import hdi.edi.objmapper.EdiObjectMapper;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.SegmentType;
import hdi.edi.parser.TransactionType;
import hdi.model.Reference;
import hdi.model.enumtype.IdentificationType;
import hdi.model.enumtype.ReferenceType;
import hdi.model.orgperson.Address;
import hdi.model.orgperson.ContactInfo;
import hdi.model.orgperson.EntityRole;
import hdi.model.orgperson.EntityType;
import hdi.model.orgperson.GenderType;
import hdi.model.orgperson.PartyIdName;
import hdi.util.CollectionUtils;
import hdi.util.SearchWordsPrefix;
import hdi.util.SearchWordsUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.annotation.Transient;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class OrgOrPerson
extends PartyIdName
implements EdiEntity {
    public static final EdiObjectMapper<OrgOrPerson> mapper = new EdiObjectMapper();
    @Prop(edi={"DMG02"}, variantTypes={VariantType.MEMBER, VariantType.PERSON_WITH_DEMOGRAPHIC}, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL, TransactionType.MEMBER_COVERAGE})
    private LocalDate birthDate;
    @EdiElt(value={"gender_code"})
    @Prop(edi={"DMG03"}, variantTypes={VariantType.MEMBER, VariantType.PERSON_WITH_DEMOGRAPHIC}, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL, TransactionType.MEMBER_COVERAGE})
    private GenderType gender;
    @Prop(objType=ObjType.ADDRESS)
    private Address address;
    @JsonIgnore
    private String taxonomyCode;
    @EdiElt.Exclude
    @Prop(edi={"PRV"}, desc={"Provider's specialty information (taxonomy). Populated only for billing, rendering, operating providers."}, codeLookupQuery="type=PROVIDER_TAXONOMY", objType=ObjType.CODE, tran={TransactionType.PROF, TransactionType.INST, TransactionType.DENTAL}, variantTypes={VariantType.PROVIDER})
    private CodeEntity providerTaxonomy;
    @Prop(objType=ObjType.CONTACT_INFO)
    private List<ContactInfo> contacts;
    @Prop(desc={"Other identifications"}, edi={"REF"}, objType=ObjType.REFERENCE)
    private List<Reference> additionalIds;
    @JsonIgnore
    private String idName;
    @JsonIgnore
    private String idNameRole;
    @EdiElt.Exclude
    @JsonIgnore
    private Set<String> searchWords = new HashSet<String>();
    @EdiElt.Exclude
    @JsonIgnore
    private int lineCount = 0;
    @EdiElt.Exclude
    @Transient
    @JsonIgnore
    protected EdiSeg seg;
    @EdiElt.Exclude
    @Transient
    @JsonIgnore
    private String loop;

    public OrgOrPerson(EntityRole role, IdentificationType idType, String id, String name) {
        this(role, EntityType.BUSINESS, idType, id, name, null);
    }

    public OrgOrPerson(EntityRole role, EntityType entityType, IdentificationType idType, String id, String name, String firstName) {
        this.entityRole = role;
        this.entityType = entityType;
        this.identificationType = idType;
        this.identifier = id;
        this.lastNameOrOrgName = name;
        this.firstName = firstName;
    }

    public OrgOrPerson(OrgOrPerson anotherOrgOrPerson) {
        this.entityRole = anotherOrgOrPerson.entityRole;
        this.entityType = anotherOrgOrPerson.entityType;
        this.identificationType = anotherOrgOrPerson.identificationType;
        this.identifier = anotherOrgOrPerson.identifier;
        this.taxId = anotherOrgOrPerson.taxId;
        this.lastNameOrOrgName = anotherOrgOrPerson.lastNameOrOrgName;
        this.firstName = anotherOrgOrPerson.firstName;
        this.middleName = anotherOrgOrPerson.middleName;
        this.birthDate = anotherOrgOrPerson.birthDate;
        this.gender = anotherOrgOrPerson.gender;
        this.address = anotherOrgOrPerson.address;
        this.taxonomyCode = anotherOrgOrPerson.taxonomyCode;
        this.providerTaxonomy = anotherOrgOrPerson.providerTaxonomy;
        this.contacts = anotherOrgOrPerson.contacts;
        this.additionalIds = anotherOrgOrPerson.additionalIds;
        this.idName = anotherOrgOrPerson.idName;
        this.idNameRole = anotherOrgOrPerson.idNameRole;
        this.lineCount = anotherOrgOrPerson.lineCount;
        this.loop = anotherOrgOrPerson.loop;
    }

    @Override
    public String identifier() {
        PartyIdName.IdWithLabel idWithLabel = this.identifierWithLabel();
        return idWithLabel.id();
    }

    public String primaryIdentifier() {
        return this.identifier;
    }

    public PartyIdName.IdWithLabel identifierWithLabel() {
        String id = this.identifier;
        String label = this.friendlyIdType();
        if (id == null && this.taxId != null) {
            id = this.taxId;
            label = ReferenceType.TAX_ID.desc();
        }
        if (id == null && this.additionalIds != null && !this.additionalIds.isEmpty()) {
            Reference ref = this.additionalIds.get(0);
            id = ref.identification();
            label = ref.type() != null ? ref.type().desc() : "ID";
        }
        return new PartyIdName.IdWithLabel(id, label);
    }

    @Override
    public void populateFromSegInitial(EdiSeg seg, EdiParsingResults ediParsingResults) {
        EdiSeg parent;
        super.populateFromSegInitial(seg, ediParsingResults);
        mapper.populate(this, seg);
        if (this.entityRole == EntityRole.BILLING_PROVIDER && (parent = seg.parentSeg()) != null) {
            List<EdiSeg> prvSegs = parent.findChildSegs(SegmentType.PRV);
            for (EdiSeg prvSeg : prvSegs) {
                if (seg.indexWithinTran() <= prvSeg.indexWithinTran()) continue;
                prvSeg.codeEntityConsumer(this::setProviderTaxonomy);
            }
        }
        this.seg = EdiSeg.cloneKeySegInfo(seg);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void populateFromSeg(EdiSeg seg, EdiParsingResults ediParsingResults) {
        EdiEntity segEnt = seg.entity();
        if (!this.seg.isParentOf(seg)) return;
        if (seg.isInType(SegmentType.DMG, SegmentType.PRV, SegmentType.REF)) {
            if (segEnt instanceof Reference) {
                Reference reference = (Reference)segEnt;
                if (StringUtils.endsWithAny((CharSequence)seg.name(), (CharSequence[])new CharSequence[]{"additional_identification", "additional_payer_identification", "additional_identification", "tax_identification", "upin_license_information", "secondary_identification", "secondary_identifier"})) {
                    this.addAdditionalId(reference);
                    return;
                }
            }
            mapper.populate(this, seg);
            if (!seg.isInType(SegmentType.PRV)) return;
            if (!this.entityRole.oneOf(EntityRole.RENDERING, EntityRole.ATTENDING, EntityRole.ASSISTANT_SURGEON)) return;
            seg.codeEntityConsumer(this::setProviderTaxonomy);
            return;
        }
        if (segEnt instanceof Address) {
            Address addr = (Address)segEnt;
            this.populateAddress(addr);
            return;
        }
        if (!(segEnt instanceof ContactInfo)) return;
        ContactInfo contactInfo = (ContactInfo)segEnt;
        this.populateContacts(contactInfo);
    }

    public void addAdditionalId(Reference reference) {
        if (reference.type() == ReferenceType.TAX_ID || reference.type() == ReferenceType.EIN || reference.type() == ReferenceType.SSN) {
            this.taxId = reference.identification();
            this.taxIdType = reference.type();
        } else {
            this.additionalIds = CollectionUtils.addWithInit(this.additionalIds, reference);
        }
        if (reference.type() == ReferenceType.PAYER_IDENTIFICATION_NUMBER && this.entityRole == EntityRole.PAYER && this.identificationType == IdentificationType.PAYOR_ID && StringUtils.startsWithIgnoreCase((CharSequence)this.loop, (CharSequence)"1000A")) {
            this.identifier = reference.identification();
        }
    }

    protected void populateContacts(ContactInfo contactInfo) {
        this.contacts = CollectionUtils.addWithInit(this.contacts, contactInfo);
    }

    protected void populateAddress(Address addr) {
        if (this.address == null) {
            this.address = new Address();
        }
        this.address.populate(addr);
    }

    public void setProviderTaxonomy(CodeEntity codeEntity) {
        if (codeEntity.subType().equals(ReferenceType.PROVIDER_TAXONOMY)) {
            this.providerTaxonomy = codeEntity;
        }
    }

    public String friendlyIdType() {
        String idTypeS = "ID";
        if (this.identificationType() != null && this.identificationType().shortDesc() != null) {
            idTypeS = this.identificationType().shortDesc();
        }
        return idTypeS;
    }

    public CodeEntity providerTaxonomy() {
        return this.providerTaxonomy;
    }

    public void prepForPersistence() {
        this.idName = this.getIdAndName();
        this.idNameRole = this.prepIdAndNameAndRole();
        this.searchWords = this.createSearchWords();
    }

    private Set<String> createSearchWords() {
        Set<String> searchWords = SearchWordsUtils.tokenizeTextFields(this.lastNameOrOrgName, this.firstName, this.identifier, this.entityRole.desc(), this.entityRole.shortDesc(), this.taxonomyCode, this.taxId, this.gender != null ? this.gender.desc() : null);
        if (this.identifier != null) {
            SearchWordsPrefix prefix = SearchWordsPrefix.ID;
            if (this.identificationType == IdentificationType.NPI) {
                prefix = SearchWordsPrefix.NPI;
            }
            SearchWordsUtils.addWordWithPrefix(searchWords, prefix, this.identifier);
        }
        if (this.address != null) {
            searchWords.addAll(this.address.prepSearchWords());
        }
        if (this.providerTaxonomy != null) {
            searchWords.addAll(this.providerTaxonomy.prepSearchWords());
        }
        if (this.additionalIds != null) {
            searchWords.addAll(this.additionalIds.stream().map(Reference::identification).collect(Collectors.toSet()));
        }
        if (this.contacts != null) {
            for (ContactInfo contactInfo : this.contacts) {
                searchWords.addAll(contactInfo.prepSearchWords());
            }
        }
        return searchWords;
    }

    @Override
    public void loop(String loop) {
        this.loop = loop;
    }

    public List<ContactInfo> contacts() {
        if (this.contacts == null) {
            return List.of();
        }
        return this.contacts;
    }

    public String findIdByType(ReferenceType type) {
        for (Reference id : this.additionalIds) {
            if (id.type() != type) continue;
            return id.identification();
        }
        return null;
    }

    public void addContact(ContactInfo contactInfo) {
        if (this.contacts == null) {
            this.contacts = new ArrayList<ContactInfo>();
        }
        this.contacts.add(contactInfo);
    }

    @Override
    public PartyIdName taxId(String taxId) {
        this.taxId(ReferenceType.EIN, taxId);
        return this;
    }

    public PartyIdName taxId(ReferenceType taxIdType, String taxId) {
        this.taxIdType = taxIdType;
        this.taxId = taxId;
        return this;
    }

    @Generated
    public LocalDate birthDate() {
        return this.birthDate;
    }

    @Generated
    public GenderType gender() {
        return this.gender;
    }

    @Generated
    public Address address() {
        return this.address;
    }

    @JsonIgnore
    @Generated
    public String taxonomyCode() {
        return this.taxonomyCode;
    }

    @Generated
    public List<Reference> additionalIds() {
        return this.additionalIds;
    }

    @JsonIgnore
    @Generated
    public String idName() {
        return this.idName;
    }

    @JsonIgnore
    @Generated
    public String idNameRole() {
        return this.idNameRole;
    }

    @JsonIgnore
    @Generated
    public Set<String> searchWords() {
        return this.searchWords;
    }

    @JsonIgnore
    @Generated
    public int lineCount() {
        return this.lineCount;
    }

    @Override
    @JsonIgnore
    @Generated
    public String loop() {
        return this.loop;
    }

    @Generated
    public OrgOrPerson birthDate(LocalDate birthDate) {
        this.birthDate = birthDate;
        return this;
    }

    @Generated
    public OrgOrPerson gender(GenderType gender) {
        this.gender = gender;
        return this;
    }

    @JsonIgnore
    @Generated
    public OrgOrPerson taxonomyCode(String taxonomyCode) {
        this.taxonomyCode = taxonomyCode;
        return this;
    }

    @JsonIgnore
    @Generated
    public OrgOrPerson idName(String idName) {
        this.idName = idName;
        return this;
    }

    @JsonIgnore
    @Generated
    public OrgOrPerson idNameRole(String idNameRole) {
        this.idNameRole = idNameRole;
        return this;
    }

    @JsonIgnore
    @Generated
    public OrgOrPerson searchWords(Set<String> searchWords) {
        this.searchWords = searchWords;
        return this;
    }

    @JsonIgnore
    @Generated
    public OrgOrPerson seg(EdiSeg seg) {
        this.seg = seg;
        return this;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrgOrPerson)) {
            return false;
        }
        OrgOrPerson other = (OrgOrPerson)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OrgOrPerson;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public OrgOrPerson() {
    }

    @Override
    @Generated
    public String toString() {
        return "OrgOrPerson(super=" + super.toString() + ", birthDate=" + String.valueOf(this.birthDate()) + ", gender=" + String.valueOf(this.gender()) + ", address=" + String.valueOf(this.address()) + ", taxonomyCode=" + this.taxonomyCode() + ", contacts=" + String.valueOf(this.contacts()) + ", additionalIds=" + String.valueOf(this.additionalIds()) + ", lineCount=" + this.lineCount() + ", loop=" + this.loop() + ")";
    }

    @Generated
    public OrgOrPerson address(Address address) {
        this.address = address;
        return this;
    }

    @Generated
    public OrgOrPerson providerTaxonomy(CodeEntity providerTaxonomy) {
        this.providerTaxonomy = providerTaxonomy;
        return this;
    }

    @Generated
    public OrgOrPerson contacts(List<ContactInfo> contacts) {
        this.contacts = contacts;
        return this;
    }

    @Generated
    public OrgOrPerson additionalIds(List<Reference> additionalIds) {
        this.additionalIds = additionalIds;
        return this;
    }

    @JsonIgnore
    @Generated
    public OrgOrPerson lineCount(int lineCount) {
        this.lineCount = lineCount;
        return this;
    }
}

