/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.orgperson;

import hdi.codeent.CodeEntity;
import hdi.codeent.PrimaryCodeType;
import hdi.edi.qualifier.EdiQualifier;
import hdi.edi.qualifier.X12CodeTypeEnt;
import hdi.util.WordStringUtils;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum EntityRole implements EdiQualifier
{
    PAYEE("PE", "Payee", false, "Payee"),
    INSURED_SUBSCRIBER("IL", "Insured Subscriber", false, "Ins. Subs"),
    PAYER("PR", "Payer", false, "Payer"),
    PATIENT("QC", "Patient", false, "Patient"),
    DEPENDENT("03", "Dependent", false, "Dependent"),
    CORRECTED_INSURED("74", "Corrected Insured or Patient", false, "Corrected Insured"),
    RECEIVER("40", "Receiver", false, "Receiver"),
    SUBMITTER("41", "Submitter", false, "Submitter"),
    SUBSCRIBER("44", "Subscriber", false, "Subs"),
    OTHER_SUBSCRIBER("GB", "Other Subscriber", false, "Subs"),
    PAY_TO_PROVIDER("87", "Pay to Provider", true, "Pay to Provider"),
    BILLING_PROVIDER("85", "Billing Provider", true, "Bill"),
    RENDERING("82", "Rendering Provider", true, "Rend"),
    SUPERVISING("DQ", "Supervising Provider", true, "Super"),
    PURCHASE_SERVICE("QB", "Purchased Service Provider", true, "Purch. Serv"),
    ORDERING("DK", "Ordering Provider", true, "Ord"),
    REFERRING("DN", "Referring Provider", true, "Ref"),
    PRIMARY_CARE("P3", "Primary Care Referring Provider", true, "PCP Ref"),
    SERVICE_FACILITY("77", "Service Facility", true, "Fac"),
    SERVICE_PROVIDER("SJ", "Service Provider", true, "Svc Provider"),
    FACILITY("FA", "Facility", true, "Fac"),
    CLINIC("G3", "Clinic", true, "Clinic"),
    PURCHASED("QB", "Purchased Care Provider", true, "Purch. Care"),
    ATTENDING("71", "Attending Provider", true, "Att"),
    OPERATING("72", "Operating Provider", true, "Oper"),
    OTHER_PHYSICIAN("73", "Other Physician", true, "Other"),
    OTHER_OPERATING("ZZ", "Other Operating Provider", true, "Oth"),
    ASSISTANT_SURGEON("DD", "Assistant Surgeon Provider", true, "Surg"),
    PICKUP_ADDRESS("PW", "Pickup Address", true, "Pickup Addr"),
    DROP_OFF_LOCATION("45", "Drop-off Location", true, "Drop-off"),
    ADMITTING_PHYSICIAN("D0", "Admitting Physician", true, "Admitting"),
    ADMITTING_SERVICES("AAJ", "Admitting Services", true, "Admitting"),
    CROSSOVER_CARRIER("TT", "Crossover Carrier", false, "Crossover"),
    PROVIDER("1P", "Provider", true, "Provider"),
    UTILIZATION_MANAGEMENT_ORGANIZATION("X3", "Utilization Management Organization", false, "Utilization Management Organization"),
    EMPLOYEE_NAME("EY", "Employee Name", false, "Employee Name"),
    CLEARINGHOUSE("AY", "Clearinghouse", false, "Clearinghouse"),
    PATIENT_FACILITY("P0", "Patient Facility", true, "Patient Facility"),
    PREPARER("P1", "Preparer", false, "Preparer"),
    PRIMARY_INSURED("P2", "Primary Insured", false, "Primary Insured"),
    PRIOR_INSURANCE_CARRIER("P4", "Prior Insurance Carrier", false, "Prior Insurance Carrier"),
    PRIOR_INCORRECT_INSURED("70", "Prior Incorrect Insured", false, "Prior Incorrect Insured"),
    EDUCATIONAL_INSTITUTION("M8", "Educational Institution", false, "Educational Institution"),
    PLAN_SPONSOR("P5", "Plan Sponsor", false, "Plan Sponsor"),
    INSURER("IN", "Insurer", false, "Insurer"),
    IN_PATIENT_PHARMACY("IQ", "In-patient Pharmacy", true, "In-patient Pharmacy"),
    SELF_INSURED("IR", "Self Insured", true, "Self Insured"),
    MAILING_ADDRESS("31", "Mailing Address", false, "Mailing Address"),
    EMPLOYER("36", "Employer", false, "Employer"),
    GROUP("GW", "Group", false, "Group"),
    PARTICIPANT("75", "Participant", false, "Participant"),
    TPA("TV", "Third Party Administrator", false, "TPA"),
    BROKER_OR_SALES_OFFICE("BO", "Broker or Sales Office", false, null),
    LABORATORY("1X", "Laboratory", true, "Laboratory"),
    OB_GYN_FACILITY("3D", "OB&GYN Facility", true, "OB&GYN Facility"),
    HOSPITAL("80", "Hospital", true, "Hospital"),
    OPTOMETRIST("OD", "Optometrist", true, "Participant"),
    PHARMACY("QA", "Pharmacy", true, "Pharmacy"),
    DENTIST("QN", "Dentist", true, "Dentist"),
    MANAGED_CARE("Y2", "Managed Care Organization", true, "Managed Care Organization"),
    CUSTODIAL_PARENT("S3", null, false, null),
    CASE_MANAGER("6Y", null, false, null),
    KEY_PERSON("9K", null, false, null),
    RESPONSIBLE_ENTITY("E1", null, false, null),
    EXECUTOR_OF_ESTATE("EI", null, false, null),
    EX_SPOUSE("EXS", null, false, null),
    GUARDIAN("GD", null, false, null),
    POWER_OF_ATTORNEY("J6", null, false, null),
    LEGAL_REPRESENTATIVE("LR", null, false, null),
    RESPONSIBLE_PARTY("QD", null, false, null),
    PARENT("S1", null, false, null),
    SIGNIFICANT_OTHER("TZ", null, false, null),
    SPOUSE("X4", null, false, null),
    SHIP_TO("ST", "Ship To", false, "Ship To"),
    SHIP_SF("SF", "Ship From", false, "Ship From"),
    REMIT_TO("RI", "Remit To", false, "Remit To"),
    BROKER("BR", "Broker", false, null),
    BILL_AND_SHIP_TO("BS", "Bill and Ship To", false, null),
    BILL_TO_PARTY("BT", "Bill To Party", false, null),
    MESSAGE_FROM("FR", "Message From", false, null),
    SELLING_PARTY("SE", "Selling Party", false, null),
    SHIPPER("SH", "Shipper", false, null),
    BUYING_PARTY("BY", "Buying Party", false, null),
    INFORMATION_SOURCE("ACV", "Information Source", false, null),
    NONE("ZZ", "None", false, null);

    @Generated
    private static final Logger log;
    private final String ediValue;
    private final String desc;
    private final boolean isProvider;
    private final String veryShortDesc;
    private static final EdiQualifier SUBTYPE_FOR_CODE_ENT;

    public static EntityRole fromEdi(String ediCode) {
        for (EntityRole v : EntityRole.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)ediCode, (CharSequence)v.ediValue)) continue;
            return v;
        }
        log.debug("Unknown Entity Role type; EDI code: {}", (Object)ediCode);
        return null;
    }

    public boolean oneOf(EntityRole ... roles) {
        for (EntityRole role : roles) {
            if (role != this) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeEntity toCodeEntity() {
        CodeEntity codeEnt = new CodeEntity(PrimaryCodeType.X12_ENTITY_IDENTIFIER_CODE, SUBTYPE_FOR_CODE_ENT, this.ediValue);
        codeEnt.desc(this.desc());
        codeEnt.shortDesc(this.veryShortDesc);
        codeEnt.enumName(this.name());
        return codeEnt;
    }

    @Override
    public String desc() {
        if (this.desc != null) {
            return this.desc;
        }
        return WordStringUtils.enumNameToDesc(this);
    }

    public String veryShortDesc() {
        if (this.veryShortDesc == null) {
            return this.desc();
        }
        return this.veryShortDesc;
    }

    @Override
    public String ediEltId() {
        return "NM1";
    }

    @Override
    @Generated
    public String ediValue() {
        return this.ediValue;
    }

    @Generated
    public boolean isProvider() {
        return this.isProvider;
    }

    @Generated
    private EntityRole(String ediValue, String desc, boolean isProvider, String veryShortDesc) {
        this.ediValue = ediValue;
        this.desc = desc;
        this.isProvider = isProvider;
        this.veryShortDesc = veryShortDesc;
    }

    static {
        log = LoggerFactory.getLogger(EntityRole.class);
        SUBTYPE_FOR_CODE_ENT = new X12CodeTypeEnt(PrimaryCodeType.X12_ENTITY_IDENTIFIER_CODE.name(), "X12 Entity Identifier Code");
    }
}

