/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.orgperson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.EdiEntity;
import hdi.edi.objmapper.EdiObjectMapper;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.Elt;
import hdi.model.orgperson.ContactNumber;
import hdi.model.orgperson.ContactType;
import hdi.util.SearchWordsUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.annotation.Transient;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@EdiObj(seg={"PER"})
public class ContactInfo
implements EdiEntity {
    @EdiElt.Exclude
    @Transient
    public static final EdiObjectMapper<ContactInfo> mapper = new EdiObjectMapper();
    @EdiElt(pos=1, seg="PER", isRequired=true)
    private String functionCode = "IC";
    @Prop(edi={"PER02"})
    @EdiElt(pos=2, seg="PER")
    private String name;
    @Prop(objType=ObjType.CONTACT_NUMBER)
    private List<ContactNumber> contactNumbers = new ArrayList<ContactNumber>();

    public ContactInfo(String name) {
        this.name = name;
    }

    @Override
    public void populateFromSegInitial(EdiSeg seg, EdiParsingResults results) {
        mapper.populate(this, seg);
        ContactType contactType = null;
        for (Elt elt : seg.eltSet().elts()) {
            if (StringUtils.contains((CharSequence)elt.name(), (CharSequence)"_qualifier")) {
                contactType = ContactType.fromEdi(elt.stringVal());
                continue;
            }
            if (!StringUtils.contains((CharSequence)elt.name(), (CharSequence)"communication_number")) continue;
            if (contactType == null) {
                contactType = ContactType.UNKNOWN;
            }
            String curNumber = elt.stringVal();
            this.contactNumbers.add(new ContactNumber(contactType, curNumber));
        }
    }

    public Set<String> prepSearchWords() {
        Set<String> searchWords = SearchWordsUtils.tokenizeTextFields(this.name);
        for (ContactNumber contactNumber : this.contactNumbers) {
            searchWords.add(contactNumber.number());
        }
        return searchWords;
    }

    public void addContactNumber(ContactNumber contactNumber) {
        this.contactNumbers.add(contactNumber);
    }

    public void addContactNumber(ContactType type, String contactNumber) {
        this.contactNumbers.add(new ContactNumber(type, contactNumber));
    }

    @Generated
    public String toString() {
        return "ContactInfo(functionCode=" + this.functionCode() + ", name=" + this.name() + ", contactNumbers=" + String.valueOf(this.contactNumbers()) + ")";
    }

    @Generated
    public String functionCode() {
        return this.functionCode;
    }

    @Generated
    public String name() {
        return this.name;
    }

    @Generated
    public List<ContactNumber> contactNumbers() {
        return this.contactNumbers;
    }

    @Generated
    public ContactInfo() {
    }

    @Generated
    public ContactInfo contactNumbers(List<ContactNumber> contactNumbers) {
        this.contactNumbers = contactNumbers;
        return this;
    }
}

