/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.orgperson;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.EdiEntity;
import hdi.edi.objmapper.EdiObjectMapper;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.util.FormattingUtils;
import hdi.util.SearchWordsPrefix;
import hdi.util.SearchWordsUtils;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.springframework.data.annotation.Transient;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class Address
implements EdiEntity {
    @EdiElt.Exclude
    @Transient
    public static final EdiObjectMapper<Address> mapper = new EdiObjectMapper();
    @Prop(edi={"N301"})
    @EdiElt(seg="N3", pos=1)
    private String line;
    @Prop(edi={"N302"})
    private String line2;
    @Prop(edi={"N401"})
    @EdiElt(seg="N4", pos=1, isRequired=true)
    private String city;
    @Prop(edi={"N402"})
    @EdiElt(seg="N4", pos=2)
    private String stateCode;
    @Prop(edi={"N403"})
    private String zipCode;
    @Prop(edi={"N404"})
    private String countryCode;

    public Address(String line, String line2, String city, String stateCode, String zipCode) {
        this.line = line;
        this.line2 = line2;
        this.city = city;
        this.stateCode = stateCode;
        this.zipCode = zipCode;
    }

    @Override
    public void populateFromSegInitial(EdiSeg seg, EdiParsingResults results) {
        mapper.populate(this, seg);
    }

    @Override
    public String summaryString() {
        String s = "";
        s = FormattingUtils.concat(s, this.line, "");
        s = FormattingUtils.concat(s, this.line2, " ");
        s = FormattingUtils.concat(s, this.city, " ");
        s = FormattingUtils.concat(s, this.stateCode, ", ");
        s = FormattingUtils.concat(s, this.zipCode, " ");
        s = FormattingUtils.concat(s, this.countryCode, ", ");
        return s;
    }

    public String cityStateZipString() {
        String s = "";
        String cityNameToUse = this.city;
        if (this.city != null) {
            cityNameToUse = WordUtils.capitalizeFully((String)this.city);
        }
        s = FormattingUtils.concat(s, cityNameToUse, " ");
        s = FormattingUtils.concat(s, this.stateCode, ", ");
        s = FormattingUtils.concat(s, this.zipFive(), " ");
        s = FormattingUtils.concat(s, this.countryCode, ", ");
        return s;
    }

    public String zipFive() {
        if (this.zipCode != null && this.zipCode.length() > 5) {
            return StringUtils.left((String)this.zipCode, (int)5);
        }
        return this.zipCode;
    }

    public void populate(Address addr) {
        if (addr.line != null) {
            this.line = addr.line;
        }
        if (addr.line2 != null) {
            this.line2 = addr.line2;
        }
        if (addr.city != null) {
            this.city = addr.city;
        }
        if (addr.stateCode != null) {
            this.stateCode = addr.stateCode;
        }
        if (addr.zipCode != null) {
            this.zipCode = addr.zipCode;
        }
        if (addr.countryCode != null) {
            this.countryCode = addr.countryCode;
        }
    }

    public Set<String> prepSearchWords() {
        Set<String> searchWords = SearchWordsUtils.tokenizeTextFields(this.line, this.city, this.zipCode, this.stateCode, this.countryCode);
        if (this.zipCode != null) {
            SearchWordsUtils.addWordWithPrefix(searchWords, SearchWordsPrefix.ZIP, this.zipCode);
        }
        if (this.stateCode != null) {
            SearchWordsUtils.addWordWithPrefix(searchWords, SearchWordsPrefix.STATE, this.stateCode);
        }
        return searchWords;
    }

    @Generated
    public String line() {
        return this.line;
    }

    @Generated
    public String line2() {
        return this.line2;
    }

    @Generated
    public String city() {
        return this.city;
    }

    @Generated
    public String stateCode() {
        return this.stateCode;
    }

    @Generated
    public String zipCode() {
        return this.zipCode;
    }

    @Generated
    public String countryCode() {
        return this.countryCode;
    }

    @Generated
    public Address line(String line) {
        this.line = line;
        return this;
    }

    @Generated
    public Address line2(String line2) {
        this.line2 = line2;
        return this;
    }

    @Generated
    public Address city(String city) {
        this.city = city;
        return this;
    }

    @Generated
    public Address stateCode(String stateCode) {
        this.stateCode = stateCode;
        return this;
    }

    @Generated
    public Address zipCode(String zipCode) {
        this.zipCode = zipCode;
        return this;
    }

    @Generated
    public Address countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Address)) {
            return false;
        }
        Address other = (Address)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$line = this.line();
        String other$line = other.line();
        if (this$line == null ? other$line != null : !this$line.equals(other$line)) {
            return false;
        }
        String this$line2 = this.line2();
        String other$line2 = other.line2();
        if (this$line2 == null ? other$line2 != null : !this$line2.equals(other$line2)) {
            return false;
        }
        String this$city = this.city();
        String other$city = other.city();
        if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
            return false;
        }
        String this$stateCode = this.stateCode();
        String other$stateCode = other.stateCode();
        if (this$stateCode == null ? other$stateCode != null : !this$stateCode.equals(other$stateCode)) {
            return false;
        }
        String this$zipCode = this.zipCode();
        String other$zipCode = other.zipCode();
        if (this$zipCode == null ? other$zipCode != null : !this$zipCode.equals(other$zipCode)) {
            return false;
        }
        String this$countryCode = this.countryCode();
        String other$countryCode = other.countryCode();
        return !(this$countryCode == null ? other$countryCode != null : !this$countryCode.equals(other$countryCode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Address;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $line = this.line();
        result = result * 59 + ($line == null ? 43 : $line.hashCode());
        String $line2 = this.line2();
        result = result * 59 + ($line2 == null ? 43 : $line2.hashCode());
        String $city = this.city();
        result = result * 59 + ($city == null ? 43 : $city.hashCode());
        String $stateCode = this.stateCode();
        result = result * 59 + ($stateCode == null ? 43 : $stateCode.hashCode());
        String $zipCode = this.zipCode();
        result = result * 59 + ($zipCode == null ? 43 : $zipCode.hashCode());
        String $countryCode = this.countryCode();
        result = result * 59 + ($countryCode == null ? 43 : $countryCode.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Address(line=" + this.line() + ", line2=" + this.line2() + ", city=" + this.city() + ", stateCode=" + this.stateCode() + ", zipCode=" + this.zipCode() + ", countryCode=" + this.countryCode() + ")";
    }

    @Generated
    public Address() {
    }
}

