/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.enumtype;

import hdi.codeent.CodeEntity;
import hdi.codeent.PrimaryCodeType;
import hdi.edi.qualifier.EdiQualifier;
import hdi.edi.qualifier.X12CodeTypeEnt;
import hdi.util.WordStringUtils;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum QuantityType implements EdiQualifier
{
    COVERED("CA", "Covered - Actual"),
    COINSURED("CD", "Coinsured - Actual"),
    LIFE_TIME_ACTUAL("LA", "Life-time Reserve - Actual"),
    LIFE_TIME_ESTIMATED("LE", "Life-time Reserve - Estimate"),
    NON_COVERED("NE", "Non-Covered - Estimated"),
    NOT_REPLACED_BLOOD_UNITS("NR", "Not Replaced Blood Units"),
    OUTLIER_DAYS("OU", "Outlier Days"),
    PATIENTS("PT", "Patients"),
    UNITS("FL", "Units"),
    PRESCRIPTION("PS", "Prescription"),
    VISITS("VS", "Visits"),
    MEDICARE_MEDICAID_CAT_1("ZK", "Medicare of Medicaid Payment Cat. 1"),
    MEDICARE_MEDICAID_CAT_2("ZL", "Medicare of Medicaid Payment Cat. 2"),
    MEDICARE_MEDICAID_CAT_3("ZM", "Medicare of Medicaid Payment Cat. 3"),
    MEDICARE_MEDICAID_CAT_4("ZN", "Medicare of Medicaid Payment Cat. 4"),
    MEDICARE_MEDICAID_CAT_5("ZO", "Medicare of Medicaid Payment Cat. 5"),
    DEPENDENT_TOTAL("DT", null),
    EMPLOYEE_TOTAL("ET", null),
    TOTAL("TO", null),
    APPROVED("QA", null),
    REJECTED("QC", null),
    UNACKNOWLEDGED("AA", null),
    ACKNOWLEDGED("90", null),
    NONE("99999", "None");

    private final String ediValue;
    private final String desc;
    private static final EdiQualifier SUBTYPE_FOR_CODE_ENT;

    public static QuantityType fromEdi(String ediCode) {
        for (QuantityType v : QuantityType.values()) {
            if (v.ediValue == null || !StringUtils.equalsIgnoreCase((CharSequence)ediCode, (CharSequence)v.ediValue)) continue;
            return v;
        }
        return null;
    }

    @Override
    public String desc() {
        if (this.desc != null) {
            return this.desc;
        }
        return WordStringUtils.enumNameToDesc(this);
    }

    @Override
    public String ediEltId() {
        return "QTY02";
    }

    @Override
    public CodeEntity toCodeEntity() {
        CodeEntity codeEnt = new CodeEntity(PrimaryCodeType.X12_QUANTITY_QUALIFIER_CODE, SUBTYPE_FOR_CODE_ENT, this.ediValue);
        codeEnt.desc(this.desc());
        codeEnt.enumName(this.name());
        return codeEnt;
    }

    @Override
    @Generated
    public String ediValue() {
        return this.ediValue;
    }

    @Generated
    private QuantityType(String ediValue, String desc) {
        this.ediValue = ediValue;
        this.desc = desc;
    }

    static {
        SUBTYPE_FOR_CODE_ENT = new X12CodeTypeEnt(PrimaryCodeType.X12_QUANTITY_QUALIFIER_CODE.name(), "X12 Quantity Qualifier Code");
    }
}

