/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.enumtype;

import hdi.edi.qualifier.EdiQualifier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ProcType implements EdiQualifier
{
    HCPCS("HC", "HCPCS Procedure", "Health Care Financing Administration Common Procedural Coding System"),
    HCPCS_PRINCIPAL("BP", "HCPCS Principal Procedure", "Health Care Financing Administration Common Procedural Coding System Principal Procedure"),
    CPT("HC", "CPT Procedure", "AMA's CPT codes"),
    ICD_10_PCS_PRINCIPAL("BBR", "ICD-10-PCS Principal Procedure", "International Classification of Diseases Clinical\nModification (ICD-10-PCS) Principal Procedure\nCodes"),
    ICD_10_PCS("BBQ", "ICD-10-PCS Procedure", "International Classification of Diseases Clinical\nModification (ICD-10-PCS) Other Procedure Codes"),
    ER("ER", "Jurisdiction Specific Procedure", "Jurisdiction Specific Procedure and Supply Codes"),
    HIEC("IV", "Home Infusion Product/Service", "Home Infusion EDI Coalition (HIEC) Product/Service Code"),
    ABC_PRINCIPAL("CAH", "Advanced Billing Concepts Procedure", "Advanced Billing Concepts (ABC) Codes"),
    ABC("WK", "Advanced Billing Concepts Procedure", "Advanced Billing Concepts (ABC) Codes"),
    ICD_9_PCS_PRINCIPAL("BR", "ICD-9-PCS Principal Procedure", "ICD-9-PCS Principal Procedure"),
    ICD_9_PCS("BQ", "ICD-9-PCS Procedure", "ICD-9-PCS Other Procedure"),
    HIPPS("HP", "Skilled Nursing Facility Rate Code", "Health Insurance Prospective Payment System\n(HIPPS) Skilled Nursing Facility Rate Code"),
    ADA("AD", "American Dental Association Procedure", "American Dental Association Codes"),
    HCPCS_ADD("BO", "HCPCS Principal Procedure", "Health Care Financing Administration Common Procedural Coding System Principal Procedure"),
    NONE("99999", "None", null);

    @Generated
    private static final Logger log;
    private final String ediValue;
    private final String desc;
    private final String longDesc;

    public static ProcType fromEdi(String ediCode) {
        for (ProcType v : ProcType.values()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)ediCode, (CharSequence)v.ediValue)) continue;
            return v;
        }
        return null;
    }

    @Override
    public boolean isMedicalCode() {
        return true;
    }

    @Override
    public String ediEltId() {
        return "HI";
    }

    @Override
    @Generated
    public String ediValue() {
        return this.ediValue;
    }

    @Override
    @Generated
    public String desc() {
        return this.desc;
    }

    @Generated
    public String longDesc() {
        return this.longDesc;
    }

    @Generated
    private ProcType(String ediValue, String desc, String longDesc) {
        this.ediValue = ediValue;
        this.desc = desc;
        this.longDesc = longDesc;
    }

    static {
        log = LoggerFactory.getLogger(ProcType.class);
    }
}

