/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.enumtype;

import hdi.edi.qualifier.EdiQualifier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public enum IdentificationType implements EdiQualifier
{
    MEMBER_ID("MI", "Member Identification Number", "Member ID"),
    STANDARD_HEALTH_ID("II", "Standard Unique Health Identifier", "Standard Unique Health ID"),
    MEDICAID_ID("MR", "Medicaid Identification Number", "Medicaid ID"),
    HEALTH_INS_CLAIM_NUMBER("HN", "Health Insurance Claim (HIC) Number", "HIC Number"),
    NPI("XX", "National Provider Identifier (NPI)", "NPI"),
    SERVICE_PROVIDER("SV", "Service Provider Number", "Service Provider ID"),
    PAYOR_ID("PI", "Payor Identification", "Payor ID"),
    PROVIDER_COMMERCIAL_NUMBER("PC", "Provider Commercial Number", "Commercial Number"),
    CMS_PLAN_ID("XV", "Centers for Medicare and Medicaid Services PlanID", "Plan ID"),
    ETIN("46", "Electronic Transmitter Identification Number (ETIN)", "ETIN"),
    EMPLOYER_ID("24", "Employer's Identification Number", "Employer ID"),
    SSN("34", "Social Security Identifier (SSN)", "SSN"),
    STANDARD_UNIQUE_HEALTH_IDENTIFIER("II", "Standard Unique Health Identifier", "Health ID"),
    EIN("FI", "Federal Taxpayer's Identification Number", "EIN"),
    ORIGINATING_ID("93", "Code assigned by the organization originating the transaction set", "Originating ID"),
    DESTINATION_ID("94", "Code assigned by the organization that is the ultimate destination of the transaction set", "Destination ID"),
    MUTUALLY_DEFINED("ZZ", "Mutually Defined", "Mutually Defined"),
    INSURED_CHANGED_ID("C", "Insured's Changed ID", "Insured's Changed ID"),
    ASSIGNED_BY_SELLER("91", "Assigned by Seller", "Assigned by Seller"),
    ASSIGNED_BY_BUYER("92", "Assigned by Buyer", "Assigned by Buyer"),
    DUNS("1", "Dun & Bradstreet number", "D-U-N-S Number"),
    UNKNOWN(null, "Unknown Identification Type", "Unknown");

    private final String ediValue;
    private final String desc;
    private final String shortDesc;

    public static IdentificationType fromEdi(String ediCode) {
        for (IdentificationType v : IdentificationType.values()) {
            if (v.ediValue == null || !StringUtils.equalsIgnoreCase((CharSequence)ediCode, (CharSequence)v.ediValue)) continue;
            return v;
        }
        return null;
    }

    @Override
    @Generated
    public String ediValue() {
        return this.ediValue;
    }

    @Override
    @Generated
    public String desc() {
        return this.desc;
    }

    @Override
    @Generated
    public String shortDesc() {
        return this.shortDesc;
    }

    @Generated
    private IdentificationType(String ediValue, String desc, String shortDesc) {
        this.ediValue = ediValue;
        this.desc = desc;
        this.shortDesc = shortDesc;
    }
}

