/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.enumtype;

import hdi.edi.qualifier.EdiQualifier;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DrugIdentificationType implements EdiQualifier
{
    NDC("N4", "03", "Drug Info - NDC");

    @Generated
    private static final Logger log;
    private final String ediValue;
    private final String ncpdpValue;
    private final String desc;

    public static DrugIdentificationType fromEdi(String ediCode) {
        for (DrugIdentificationType v : DrugIdentificationType.values()) {
            if (!StringUtils.equalsAnyIgnoreCase((CharSequence)ediCode, (CharSequence[])new CharSequence[]{v.ediValue, v.ncpdpValue})) continue;
            return v;
        }
        return null;
    }

    @Override
    public boolean isMedicalCode() {
        return true;
    }

    @Override
    @Generated
    public String ediValue() {
        return this.ediValue;
    }

    @Generated
    public String ncpdpValue() {
        return this.ncpdpValue;
    }

    @Override
    @Generated
    public String desc() {
        return this.desc;
    }

    @Generated
    private DrugIdentificationType(String ediValue, String ncpdpValue, String desc) {
        this.ediValue = ediValue;
        this.ncpdpValue = ncpdpValue;
        this.desc = desc;
    }

    static {
        log = LoggerFactory.getLogger(DrugIdentificationType.class);
    }
}

