/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.coverage;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import hdi.edi.csv.CsvUtils;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.EdiEntity;
import hdi.edi.objmapper.EdiObjectMapper;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.Elt;
import hdi.edi.parser.EltSet;
import hdi.edi.parser.SegmentType;
import hdi.model.coverage.LanguageInfo;
import hdi.model.coverage.MemberCoverage;
import hdi.model.orgperson.OrgOrPerson;
import hdi.util.NumbersUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@EdiObj(loop={"2100A"}, seg={"NM1"})
public class Member
extends OrgOrPerson {
    private static final EdiObjectMapper<Member> mapper = new EdiObjectMapper();
    @EdiElt(seg="DMG", pos=4)
    private String maritalStatusCode;
    @Prop(edi={"DMG05"})
    private String ethnicityCode;
    @EdiElt(seg="DMG", pos=6)
    private String citizenshipCode;
    @Prop(edi={"EC01,EC02,EC03"}, objType=ObjType.STRING)
    private List<String> employmentClassCodes;
    @EdiElt(pos=1, seg="ICM")
    private String wageFrequencyCode;
    @EdiElt(pos=2, seg="ICM")
    private BigDecimal wageAmount;
    @EdiElt(pos=3, seg="ICM")
    private BigDecimal workHoursCount;
    @EdiElt(pos=4, seg="ICM")
    private String employerLocationIdentificationCode;
    @EdiElt(pos=5, seg="ICM")
    private String salaryGradeCode;
    @EdiElt(pos=1, seg="HLH")
    private String healthRelatedCode;
    @EdiElt(pos=2, seg="HLH")
    private BigDecimal height;
    @EdiElt(pos=3, seg="HLH")
    private BigDecimal weight;
    private LanguageInfo languageInfo;

    @Override
    public void populateFromSeg(EdiSeg seg, EdiParsingResults ediParsingResults) {
        EdiEntity ediEntity;
        if (this.seg.isParentOf(seg) && seg.type() == SegmentType.EC) {
            if (this.employmentClassCodes == null) {
                this.employmentClassCodes = new ArrayList<String>();
            }
            List<Elt> elts = seg.eltSet().elts();
            for (Elt elt : elts) {
                if (elt.position() > 3) continue;
                this.employmentClassCodes.add(elt.stringVal());
            }
        } else if (this.seg.isParentOf(seg) && seg.type() == SegmentType.ICM) {
            mapper.populate(this, seg);
            this.workHoursCount = NumbersUtils.removeTrailingZerosUpToDecimal(this.workHoursCount);
        } else if (this.seg.isParentOf(seg) && seg.type() == SegmentType.HLH) {
            mapper.populate(this, seg);
            this.weight = NumbersUtils.removeTrailingZerosUpToDecimal(this.weight);
            this.height = NumbersUtils.removeTrailingZerosUpToDecimal(this.height);
        } else if (this.seg.isParentOf(seg) && seg.type() == SegmentType.DMG) {
            mapper.populate(this, seg);
            Elt ethnicityElt = seg.eltByPosition(5);
            if (ethnicityElt != null && ethnicityElt.eltSet() != null) {
                EltSet ethnicityElts = ethnicityElt.eltSet();
                Elt codeElt = ethnicityElts.eltByPosition(1);
                if (codeElt != null && StringUtils.isNotBlank((CharSequence)codeElt.stringVal())) {
                    this.ethnicityCode = codeElt.stringVal();
                } else {
                    codeElt = ethnicityElts.eltByPosition(3);
                    if (codeElt != null && StringUtils.isNotBlank((CharSequence)codeElt.stringVal())) {
                        this.ethnicityCode = codeElt.stringVal();
                    }
                }
            }
        } else if (this.seg.isParentOf(seg) && (ediEntity = seg.entity()) instanceof LanguageInfo) {
            LanguageInfo langInfo;
            this.languageInfo = langInfo = (LanguageInfo)ediEntity;
        } else {
            super.populateFromSeg(seg, ediParsingResults);
        }
    }

    void prepForCsv() {
        MemberCoverage.prepOrgOrPersonWithAddressAndContacts(this);
        this.employmentClassCodes = CsvUtils.prepList(this.employmentClassCodes, null);
        if (this.languageInfo == null) {
            this.languageInfo = new LanguageInfo();
        }
    }

    @Generated
    public String maritalStatusCode() {
        return this.maritalStatusCode;
    }

    @Generated
    public String ethnicityCode() {
        return this.ethnicityCode;
    }

    @Generated
    public String citizenshipCode() {
        return this.citizenshipCode;
    }

    @Generated
    public List<String> employmentClassCodes() {
        return this.employmentClassCodes;
    }

    @Generated
    public String wageFrequencyCode() {
        return this.wageFrequencyCode;
    }

    @Generated
    public BigDecimal wageAmount() {
        return this.wageAmount;
    }

    @Generated
    public BigDecimal workHoursCount() {
        return this.workHoursCount;
    }

    @Generated
    public String employerLocationIdentificationCode() {
        return this.employerLocationIdentificationCode;
    }

    @Generated
    public String salaryGradeCode() {
        return this.salaryGradeCode;
    }

    @Generated
    public String healthRelatedCode() {
        return this.healthRelatedCode;
    }

    @Generated
    public BigDecimal height() {
        return this.height;
    }

    @Generated
    public BigDecimal weight() {
        return this.weight;
    }

    @Generated
    public LanguageInfo languageInfo() {
        return this.languageInfo;
    }
}

