/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.coverage;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import hdi.edi.edient.BaseEdiEntity;
import hdi.edi.edient.EdiEntity;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiSeg;
import hdi.model.DateTimePeriod;
import hdi.model.enumtype.DateType;
import java.time.LocalDate;
import lombok.Generated;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class Disability
extends BaseEdiEntity {
    @EdiElt(pos=1)
    private String typeCode;
    @EdiElt(pos=8)
    private String diagnosisCode;
    private LocalDate dateFrom;
    private LocalDate dateTo;

    @Override
    protected void populateFromChildSeg(EdiSeg seg, EdiEntity segEnt) {
        if (segEnt instanceof DateTimePeriod) {
            DateTimePeriod dt = (DateTimePeriod)segEnt;
            if (dt.type() == DateType.DISABILITY_FROM) {
                this.dateFrom = dt.date();
            } else if (dt.type() == DateType.DISABILITY_TO) {
                this.dateTo = dt.date();
            }
        }
    }

    @Generated
    public String typeCode() {
        return this.typeCode;
    }

    @Generated
    public String diagnosisCode() {
        return this.diagnosisCode;
    }

    @Generated
    public LocalDate dateFrom() {
        return this.dateFrom;
    }

    @Generated
    public LocalDate dateTo() {
        return this.dateTo;
    }

    @Generated
    public String toString() {
        return "Disability(typeCode=" + this.typeCode() + ", diagnosisCode=" + this.diagnosisCode() + ", dateFrom=" + String.valueOf(this.dateFrom()) + ", dateTo=" + String.valueOf(this.dateTo()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Disability)) {
            return false;
        }
        Disability other = (Disability)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$typeCode = this.typeCode();
        String other$typeCode = other.typeCode();
        if (this$typeCode == null ? other$typeCode != null : !this$typeCode.equals(other$typeCode)) {
            return false;
        }
        String this$diagnosisCode = this.diagnosisCode();
        String other$diagnosisCode = other.diagnosisCode();
        if (this$diagnosisCode == null ? other$diagnosisCode != null : !this$diagnosisCode.equals(other$diagnosisCode)) {
            return false;
        }
        LocalDate this$dateFrom = this.dateFrom();
        LocalDate other$dateFrom = other.dateFrom();
        if (this$dateFrom == null ? other$dateFrom != null : !((Object)this$dateFrom).equals(other$dateFrom)) {
            return false;
        }
        LocalDate this$dateTo = this.dateTo();
        LocalDate other$dateTo = other.dateTo();
        return !(this$dateTo == null ? other$dateTo != null : !((Object)this$dateTo).equals(other$dateTo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Disability;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $typeCode = this.typeCode();
        result = result * 59 + ($typeCode == null ? 43 : $typeCode.hashCode());
        String $diagnosisCode = this.diagnosisCode();
        result = result * 59 + ($diagnosisCode == null ? 43 : $diagnosisCode.hashCode());
        LocalDate $dateFrom = this.dateFrom();
        result = result * 59 + ($dateFrom == null ? 43 : ((Object)$dateFrom).hashCode());
        LocalDate $dateTo = this.dateTo();
        result = result * 59 + ($dateTo == null ? 43 : ((Object)$dateTo).hashCode());
        return result;
    }
}

