/*
 * Decompiled with CFR 0.152.
 */
package hdi.model.coverage;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.BaseEdiEntity;
import hdi.edi.edient.EdiEntity;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiSeg;
import hdi.model.DateTimePeriod;
import hdi.model.Reference;
import hdi.model.coverage.MemberCoverage;
import hdi.model.enumtype.DateType;
import hdi.model.orgperson.OrgOrPerson;
import hdi.model.patientsubscriber.PayerRespSequenceType;
import hdi.util.CollectionUtils;
import java.time.LocalDate;
import java.util.List;
import lombok.Generated;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@EdiObj(loop={"2320"}, seg={"COB"})
public class CoordinationOfBenefits
extends BaseEdiEntity {
    @EdiElt(seg="COB", pos=1)
    private String payerResponsibilitySequenceCode;
    private PayerRespSequenceType payerResponsibilitySequence;
    @EdiElt(seg="COB", pos=2)
    private String groupOrPolicyNumber;
    @EdiElt(seg="COB", pos=3)
    private String coordinationOfBenefitsCode;
    @Prop(objType=ObjType.REFERENCE)
    private List<Reference> additionalIdentifiers;
    @Prop(dateType={DateType.COB_FROM})
    private LocalDate dateFrom;
    @Prop(dateType={DateType.COB_TO})
    private LocalDate dateTo;
    @Prop(objType=ObjType.PARTY)
    private List<OrgOrPerson> insurers;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void populateFromChildSeg(EdiSeg seg, EdiEntity segEnt) {
        if (segEnt instanceof OrgOrPerson) {
            OrgOrPerson party = (OrgOrPerson)segEnt;
            if ("2330".equals(seg.loop())) {
                this.insurers = CollectionUtils.addWithInit(this.insurers, party);
                return;
            }
        }
        if (segEnt instanceof Reference) {
            Reference reference = (Reference)segEnt;
            this.additionalIdentifiers = CollectionUtils.addWithInit(this.additionalIdentifiers, reference);
            return;
        }
        if (!(segEnt instanceof DateTimePeriod)) return;
        DateTimePeriod dt = (DateTimePeriod)segEnt;
        if (dt.type() == DateType.COB_FROM) {
            this.dateFrom = dt.date();
            return;
        }
        if (dt.type() != DateType.COB_TO) return;
        this.dateTo = dt.date();
    }

    @EdiElt(seg="COB", pos=1)
    @EdiElt.Exclude
    public CoordinationOfBenefits payerResponsibilitySequenceCode(String qualifierCode) {
        this.payerResponsibilitySequenceCode = qualifierCode;
        this.payerResponsibilitySequence = PayerRespSequenceType.fromEdi(qualifierCode);
        return this;
    }

    void prepForCsv() {
        this.additionalIdentifiers = CollectionUtils.addWithInit(this.additionalIdentifiers, new Reference());
        this.insurers = CollectionUtils.addWithInit(this.insurers, new OrgOrPerson());
        this.insurers.forEach(MemberCoverage::prepOrgOrPersonWithAddressAndContacts);
    }

    @Generated
    public String payerResponsibilitySequenceCode() {
        return this.payerResponsibilitySequenceCode;
    }

    @Generated
    public PayerRespSequenceType payerResponsibilitySequence() {
        return this.payerResponsibilitySequence;
    }

    @Generated
    public String groupOrPolicyNumber() {
        return this.groupOrPolicyNumber;
    }

    @Generated
    public String coordinationOfBenefitsCode() {
        return this.coordinationOfBenefitsCode;
    }

    @Generated
    public List<Reference> additionalIdentifiers() {
        return this.additionalIdentifiers;
    }

    @Generated
    public LocalDate dateFrom() {
        return this.dateFrom;
    }

    @Generated
    public LocalDate dateTo() {
        return this.dateTo;
    }

    @Generated
    public List<OrgOrPerson> insurers() {
        return this.insurers;
    }

    @Generated
    public String toString() {
        return "CoordinationOfBenefits(payerResponsibilitySequenceCode=" + this.payerResponsibilitySequenceCode() + ", payerResponsibilitySequence=" + String.valueOf(this.payerResponsibilitySequence()) + ", groupOrPolicyNumber=" + this.groupOrPolicyNumber() + ", coordinationOfBenefitsCode=" + this.coordinationOfBenefitsCode() + ", additionalIdentifiers=" + String.valueOf(this.additionalIdentifiers()) + ", dateFrom=" + String.valueOf(this.dateFrom()) + ", dateTo=" + String.valueOf(this.dateTo()) + ", insurers=" + String.valueOf(this.insurers()) + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CoordinationOfBenefits)) {
            return false;
        }
        CoordinationOfBenefits other = (CoordinationOfBenefits)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$payerResponsibilitySequenceCode = this.payerResponsibilitySequenceCode();
        String other$payerResponsibilitySequenceCode = other.payerResponsibilitySequenceCode();
        if (this$payerResponsibilitySequenceCode == null ? other$payerResponsibilitySequenceCode != null : !this$payerResponsibilitySequenceCode.equals(other$payerResponsibilitySequenceCode)) {
            return false;
        }
        PayerRespSequenceType this$payerResponsibilitySequence = this.payerResponsibilitySequence();
        PayerRespSequenceType other$payerResponsibilitySequence = other.payerResponsibilitySequence();
        if (this$payerResponsibilitySequence == null ? other$payerResponsibilitySequence != null : !this$payerResponsibilitySequence.equals(other$payerResponsibilitySequence)) {
            return false;
        }
        String this$groupOrPolicyNumber = this.groupOrPolicyNumber();
        String other$groupOrPolicyNumber = other.groupOrPolicyNumber();
        if (this$groupOrPolicyNumber == null ? other$groupOrPolicyNumber != null : !this$groupOrPolicyNumber.equals(other$groupOrPolicyNumber)) {
            return false;
        }
        String this$coordinationOfBenefitsCode = this.coordinationOfBenefitsCode();
        String other$coordinationOfBenefitsCode = other.coordinationOfBenefitsCode();
        if (this$coordinationOfBenefitsCode == null ? other$coordinationOfBenefitsCode != null : !this$coordinationOfBenefitsCode.equals(other$coordinationOfBenefitsCode)) {
            return false;
        }
        List<Reference> this$additionalIdentifiers = this.additionalIdentifiers();
        List<Reference> other$additionalIdentifiers = other.additionalIdentifiers();
        if (this$additionalIdentifiers == null ? other$additionalIdentifiers != null : !((Object)this$additionalIdentifiers).equals(other$additionalIdentifiers)) {
            return false;
        }
        LocalDate this$dateFrom = this.dateFrom();
        LocalDate other$dateFrom = other.dateFrom();
        if (this$dateFrom == null ? other$dateFrom != null : !((Object)this$dateFrom).equals(other$dateFrom)) {
            return false;
        }
        LocalDate this$dateTo = this.dateTo();
        LocalDate other$dateTo = other.dateTo();
        if (this$dateTo == null ? other$dateTo != null : !((Object)this$dateTo).equals(other$dateTo)) {
            return false;
        }
        List<OrgOrPerson> this$insurers = this.insurers();
        List<OrgOrPerson> other$insurers = other.insurers();
        return !(this$insurers == null ? other$insurers != null : !((Object)this$insurers).equals(other$insurers));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CoordinationOfBenefits;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $payerResponsibilitySequenceCode = this.payerResponsibilitySequenceCode();
        result = result * 59 + ($payerResponsibilitySequenceCode == null ? 43 : $payerResponsibilitySequenceCode.hashCode());
        PayerRespSequenceType $payerResponsibilitySequence = this.payerResponsibilitySequence();
        result = result * 59 + ($payerResponsibilitySequence == null ? 43 : $payerResponsibilitySequence.hashCode());
        String $groupOrPolicyNumber = this.groupOrPolicyNumber();
        result = result * 59 + ($groupOrPolicyNumber == null ? 43 : $groupOrPolicyNumber.hashCode());
        String $coordinationOfBenefitsCode = this.coordinationOfBenefitsCode();
        result = result * 59 + ($coordinationOfBenefitsCode == null ? 43 : $coordinationOfBenefitsCode.hashCode());
        List<Reference> $additionalIdentifiers = this.additionalIdentifiers();
        result = result * 59 + ($additionalIdentifiers == null ? 43 : ((Object)$additionalIdentifiers).hashCode());
        LocalDate $dateFrom = this.dateFrom();
        result = result * 59 + ($dateFrom == null ? 43 : ((Object)$dateFrom).hashCode());
        LocalDate $dateTo = this.dateTo();
        result = result * 59 + ($dateTo == null ? 43 : ((Object)$dateTo).hashCode());
        List<OrgOrPerson> $insurers = this.insurers();
        result = result * 59 + ($insurers == null ? 43 : ((Object)$insurers).hashCode());
        return result;
    }
}

