/*
 * Decompiled with CFR 0.152.
 */
package hdi.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import hdi.edi.EdiTransaction;
import hdi.edi.ediwriter.EdiGen999;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.ParsingIssue;
import hdi.edi.parser.TransactionType;
import hdi.edi.parserhelper.EdiSegJsonConverter;
import hdi.model.IllegalTransactionException;
import hdi.model.RootObj;
import hdi.model.claim.Claim;
import hdi.model.claim.ClaimTransaction;
import hdi.model.coverage.MemberCoverage;
import hdi.model.payment.Payment;
import hdi.model.payment.ProviderAdjustment;
import hdi.model.status.ClaimStatus;
import hdi.model.status.ReceiverProviderClaimStatus;
import hdi.util.CollectionUtils;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RootObjContainer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RootObjContainer.class);
    static final EdiSegJsonConverter jsonConverter = new EdiSegJsonConverter();
    private List<RootObj> rootObjs;
    private List<Claim> claims;
    private List<Payment> payments;
    private List<ProviderAdjustment> providerAdjustments;
    private List<MemberCoverage> coverages;
    private List<ReceiverProviderClaimStatus> statuses;
    private ArrayNode segments;
    private String ackEdi;
    @JsonIgnore
    private int tranCount;
    @JsonIgnore
    private Counts counts = new Counts();
    @JsonIgnore
    private List<EdiTransaction> ediTransactions;
    @JsonIgnore
    private final EdiGen999 ediGen = new EdiGen999();
    private List<ParsingIssue> parsingIssues;

    public static RootObjContainer fromParsingResults(EdiParsingResults ediParsingResults, Boolean asSegments) {
        RootObjContainer parsingResponse = new RootObjContainer();
        if (asSegments != null && asSegments.booleanValue()) {
            parsingResponse.segments = jsonConverter.convert(ediParsingResults.segs());
        } else {
            if (!ediParsingResults.rootObjs().isEmpty()) {
                parsingResponse.rootObjs = ediParsingResults.rootObjs();
            }
            if (!ediParsingResults.claimTransactions().isEmpty()) {
                parsingResponse.claims = ediParsingResults.claimTransactions().stream().map(RootObjContainer::claimTranToClaimForAPI).filter(Objects::nonNull).toList();
            }
            if (!ediParsingResults.payments().isEmpty()) {
                parsingResponse.payments = ediParsingResults.payments();
                parsingResponse.payments.forEach(Payment::prepForApi);
            }
            if (!ediParsingResults.memberCoverages().isEmpty()) {
                parsingResponse.coverages = ediParsingResults.memberCoverages();
            }
            if (!ediParsingResults.providerAdjustments().isEmpty()) {
                parsingResponse.providerAdjustments = ediParsingResults.providerAdjustments();
                parsingResponse.providerAdjustments.forEach(ProviderAdjustment::prepForApi);
            }
            if (!ediParsingResults.statuses().isEmpty()) {
                parsingResponse.statuses = ediParsingResults.statuses();
                for (ReceiverProviderClaimStatus status : parsingResponse.statuses) {
                    if (!(status instanceof ClaimStatus)) continue;
                    ClaimStatus claimStatus = (ClaimStatus)status;
                    claimStatus.prepForApi();
                }
            }
            if (ediParsingResults.curTransaction() == null || !ediParsingResults.curTransaction().transactionType().isObjectModel()) {
                parsingResponse.segments = jsonConverter.convert(ediParsingResults.segs());
            }
        }
        parsingResponse.ediTransactions = ediParsingResults.ediTransactions();
        parsingResponse.tranCount = ediParsingResults.segs().size();
        parsingResponse.counts = parsingResponse.getCounts();
        if (ediParsingResults.parsingIssues() != null && !ediParsingResults.parsingIssues().isEmpty()) {
            parsingResponse.parsingIssues = ediParsingResults.parsingIssues();
        }
        return parsingResponse;
    }

    public void genAckEdi() {
        this.ackEdi = this.ediGen.gen999(this.ediTransactions);
    }

    public void add(RootObjContainer anotherHolder) {
        this.rootObjs = CollectionUtils.addAllWithInit(this.rootObjs, anotherHolder.rootObjs);
        this.payments = CollectionUtils.addAllWithInit(this.payments, anotherHolder.payments);
        this.providerAdjustments = CollectionUtils.addAllWithInit(this.providerAdjustments, anotherHolder.providerAdjustments);
        this.claims = CollectionUtils.addAllWithInit(this.claims, anotherHolder.claims);
        this.coverages = CollectionUtils.addAllWithInit(this.coverages, anotherHolder.coverages);
        this.statuses = CollectionUtils.addAllWithInit(this.statuses, anotherHolder.statuses);
        this.ediTransactions = CollectionUtils.addAllWithInit(this.ediTransactions, anotherHolder.ediTransactions);
        this.parsingIssues = CollectionUtils.addAllWithInit(this.parsingIssues, anotherHolder.parsingIssues);
        if (anotherHolder.segments != null) {
            if (this.segments == null) {
                this.segments = JsonNodeFactory.instance.arrayNode();
            }
            this.segments.addAll(anotherHolder.segments);
        }
        this.counts = this.counts.withCounts(anotherHolder.counts);
    }

    @JsonIgnore
    public boolean isEmpty() {
        return !(this.claims != null && !this.claims.isEmpty() || this.payments != null && !this.payments.isEmpty() || this.coverages != null && !this.coverages.isEmpty() || this.providerAdjustments != null && !this.providerAdjustments.isEmpty() || this.statuses != null && !this.statuses.isEmpty() || this.segments != null && !this.segments.isEmpty() || this.ediTransactions != null && !this.ediTransactions.isEmpty() || this.parsingIssues != null && !this.parsingIssues.isEmpty());
    }

    public void clear() {
        this.claims = null;
        this.payments = null;
        this.providerAdjustments = null;
        this.coverages = null;
        this.statuses = null;
        this.segments = null;
        this.parsingIssues = null;
        this.ediTransactions = null;
        this.rootObjs = null;
        this.tranCount = 0;
    }

    public void clearWithCounts() {
        this.clear();
        this.clearCounts();
    }

    public static Claim claimTranToClaimForAPI(ClaimTransaction claimTransaction) {
        Claim claim = claimTransaction.claim();
        if (claim == null) {
            return null;
        }
        claim.prepForApi();
        return claim;
    }

    @JsonIgnore
    public Counts getCounts() {
        return new Counts(this.tranCount, this.claims != null ? this.claims.size() : 0, this.payments != null ? this.payments.size() : 0, this.coverages != null ? this.coverages.size() : 0, this.statuses != null ? this.statuses.size() : 0, this.providerAdjustments != null ? this.providerAdjustments.size() : 0);
    }

    @JsonIgnore
    public TransactionType getRootEntityTransactionType() {
        if (this.containsClaims() && this.containsPayments()) {
            throw new IllegalTransactionException("The input cannot contain both 837 and 835 transactions", new Object[0]);
        }
        if (this.containsPayments()) {
            return TransactionType.PAYMENT;
        }
        if (this.containsClaims()) {
            return this.claims.get(0).transactionType();
        }
        if (this.coverages != null && !this.coverages.isEmpty()) {
            return TransactionType.MEMBER_COVERAGE;
        }
        throw new IllegalTransactionException("The input must contain only 837, 835 or 834 transactions", new Object[0]);
    }

    private boolean containsClaims() {
        return this.claims != null && !this.claims.isEmpty();
    }

    private boolean containsPayments() {
        return this.payments != null && !this.payments.isEmpty();
    }

    public boolean containsParsingIssues() {
        return this.parsingIssues != null && !this.parsingIssues.isEmpty();
    }

    @JsonIgnore
    public List<?> getOneOfRootEntities() {
        if (this.containsClaims()) {
            return this.claims;
        }
        if (this.containsPayments()) {
            return this.payments;
        }
        if (this.coverages != null && !this.coverages.isEmpty()) {
            return this.coverages;
        }
        throw new IllegalTransactionException("Did not parse any claims, payments, members, or statuses", new Object[0]);
    }

    public void clearCounts() {
        this.counts = new Counts();
    }

    @Generated
    public List<RootObj> rootObjs() {
        return this.rootObjs;
    }

    @Generated
    public List<Claim> claims() {
        return this.claims;
    }

    @Generated
    public List<Payment> payments() {
        return this.payments;
    }

    @Generated
    public List<ProviderAdjustment> providerAdjustments() {
        return this.providerAdjustments;
    }

    @Generated
    public List<MemberCoverage> coverages() {
        return this.coverages;
    }

    @Generated
    public List<ReceiverProviderClaimStatus> statuses() {
        return this.statuses;
    }

    @Generated
    public ArrayNode segments() {
        return this.segments;
    }

    @Generated
    public String ackEdi() {
        return this.ackEdi;
    }

    @JsonIgnore
    @Generated
    public int tranCount() {
        return this.tranCount;
    }

    @JsonIgnore
    @Generated
    public Counts counts() {
        return this.counts;
    }

    @JsonIgnore
    @Generated
    public List<EdiTransaction> ediTransactions() {
        return this.ediTransactions;
    }

    @JsonIgnore
    @Generated
    public EdiGen999 ediGen() {
        return this.ediGen;
    }

    @Generated
    public List<ParsingIssue> parsingIssues() {
        return this.parsingIssues;
    }

    public record Counts(int tranCount, int claimCount, int paymentCount, int coverageCount, int statusCount, int providerAdjustmentCount) {
        public Counts() {
            this(0, 0, 0, 0, 0, 0);
        }

        public Counts withCounts(Counts anotherCountsObj) {
            return new Counts(this.tranCount + anotherCountsObj.tranCount, this.claimCount + anotherCountsObj.claimCount, this.paymentCount + anotherCountsObj.paymentCount, this.coverageCount + anotherCountsObj.coverageCount, this.statusCount + anotherCountsObj.statusCount, this.providerAdjustmentCount + anotherCountsObj.providerAdjustmentCount);
        }
    }
}

