/*
 * Decompiled with CFR 0.152.
 */
package hdi.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.EdiEntity;
import hdi.edi.objmapper.EdiObjectMapper;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.Elt;
import hdi.edi.qualifier.EdiQualifier;
import hdi.model.enumtype.ReferenceType;
import lombok.Generated;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@EdiObj(seg={"REF"})
public class Reference
implements EdiEntity {
    private static final EdiObjectMapper<Reference> mapper = new EdiObjectMapper();
    @EdiElt.Exclude
    @Prop(edi={"REF01"}, desc={"Code qualifying the reference identification"}, isRequired=true)
    private String qualifierCode;
    @EdiElt.Exclude
    @Prop(edi={"REF01"}, desc={"Type of reference; qualifier code as a string constant (enum)"}, codeLookupQuery="type=X12_REFERENCE_IDENTIFICATION_QUALIFIER_CODE")
    private ReferenceType type;
    @EdiElt(pos=2)
    @EdiElt.Exclude
    @Prop(edi={"REF02"}, desc={"Reference identification"}, isRequired=true)
    private String identification;

    public Reference(ReferenceType type, String identification) {
        this.type = type;
        this.identification = identification;
    }

    public Reference(String qualifierCode, String identification) {
        this.qualifierCode = qualifierCode;
        this.identification = identification;
        this.typeFromCode();
    }

    @Override
    public void populateFromSegInitial(EdiSeg seg, EdiParsingResults results) {
        mapper.populate(this, seg);
    }

    @EdiElt(pos=1)
    public void setType(Elt elt) {
        Object object = elt.val();
        if (object instanceof EdiQualifier) {
            EdiQualifier qualifier = (EdiQualifier)object;
            this.qualifierCode = qualifier.ediValue();
        } else {
            this.qualifierCode = elt.valAsStr();
        }
        object = elt.val();
        if (object instanceof ReferenceType) {
            ReferenceType referenceType;
            this.type = referenceType = (ReferenceType)object;
        }
    }

    public void typeFromCode() {
        this.type = ReferenceType.fromEdi(this.qualifierCode);
    }

    @Override
    public String summaryString() {
        return this.identification;
    }

    @JsonIgnore
    public String getLabel(String defaultLabel) {
        Object label = defaultLabel;
        label = this.type != null ? this.type.desc() : (String)label + " (" + this.qualifierCode + ")";
        return label;
    }

    @Generated
    public String qualifierCode() {
        return this.qualifierCode;
    }

    @Generated
    public ReferenceType type() {
        return this.type;
    }

    @Generated
    public String identification() {
        return this.identification;
    }

    @Generated
    public String toString() {
        return "Reference(qualifierCode=" + this.qualifierCode() + ", type=" + String.valueOf(this.type()) + ", identification=" + this.identification() + ")";
    }

    @Generated
    public Reference() {
    }
}

