/*
 * Decompiled with CFR 0.152.
 */
package hdi.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import hdi.codeent.CodeEntity;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.EdiEntity;
import hdi.edi.objmapper.EdiObjectMapper;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.model.Amount;
import hdi.model.DateTimePeriod;
import hdi.model.enumtype.AmountType;
import hdi.model.enumtype.DateType;
import hdi.model.enumtype.ProcType;
import hdi.model.payment.Adjustment;
import hdi.model.payment.GroupedAdjustments;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.data.annotation.Transient;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@EdiObj(seg={"SVD"}, loop={"2430"})
public class LineAdjudication
implements EdiEntity {
    private static final EdiObjectMapper<LineAdjudication> mapper = new EdiObjectMapper();
    @EdiElt(pos=1, seg="SVD")
    private String payerIdentifier;
    @EdiElt(pos=2, seg="SVD")
    private BigDecimal paidAmount;
    @EdiElt(pos=5, seg="SVD")
    private BigDecimal unitCount;
    @EdiElt(pos=6, seg="SVD")
    private Integer bundledOrUnbundledLineNumber;
    @EdiElt.Exclude
    @Prop(edi={"SVD03"}, objType=ObjType.PROCEDURE)
    private CodeEntity procedure;
    @EdiElt.Exclude
    @Prop(desc={"Line adjustments"}, edi={"CAS"}, objType=ObjType.ADJUSTMENT)
    private List<Adjustment> adjustments;
    @EdiElt.Exclude
    @Prop(dateType={DateType.CLAIM_PAID})
    private LocalDate adjudicationOrPaymentDate;
    @EdiElt.Exclude
    @Prop(amtType=AmountType.OWED)
    private BigDecimal remainingPatientLiabilityAmount;
    @EdiElt.Exclude
    @Transient
    @JsonIgnore
    private EdiSeg seg;

    @Override
    public void populateFromSegInitial(EdiSeg seg, EdiParsingResults results) {
        mapper.populate(this, seg);
        this.seg = EdiSeg.cloneKeySegInfo(seg);
    }

    @Override
    public void populateFromSeg(EdiSeg seg, EdiParsingResults ediParsingResults) {
        if (this.seg.isParentOf(seg)) {
            DateTimePeriod date;
            Amount amount;
            EdiEntity segEnt = seg.entity();
            if (segEnt instanceof GroupedAdjustments) {
                GroupedAdjustments groupedAdjs = (GroupedAdjustments)segEnt;
                if (this.adjustments == null) {
                    this.adjustments = new ArrayList<Adjustment>();
                }
                this.adjustments.addAll(groupedAdjs.adjustments());
            } else if (segEnt instanceof Amount && (amount = (Amount)segEnt).type() == AmountType.OWED) {
                this.remainingPatientLiabilityAmount = amount.amount();
            } else if (segEnt instanceof DateTimePeriod && (date = (DateTimePeriod)segEnt).type() == DateType.CLAIM_PAID) {
                this.adjudicationOrPaymentDate = date.date();
            }
        }
    }

    @Override
    public void addCodeEntityForSeg(CodeEntity codeEntity) {
        if (codeEntity.subType() instanceof ProcType) {
            this.procedure = codeEntity;
        }
    }

    @Generated
    public String payerIdentifier() {
        return this.payerIdentifier;
    }

    @Generated
    public BigDecimal paidAmount() {
        return this.paidAmount;
    }

    @Generated
    public BigDecimal unitCount() {
        return this.unitCount;
    }

    @Generated
    public Integer bundledOrUnbundledLineNumber() {
        return this.bundledOrUnbundledLineNumber;
    }

    @Generated
    public CodeEntity procedure() {
        return this.procedure;
    }

    @Generated
    public List<Adjustment> adjustments() {
        return this.adjustments;
    }

    @Generated
    public LocalDate adjudicationOrPaymentDate() {
        return this.adjudicationOrPaymentDate;
    }

    @Generated
    public BigDecimal remainingPatientLiabilityAmount() {
        return this.remainingPatientLiabilityAmount;
    }

    @JsonIgnore
    @Generated
    public EdiSeg seg() {
        return this.seg;
    }

    @Generated
    public String toString() {
        return "LineAdjudication(payerIdentifier=" + this.payerIdentifier() + ", paidAmount=" + String.valueOf(this.paidAmount()) + ", unitCount=" + String.valueOf(this.unitCount()) + ", bundledOrUnbundledLineNumber=" + this.bundledOrUnbundledLineNumber() + ", procedure=" + String.valueOf(this.procedure()) + ", adjustments=" + String.valueOf(this.adjustments()) + ", adjudicationOrPaymentDate=" + String.valueOf(this.adjudicationOrPaymentDate()) + ", remainingPatientLiabilityAmount=" + String.valueOf(this.remainingPatientLiabilityAmount()) + ")";
    }
}

