/*
 * Decompiled with CFR 0.152.
 */
package hdi.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.parser.EdiParserException;
import hdi.edi.parserhelper.ParsedLine;
import hdi.model.ObjectType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import lombok.Generated;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class ErrorInfo {
    @Prop(desc={"Type of error, could be ERROR or WARNING"})
    private ObjectType objectType = ObjectType.ERROR;
    @Prop(desc={"Detailed error message"})
    private String message;
    @Prop(desc={"File name where the error or warning occurred"})
    private String fileName;
    private String errorType;
    private String requestUrl;
    @Schema(description="List of lines with errors")
    private List<ParsedLine> invalidLines;

    public ErrorInfo(Exception e) {
        this(e, null);
    }

    public ErrorInfo(ObjectType objectType, String message) {
        this.objectType = objectType;
        this.message = message;
    }

    public ErrorInfo(Exception e, String requestUrl) {
        this.requestUrl = requestUrl;
        this.message = e.getMessage();
        this.errorType = e.getClass().getSimpleName();
        if (e instanceof EdiParserException) {
            EdiParserException epe = (EdiParserException)e;
            this.invalidLines = epe.invalidLines();
        }
    }

    @Generated
    public ObjectType objectType() {
        return this.objectType;
    }

    @Generated
    public String message() {
        return this.message;
    }

    @Generated
    public String fileName() {
        return this.fileName;
    }

    @Generated
    public String errorType() {
        return this.errorType;
    }

    @Generated
    public String requestUrl() {
        return this.requestUrl;
    }

    @Generated
    public List<ParsedLine> invalidLines() {
        return this.invalidLines;
    }

    @Generated
    public ErrorInfo objectType(ObjectType objectType) {
        this.objectType = objectType;
        return this;
    }

    @Generated
    public ErrorInfo message(String message) {
        this.message = message;
        return this;
    }

    @Generated
    public ErrorInfo fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @Generated
    public ErrorInfo errorType(String errorType) {
        this.errorType = errorType;
        return this;
    }

    @Generated
    public ErrorInfo requestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
        return this;
    }

    @Generated
    public ErrorInfo invalidLines(List<ParsedLine> invalidLines) {
        this.invalidLines = invalidLines;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ErrorInfo)) {
            return false;
        }
        ErrorInfo other = (ErrorInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ObjectType this$objectType = this.objectType();
        ObjectType other$objectType = other.objectType();
        if (this$objectType == null ? other$objectType != null : !((Object)((Object)this$objectType)).equals((Object)other$objectType)) {
            return false;
        }
        String this$message = this.message();
        String other$message = other.message();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$fileName = this.fileName();
        String other$fileName = other.fileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        String this$errorType = this.errorType();
        String other$errorType = other.errorType();
        if (this$errorType == null ? other$errorType != null : !this$errorType.equals(other$errorType)) {
            return false;
        }
        String this$requestUrl = this.requestUrl();
        String other$requestUrl = other.requestUrl();
        if (this$requestUrl == null ? other$requestUrl != null : !this$requestUrl.equals(other$requestUrl)) {
            return false;
        }
        List<ParsedLine> this$invalidLines = this.invalidLines();
        List<ParsedLine> other$invalidLines = other.invalidLines();
        return !(this$invalidLines == null ? other$invalidLines != null : !((Object)this$invalidLines).equals(other$invalidLines));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ErrorInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ObjectType $objectType = this.objectType();
        result = result * 59 + ($objectType == null ? 43 : ((Object)((Object)$objectType)).hashCode());
        String $message = this.message();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $fileName = this.fileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        String $errorType = this.errorType();
        result = result * 59 + ($errorType == null ? 43 : $errorType.hashCode());
        String $requestUrl = this.requestUrl();
        result = result * 59 + ($requestUrl == null ? 43 : $requestUrl.hashCode());
        List<ParsedLine> $invalidLines = this.invalidLines();
        result = result * 59 + ($invalidLines == null ? 43 : ((Object)$invalidLines).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ErrorInfo(objectType=" + String.valueOf((Object)this.objectType()) + ", message=" + this.message() + ", fileName=" + this.fileName() + ", errorType=" + this.errorType() + ", requestUrl=" + this.requestUrl() + ", invalidLines=" + String.valueOf(this.invalidLines()) + ")";
    }
}

