/*
 * Decompiled with CFR 0.152.
 */
package hdi.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.EdiEntity;
import hdi.edi.objmapper.EdiObjectMapper;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.model.enumtype.DateType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import lombok.Generated;

@EdiObj(seg={"DTP"})
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class DateTimePeriod
implements EdiEntity {
    @JsonIgnore
    @EdiElt.Exclude
    static EdiObjectMapper<DateTimePeriod> mapper = new EdiObjectMapper();
    @EdiElt.Exclude
    @Prop(edi={"DTP01"}, desc={"Code specifying type of date or time"})
    private String qualifierCode;
    @EdiElt.Exclude
    @Prop(edi={"DTP01"}, desc={"Type of date; qualifier code translated to a mnemonic string constant (enum)"}, codeLookupQuery="type=X12_DATE_TIME_QUALIFIER_CODE")
    private DateType type;
    @EdiElt(pos=3, seg="DTP")
    @Prop(edi={"DTP03"}, desc={"The date value or the first date of the date range ('RD8' qualifier)"}, relatedFieldName="dateTo")
    private LocalDate date;
    @Prop(edi={"DTP03"}, desc={"The second date if the value is the date range ('RD8' qualifier), otherwise null"})
    @EdiElt(pos=4, seg="DTP")
    private LocalDate dateTo;
    private LocalDateTime dateAndHour;
    private LocalTime time;

    @Override
    public void populateFromSegInitial(EdiSeg seg, EdiParsingResults results) {
        mapper.populate(this, seg);
    }

    @EdiElt(pos=1)
    public void qualifierCode(String code) {
        this.qualifierCode = code;
        this.type = DateType.fromEdi(this.qualifierCode);
    }

    @Override
    public String summaryString() {
        Object s = "";
        if (this.date != null) {
            s = this.date.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.FULL));
        }
        if (this.dateTo != null) {
            s = (String)s + " - " + this.dateTo.format(DateTimeFormatter.ofLocalizedDate(FormatStyle.FULL));
        }
        if (this.dateAndHour != null) {
            s = this.dateAndHour.format(DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL, FormatStyle.MEDIUM));
        }
        if (this.time != null) {
            s = this.time.format(DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM));
        }
        return s;
    }

    @Generated
    public DateTimePeriod() {
    }

    @Generated
    public String qualifierCode() {
        return this.qualifierCode;
    }

    @Generated
    public DateType type() {
        return this.type;
    }

    @Generated
    public LocalDate date() {
        return this.date;
    }

    @Generated
    public LocalDate dateTo() {
        return this.dateTo;
    }

    @Generated
    public LocalDateTime dateAndHour() {
        return this.dateAndHour;
    }

    @Generated
    public LocalTime time() {
        return this.time;
    }

    @Generated
    public DateTimePeriod type(DateType type) {
        this.type = type;
        return this;
    }

    @Generated
    public DateTimePeriod date(LocalDate date) {
        this.date = date;
        return this;
    }

    @Generated
    public DateTimePeriod dateTo(LocalDate dateTo) {
        this.dateTo = dateTo;
        return this;
    }

    @Generated
    public DateTimePeriod dateAndHour(LocalDateTime dateAndHour) {
        this.dateAndHour = dateAndHour;
        return this;
    }

    @Generated
    public DateTimePeriod time(LocalTime time) {
        this.time = time;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DateTimePeriod)) {
            return false;
        }
        DateTimePeriod other = (DateTimePeriod)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$qualifierCode = this.qualifierCode();
        String other$qualifierCode = other.qualifierCode();
        if (this$qualifierCode == null ? other$qualifierCode != null : !this$qualifierCode.equals(other$qualifierCode)) {
            return false;
        }
        DateType this$type = this.type();
        DateType other$type = other.type();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        LocalDate this$date = this.date();
        LocalDate other$date = other.date();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        LocalDate this$dateTo = this.dateTo();
        LocalDate other$dateTo = other.dateTo();
        if (this$dateTo == null ? other$dateTo != null : !((Object)this$dateTo).equals(other$dateTo)) {
            return false;
        }
        LocalDateTime this$dateAndHour = this.dateAndHour();
        LocalDateTime other$dateAndHour = other.dateAndHour();
        if (this$dateAndHour == null ? other$dateAndHour != null : !((Object)this$dateAndHour).equals(other$dateAndHour)) {
            return false;
        }
        LocalTime this$time = this.time();
        LocalTime other$time = other.time();
        return !(this$time == null ? other$time != null : !((Object)this$time).equals(other$time));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DateTimePeriod;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $qualifierCode = this.qualifierCode();
        result = result * 59 + ($qualifierCode == null ? 43 : $qualifierCode.hashCode());
        DateType $type = this.type();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        LocalDate $date = this.date();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        LocalDate $dateTo = this.dateTo();
        result = result * 59 + ($dateTo == null ? 43 : ((Object)$dateTo).hashCode());
        LocalDateTime $dateAndHour = this.dateAndHour();
        result = result * 59 + ($dateAndHour == null ? 43 : ((Object)$dateAndHour).hashCode());
        LocalTime $time = this.time();
        result = result * 59 + ($time == null ? 43 : ((Object)$time).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DateTimePeriod(qualifierCode=" + this.qualifierCode() + ", type=" + String.valueOf(this.type()) + ", date=" + String.valueOf(this.date()) + ", dateTo=" + String.valueOf(this.dateTo()) + ", dateAndHour=" + String.valueOf(this.dateAndHour()) + ", time=" + String.valueOf(this.time()) + ")";
    }
}

