/*
 * Decompiled with CFR 0.152.
 */
package hdi.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import hdi.codeedit.Issue;
import hdi.codeedit.QualityScore;
import hdi.codeent.CodeEntity;
import hdi.codeent.NormalizedCodeEntity;
import hdi.edi.EdiTransaction;
import hdi.edi.csv.PaymentCsv;
import hdi.edi.dict.annotations.ObjType;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.EdiEntity;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.TransactionType;
import hdi.model.ObjectType;
import hdi.model.PlaceOfServiceType;
import hdi.model.RootObj;
import hdi.model.ServiceLine;
import hdi.model.enumtype.AmountType;
import hdi.model.enumtype.CarcRarcType;
import hdi.model.enumtype.DateType;
import hdi.model.enumtype.UbCodeType;
import hdi.model.patientsubscriber.PatientSubscriber;
import hdi.model.payment.Adjustment;
import hdi.model.payment.Payment;
import hdi.util.DateRange;
import hdi.util.DateUtils;
import hdi.util.FormattingUtils;
import hdi.util.SearchWordsUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.annotation.Transient;

public abstract class ClaimOrPayment
implements EdiEntity,
RootObj {
    @EdiElt.Exclude
    @Prop(masterClass=PaymentCsv.class)
    protected String id;
    @EdiElt.Exclude
    @Prop(desc={"837:Type of this object, set to 'CLAIM'", "835:Type of this object, set to 'PAYMENT'"})
    protected ObjectType objectType;
    @EdiElt(value={"patient_account_number", "patient_control_number"})
    @Prop(edi={"835:CLP01", "837:CLM01"}, desc={"Identifier used to track a claim from creation by the health care provider through payment"}, isRequired=true)
    protected String patientControlNumber;
    @Prop(edi={"835:CLP02", "837:CLM02"}, isRequired=true)
    protected BigDecimal chargeAmount;
    @Prop(edi={"CLP04"}, tran={TransactionType.PAYMENT}, isRequired=true)
    protected BigDecimal paymentAmount;
    @EdiElt.Exclude
    @JsonIgnore
    private String transactionId;
    @EdiElt(value={"patient_amount_paid"})
    @Prop(tran={TransactionType.PROF, TransactionType.DENTAL}, amtType=AmountType.PATIENT_PAID)
    protected BigDecimal patientPaidAmount;
    @Transient
    @EdiElt.Exclude
    @JsonIgnore
    private List<EdiSeg> ediSegs = new ArrayList<EdiSeg>();
    @EdiElt.Exclude
    @JsonIgnore
    protected List<NormalizedCodeEntity> codeEnts = new ArrayList<NormalizedCodeEntity>();
    @EdiElt.Exclude
    @Prop(edi={"835:CLP08", "837:CLM05-1"}, objType=ObjType.FACILITY, desc={"Place of service code (professional/dental) or UB facility code (institutional) from the original claim"}, ignoreForEdiGen=true, required={"835:N", "837:Y"})
    protected CodeEntity facilityCode;
    @EdiElt.Exclude
    protected PlaceOfServiceType placeOfServiceType;
    @EdiElt.Exclude
    @Prop(edi={"835:CLP09", "837:CLM05-3"}, objType=ObjType.CODE, codeLookupQuery="type=frequency_code", ignoreForEdiGen=true, required={"835:N", "837:Y"})
    protected CodeEntity frequencyCode;
    @JsonIgnore
    @EdiElt.Exclude
    private boolean isOriginalClaim = true;
    @EdiElt(value={"claim_statement_period_start", "statement_from_and_to_date"})
    @Prop(tran={TransactionType.INST, TransactionType.PAYMENT}, relatedFieldName="837:statementDateTo", dateType={DateType.STATEMENT, DateType.STATEMENT_PERIOD_START})
    private LocalDate statementDateFrom;
    @EdiElt(value={"claim_statement_period_end", "statement_from_and_to_date_to"})
    @Prop(tran={TransactionType.INST, TransactionType.PAYMENT}, dateType={DateType.STATEMENT, DateType.STATEMENT_PERIOD_END})
    private LocalDate statementDateTo;
    @JsonIgnore
    protected LocalDate dateFrom;
    @JsonIgnore
    protected LocalDate dateTo;
    @JsonIgnore
    private String yearMonthPeriod;
    @JsonIgnore
    private String yearPeriod;
    @EdiElt.Exclude
    @Prop(isDerived=true, desc={"The earliest service date from service lines"})
    protected LocalDate serviceDateFrom;
    @EdiElt.Exclude
    @Prop(isDerived=true, desc={"The latest service date from service lines"})
    protected LocalDate serviceDateTo;
    @EdiElt.Exclude
    @Prop(objType=ObjType.SUBSCRIBER, loop={"835:2100", "837:2000B"}, desc={"835:The insured (subscriber) from the original claim if the insured is different from the patient", "837:The insured (subscriber)"})
    protected PatientSubscriber subscriber;
    @EdiElt.Exclude
    @Prop(objType=ObjType.PATIENT, loop={"835:2100", "837:2110CA"}, desc={"835:The insured (subscriber) or patient from the original claim", "837:Patient if different from the the insured (subscriber)"})
    protected PatientSubscriber patient;
    @EdiElt.Exclude
    @Prop(objType=ObjType.OTHER_SUBSCRIBER, loop={"835:2100", "837:2320"}, desc={"835:Other subscriber; only one other subscriber is allowed on 835", "837:Other subscribers and their payer's information"})
    protected List<PatientSubscriber> otherSubscribers;
    @JsonProperty(value="serviceLines")
    @Prop(name="serviceLines", loop={"835:2110", "837:2400"}, desc={"Service lines"}, objType=ObjType.LINE)
    protected List<ServiceLine> lines = new ArrayList<ServiceLine>();
    @EdiElt.Exclude
    @JsonProperty(value="transaction")
    @Prop(objType=ObjType.TRANSACTION, desc={"Parent EDI transaction for this object"})
    protected EdiTransaction transaction;
    @JsonIgnore
    private List<Issue> issues;
    @JsonIgnore
    private QualityScore qualityScore;
    @LastModifiedDate
    private LocalDateTime updateTimestamp;
    @CreatedDate
    private LocalDateTime createTimestamp;

    public BigDecimal chargeAmount() {
        return this.chargeAmount != null ? this.chargeAmount : BigDecimal.ZERO;
    }

    public List<Issue> issues() {
        return this.issues == null ? List.of() : this.issues;
    }

    @Override
    public abstract void populateFromSegInitial(EdiSeg var1, EdiParsingResults var2);

    @Override
    public void addCodeEntityForSeg(CodeEntity codeEntity) {
        if (codeEntity.subType() == UbCodeType.FREQUENCY_CODE) {
            this.frequencyCode = codeEntity;
            this.isOriginalClaim = this.frequencyCode.code().equals("1");
        } else if (codeEntity.subType().equals(UbCodeType.FACILITY_TYPE)) {
            this.addFacilityCodeOrPoS(codeEntity);
        }
    }

    private void addFacilityCodeOrPoS(CodeEntity codeEntity) {
        codeEntity.code(PlaceOfServiceType.cleanupCode(codeEntity.code()));
        this.facilityCode = codeEntity;
        this.placeOfServiceType = PlaceOfServiceType.fromCode(this.transaction.transactionType(), codeEntity.code());
        codeEntity.subType(UbCodeType.PLACE_OF_SERVICE);
        if (this.isInstClaimOrPayment()) {
            codeEntity.subType(UbCodeType.FACILITY_TYPE);
            this.placeOfServiceType = PlaceOfServiceType.fromCode(TransactionType.INST, codeEntity.code());
        }
    }

    @JsonIgnore
    public String getPlaceOfServiceCodeDesc() {
        String code = this.placeOfServiceType().profCodes();
        if (this.facilityCode != null) {
            code = this.facilityCode.code();
        }
        return FormattingUtils.formatCodeDesc(code, this.placeOfServiceType.description());
    }

    @JsonIgnore
    public boolean isInstClaimOrPayment() {
        return this.transaction.transactionType() == TransactionType.INST || this.isInstPayment();
    }

    @JsonIgnore
    private boolean isInstPayment() {
        ClaimOrPayment claimOrPayment = this;
        if (claimOrPayment instanceof Payment) {
            Payment payment = (Payment)claimOrPayment;
            for (ServiceLine line : payment.lines()) {
                if (line.revenueCode() == null) continue;
                return true;
            }
            return payment.drg() != null;
        }
        return false;
    }

    public List<ServiceLine> lines() {
        return Collections.unmodifiableList(this.lines);
    }

    @JsonIgnore
    public PatientSubscriber getPatientOrSubscriber() {
        return this.patient != null ? this.patient : this.subscriber;
    }

    protected void prepNormalizedCodeEnts(Collection<CodeEntity> allCodeEntities) {
        HashMap<String, NormalizedCodeEntity> normCodeEntByCode = new HashMap<String, NormalizedCodeEntity>();
        this.normalizeCodeEnts(normCodeEntByCode, allCodeEntities);
        ArrayList<CodeEntity> categories = new ArrayList<CodeEntity>();
        for (CodeEntity codeEnt : allCodeEntities) {
            if (codeEnt.categories() == null) continue;
            categories.addAll(codeEnt.categories());
        }
        this.normalizeCodeEnts(normCodeEntByCode, categories);
    }

    private void normalizeCodeEnts(Map<String, NormalizedCodeEntity> normCodeEntByCode, Collection<CodeEntity> codeEntities) {
        for (CodeEntity codeEnt : codeEntities) {
            String key = codeEnt.codeAndType();
            NormalizedCodeEntity normalizedCodeEntity = normCodeEntByCode.get(key);
            if (normalizedCodeEntity != null) {
                normalizedCodeEntity.merge(codeEnt);
                continue;
            }
            normalizedCodeEntity = new NormalizedCodeEntity(codeEnt);
            normCodeEntByCode.put(key, normalizedCodeEntity);
            this.codeEnts.add(normalizedCodeEntity);
            this.updateNormalizedCodeEntsMetrics(normalizedCodeEntity, codeEnt);
        }
    }

    private void updateNormalizedCodeEntsMetrics(NormalizedCodeEntity normalizedCodeEntity, CodeEntity codeEntity) {
        int lineCounter = 0;
        BigDecimal chargeAmount = BigDecimal.ZERO;
        BigDecimal paidAmount = BigDecimal.ZERO;
        BigDecimal adjustmentAmount = BigDecimal.ZERO;
        List<ServiceLine> lines = this.lines();
        for (ServiceLine line : lines) {
            if (!line.containsCodeEntity(codeEntity)) continue;
            ++lineCounter;
            if (line.chargeAmount() != null) {
                chargeAmount = chargeAmount.add(line.chargeAmount());
            }
            if (line.paidAmount() != null) {
                paidAmount = paidAmount.add(line.paidAmount());
            }
            if (codeEntity.subType() == CarcRarcType.CARC) {
                adjustmentAmount = adjustmentAmount.add(Adjustment.sumAdjustments(line.adjustments(), codeEntity.code()));
                continue;
            }
            adjustmentAmount = adjustmentAmount.add(line.getTotalAdjustmentAmount());
        }
        if (lineCounter > 0) {
            normalizedCodeEntity.lineCount(lineCounter);
            normalizedCodeEntity.chargeAmount(chargeAmount);
            normalizedCodeEntity.paymentAmount(paidAmount);
        } else {
            normalizedCodeEntity.lineCount(lines.size());
            normalizedCodeEntity.chargeAmount(this.chargeAmount);
            normalizedCodeEntity.paymentAmount(this.paymentAmount);
            normalizedCodeEntity.adjustmentAmount(this.paymentAmount);
        }
        if (codeEntity.subType() == CarcRarcType.CARC) {
            adjustmentAmount = adjustmentAmount.add(Adjustment.sumAdjustments(this.adjustments(), codeEntity.code()));
            normalizedCodeEntity.adjustmentAmount(adjustmentAmount);
        } else if (lineCounter > 0) {
            normalizedCodeEntity.adjustmentAmount(adjustmentAmount);
        } else {
            normalizedCodeEntity.adjustmentAmount(this.getTotalClaimAdjustmentAmount());
        }
    }

    protected void populateServiceDatesRange() {
        if (this.serviceDateFrom == null) {
            DateRange range = this.calcWidestServiceDateRange();
            this.serviceDateFrom = range.from();
            this.serviceDateTo = range.to();
        }
    }

    private DateRange calcWidestDateRange() {
        DateRange range = this.calcWidestServiceDateRange();
        LocalDate earliest = DateUtils.earliest(range.from(), this.statementDateFrom);
        LocalDate latest = DateUtils.latest(range.to(), this.statementDateTo);
        if (latest == null) {
            latest = earliest;
        }
        return new DateRange(earliest, latest);
    }

    protected void populateEarliestAndLatestDates() {
        this.populateServiceDatesRange();
        this.dateFrom = DateUtils.earliest(this.serviceDateFrom, this.statementDateFrom);
        this.dateTo = DateUtils.latest(this.serviceDateTo, this.statementDateTo);
        if (this.dateTo == null) {
            this.dateTo = this.dateFrom;
        }
    }

    protected void preparePeriods() {
        LocalDate dt = this.dateFrom();
        if (dt != null) {
            this.yearPeriod = Integer.toString(dt.getYear());
            int month = dt.getMonth().getValue();
            String monthStr = StringUtils.leftPad((String)Integer.toString(month), (int)2, (char)'0');
            this.yearMonthPeriod = this.yearPeriod + "-" + monthStr;
        }
    }

    protected Set<String> prepSearchWords() {
        HashSet<String> tokens = new HashSet<String>();
        if (this.placeOfServiceType != null) {
            tokens.add(this.placeOfServiceType.description());
        }
        if (this.transaction.transactionType() != null) {
            tokens.add(this.transaction.transactionType().description());
        }
        tokens.add(this.patientControlNumber);
        if (this.yearMonthPeriod() != null) {
            tokens.add(this.yearMonthPeriod());
        }
        if (this.serviceDateFrom != null) {
            tokens.add(this.serviceDateFrom.toString());
        }
        tokens.addAll(this.transaction.fileInfo().searchWords());
        if (this.codeEnts != null && !this.codeEnts.isEmpty()) {
            for (NormalizedCodeEntity codeEnt : this.codeEnts) {
                tokens.addAll(codeEnt.searchWords());
            }
        }
        if (this.patient != null) {
            this.patient.prepForPersistence();
            tokens.addAll(this.patient.person().searchWords());
        }
        this.prepSubscriberSearchWords(tokens, this.subscriber);
        if (this.otherSubscribers != null) {
            this.otherSubscribers.forEach(subscriber -> this.prepSubscriberSearchWords((Set<String>)tokens, (PatientSubscriber)subscriber));
        }
        return SearchWordsUtils.tokenizeTextFields(tokens);
    }

    private void prepSubscriberSearchWords(Set<String> tokens, PatientSubscriber subscriber) {
        if (subscriber != null) {
            SearchWordsUtils.prepPersonSearchWords(tokens, subscriber.person());
            SearchWordsUtils.prepPersonSearchWords(tokens, subscriber.payer());
        }
    }

    public DateRange calcWidestServiceDateRange() {
        LocalDate minDate = null;
        LocalDate maxDate = null;
        for (ServiceLine line : this.lines) {
            minDate = DateUtils.earliest(minDate, line.serviceDateFrom());
            if (maxDate != null && (line.serviceDateTo() == null || !line.serviceDateTo().isAfter(maxDate))) continue;
            maxDate = line.serviceDateTo();
        }
        return new DateRange(minDate, maxDate);
    }

    public boolean containsCode(Function<ServiceLine, ?> getter) {
        for (ServiceLine l : this.lines) {
            if (getter.apply(l) == null) continue;
            return true;
        }
        return false;
    }

    public void addLine(ServiceLine line) {
        line.index(this.lines.size());
        this.lines.add(line);
    }

    public void prepForPersistence() {
        this.generateId();
        this.createTimestamp = LocalDateTime.now();
        this.preparePeriods();
    }

    protected void generateId() {
        this.id = ObjectId.get().toHexString();
    }

    public void prepDerived() {
        this.populateEarliestAndLatestDates();
    }

    public abstract void prepForApi();

    protected void prepLineDiagsForApi() {
        for (ServiceLine l : this.lines) {
            if (l.diags() == null) continue;
            l.diags().forEach(CodeEntity::trimNiceToHave);
        }
    }

    @JsonIgnore
    public BigDecimal getTotalClaimAdjustmentAmount() {
        return null;
    }

    @JsonIgnore
    public List<Adjustment> adjustments() {
        return null;
    }

    @Generated
    public String toString() {
        return "ClaimOrPayment(patientControlNumber=" + this.patientControlNumber() + ", chargeAmount=" + String.valueOf(this.chargeAmount()) + ", paymentAmount=" + String.valueOf(this.paymentAmount()) + ", patientPaidAmount=" + String.valueOf(this.patientPaidAmount()) + ", facilityCode=" + String.valueOf(this.facilityCode()) + ", placeOfServiceType=" + String.valueOf((Object)this.placeOfServiceType()) + ", frequencyCode=" + String.valueOf(this.frequencyCode()) + ", isOriginalClaim=" + this.isOriginalClaim() + ", statementDateFrom=" + String.valueOf(this.statementDateFrom()) + ", statementDateTo=" + String.valueOf(this.statementDateTo()) + ", dateFrom=" + String.valueOf(this.dateFrom()) + ", dateTo=" + String.valueOf(this.dateTo()) + ", yearMonthPeriod=" + this.yearMonthPeriod() + ", yearPeriod=" + this.yearPeriod() + ", serviceDateFrom=" + String.valueOf(this.serviceDateFrom()) + ", serviceDateTo=" + String.valueOf(this.serviceDateTo()) + ", subscriber=" + String.valueOf(this.subscriber()) + ", patient=" + String.valueOf(this.patient()) + ", otherSubscribers=" + String.valueOf(this.otherSubscribers()) + ", issues=" + String.valueOf(this.issues()) + ", qualityScore=" + String.valueOf(this.qualityScore()) + ", updateTimestamp=" + String.valueOf(this.updateTimestamp()) + ", createTimestamp=" + String.valueOf(this.createTimestamp()) + ")";
    }

    @Override
    @Generated
    public String id() {
        return this.id;
    }

    @Override
    @Generated
    public ObjectType objectType() {
        return this.objectType;
    }

    @Generated
    public String patientControlNumber() {
        return this.patientControlNumber;
    }

    @Generated
    public BigDecimal paymentAmount() {
        return this.paymentAmount;
    }

    @Generated
    public BigDecimal patientPaidAmount() {
        return this.patientPaidAmount;
    }

    @JsonIgnore
    @Generated
    public List<EdiSeg> ediSegs() {
        return this.ediSegs;
    }

    @JsonIgnore
    @Generated
    public List<NormalizedCodeEntity> codeEnts() {
        return this.codeEnts;
    }

    @Generated
    public CodeEntity facilityCode() {
        return this.facilityCode;
    }

    @Generated
    public PlaceOfServiceType placeOfServiceType() {
        return this.placeOfServiceType;
    }

    @Generated
    public CodeEntity frequencyCode() {
        return this.frequencyCode;
    }

    @JsonIgnore
    @Generated
    public boolean isOriginalClaim() {
        return this.isOriginalClaim;
    }

    @Generated
    public LocalDate statementDateFrom() {
        return this.statementDateFrom;
    }

    @Generated
    public LocalDate statementDateTo() {
        return this.statementDateTo;
    }

    @JsonIgnore
    @Generated
    public LocalDate dateFrom() {
        return this.dateFrom;
    }

    @JsonIgnore
    @Generated
    public LocalDate dateTo() {
        return this.dateTo;
    }

    @JsonIgnore
    @Generated
    public String yearMonthPeriod() {
        return this.yearMonthPeriod;
    }

    @JsonIgnore
    @Generated
    public String yearPeriod() {
        return this.yearPeriod;
    }

    @Generated
    public LocalDate serviceDateFrom() {
        return this.serviceDateFrom;
    }

    @Generated
    public LocalDate serviceDateTo() {
        return this.serviceDateTo;
    }

    @Generated
    public PatientSubscriber subscriber() {
        return this.subscriber;
    }

    @Generated
    public PatientSubscriber patient() {
        return this.patient;
    }

    @Generated
    public List<PatientSubscriber> otherSubscribers() {
        return this.otherSubscribers;
    }

    @JsonIgnore
    @Generated
    public QualityScore qualityScore() {
        return this.qualityScore;
    }

    @Generated
    public LocalDateTime updateTimestamp() {
        return this.updateTimestamp;
    }

    @Generated
    public LocalDateTime createTimestamp() {
        return this.createTimestamp;
    }

    @Generated
    public ClaimOrPayment objectType(ObjectType objectType) {
        this.objectType = objectType;
        return this;
    }

    @Generated
    public ClaimOrPayment patientControlNumber(String patientControlNumber) {
        this.patientControlNumber = patientControlNumber;
        return this;
    }

    @Generated
    public ClaimOrPayment chargeAmount(BigDecimal chargeAmount) {
        this.chargeAmount = chargeAmount;
        return this;
    }

    @Generated
    public ClaimOrPayment paymentAmount(BigDecimal paymentAmount) {
        this.paymentAmount = paymentAmount;
        return this;
    }

    @Generated
    public ClaimOrPayment patientPaidAmount(BigDecimal patientPaidAmount) {
        this.patientPaidAmount = patientPaidAmount;
        return this;
    }

    @JsonIgnore
    @Generated
    public ClaimOrPayment codeEnts(List<NormalizedCodeEntity> codeEnts) {
        this.codeEnts = codeEnts;
        return this;
    }

    @Generated
    public ClaimOrPayment facilityCode(CodeEntity facilityCode) {
        this.facilityCode = facilityCode;
        return this;
    }

    @Generated
    public ClaimOrPayment placeOfServiceType(PlaceOfServiceType placeOfServiceType) {
        this.placeOfServiceType = placeOfServiceType;
        return this;
    }

    @Generated
    public ClaimOrPayment frequencyCode(CodeEntity frequencyCode) {
        this.frequencyCode = frequencyCode;
        return this;
    }

    @Generated
    public ClaimOrPayment statementDateFrom(LocalDate statementDateFrom) {
        this.statementDateFrom = statementDateFrom;
        return this;
    }

    @Generated
    public ClaimOrPayment statementDateTo(LocalDate statementDateTo) {
        this.statementDateTo = statementDateTo;
        return this;
    }

    @JsonIgnore
    @Generated
    public ClaimOrPayment dateFrom(LocalDate dateFrom) {
        this.dateFrom = dateFrom;
        return this;
    }

    @JsonIgnore
    @Generated
    public ClaimOrPayment dateTo(LocalDate dateTo) {
        this.dateTo = dateTo;
        return this;
    }

    @JsonIgnore
    @Generated
    public ClaimOrPayment yearMonthPeriod(String yearMonthPeriod) {
        this.yearMonthPeriod = yearMonthPeriod;
        return this;
    }

    @JsonIgnore
    @Generated
    public ClaimOrPayment yearPeriod(String yearPeriod) {
        this.yearPeriod = yearPeriod;
        return this;
    }

    @Generated
    public ClaimOrPayment serviceDateFrom(LocalDate serviceDateFrom) {
        this.serviceDateFrom = serviceDateFrom;
        return this;
    }

    @Generated
    public ClaimOrPayment serviceDateTo(LocalDate serviceDateTo) {
        this.serviceDateTo = serviceDateTo;
        return this;
    }

    @Generated
    public ClaimOrPayment patient(PatientSubscriber patient) {
        this.patient = patient;
        return this;
    }

    @Generated
    public ClaimOrPayment otherSubscribers(List<PatientSubscriber> otherSubscribers) {
        this.otherSubscribers = otherSubscribers;
        return this;
    }

    @JsonIgnore
    @Generated
    public ClaimOrPayment issues(List<Issue> issues) {
        this.issues = issues;
        return this;
    }

    @JsonIgnore
    @Generated
    public ClaimOrPayment qualityScore(QualityScore qualityScore) {
        this.qualityScore = qualityScore;
        return this;
    }

    @Generated
    public ClaimOrPayment updateTimestamp(LocalDateTime updateTimestamp) {
        this.updateTimestamp = updateTimestamp;
        return this;
    }

    @Generated
    public ClaimOrPayment createTimestamp(LocalDateTime createTimestamp) {
        this.createTimestamp = createTimestamp;
        return this;
    }

    @Generated
    public ClaimOrPayment id(String id) {
        this.id = id;
        return this;
    }

    @JsonIgnore
    @Generated
    public String transactionId() {
        return this.transactionId;
    }

    @JsonIgnore
    @Generated
    public ClaimOrPayment transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @JsonIgnore
    @Generated
    public ClaimOrPayment ediSegs(List<EdiSeg> ediSegs) {
        this.ediSegs = ediSegs;
        return this;
    }

    @Generated
    public ClaimOrPayment subscriber(PatientSubscriber subscriber) {
        this.subscriber = subscriber;
        return this;
    }

    @Override
    @JsonProperty(value="transaction")
    @Generated
    public EdiTransaction transaction() {
        return this.transaction;
    }

    @JsonProperty(value="transaction")
    @Generated
    public ClaimOrPayment transaction(EdiTransaction transaction) {
        this.transaction = transaction;
        return this;
    }
}

