/*
 * Decompiled with CFR 0.152.
 */
package hdi.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import hdi.edi.dict.annotations.EdiObj;
import hdi.edi.dict.annotations.Prop;
import hdi.edi.edient.EdiEntity;
import hdi.edi.objmapper.EdiObjectMapper;
import hdi.edi.objmapper.annotations.EdiElt;
import hdi.edi.parser.EdiParsingResults;
import hdi.edi.parser.EdiSeg;
import hdi.model.enumtype.AmountType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import lombok.Generated;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@EdiObj(seg={"AMT"})
public class Amount
implements EdiEntity {
    private static final EdiObjectMapper<Amount> mapper = new EdiObjectMapper();
    @EdiElt.Exclude
    @Prop(edi={"AMT01"}, desc={"Code specifying the type of amount (amount qualifier code)"}, isRequired=true)
    private String qualifierCode;
    @EdiElt.Exclude
    @Prop(edi={"AMT01"}, desc={"Type of amount; qualifier code translated to a mnemonic string constant (enum)"}, codeLookupQuery="type=X12_AMOUNT_QUALIFIER_CODE")
    private AmountType type;
    @EdiElt(pos=2)
    @Prop(edi={"AMT02"}, isRequired=true)
    private BigDecimal amount;

    @Override
    public void populateFromSegInitial(EdiSeg seg, EdiParsingResults results) {
        mapper.populate(this, seg);
    }

    @EdiElt(pos=1)
    public void qualifierCode(String code) {
        this.qualifierCode = code;
        this.type = AmountType.fromEdi(code);
    }

    @Override
    public String summaryString() {
        String s = "";
        if (this.amount != null) {
            BigDecimal a = this.amount.setScale(2, RoundingMode.HALF_EVEN);
            s = a.toString();
        }
        return s;
    }

    public static BigDecimal findAmountByType(List<Amount> amounts, AmountType type) {
        if (amounts != null) {
            for (Amount amount : amounts) {
                if (amount.type() != type) continue;
                return amount.amount;
            }
        }
        return null;
    }

    @Generated
    public String qualifierCode() {
        return this.qualifierCode;
    }

    @Generated
    public AmountType type() {
        return this.type;
    }

    @Generated
    public BigDecimal amount() {
        return this.amount;
    }

    @Generated
    public String toString() {
        return "Amount(qualifierCode=" + this.qualifierCode() + ", type=" + String.valueOf(this.type()) + ", amount=" + String.valueOf(this.amount()) + ")";
    }
}

