/*
 * Decompiled with CFR 0.152.
 */
package hdi.license;

import hdi.license.Entitlement;
import hdi.license.LicenseException;
import hdi.license.LicenseFeature;
import hdi.license.LicenseInfo;
import hdi.util.FilesUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Base64;
import java.util.List;
import java.util.Locale;
import javax0.license3j.Feature;
import javax0.license3j.License;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LicenseReader.class);
    public static final String LICENSE_FILE_ENV_NAME = "EDI_LICENSE";
    public static final String LICENSE_FILE_ALIAS_ENV_NAME = "EDI_LICENSE_FILE";
    public static final String LICENSE_KEY_ENV_NAME = "EDI_LICENSE_KEY";
    public static final String LICENSE_FILE_PROP = "edi-license-file";
    public static final String LICENSE_KEY_PROP = "edi-license-key";
    public static final String ETC_DIR = "etc";
    public static final String DEFAULT_LICENSE_FILE_NAME = "edi-license.txt";
    public static final String REQUEST_LICENSE_MSG = "Request your license at https://datainsight.health/products/license-request";
    public static final String REQUEST_LICENSE_MSG_HTML = "<a href='https://datainsight.health/products/license-request'>Request your license key</a>";
    private static final byte[] LICENSE_SIB_PUB_KEY = new byte[]{82, 83, 65, 0, 48, -127, -97, 48, 13, 6, 9, 42, -122, 72, -122, -9, 13, 1, 1, 1, 5, 0, 3, -127, -115, 0, 48, -127, -119, 2, -127, -127, 0, -76, -100, -107, -32, -116, 47, 12, -40, -82, 0, 86, 37, 52, 53, -84, -65, 110, -115, 3, -82, -105, 70, 47, 81, -78, 26, -46, 24, -18, 100, 57, -15, -121, -108, -21, 106, -69, -59, 38, 27, 125, -24, 109, 68, 95, -87, 116, -81, 104, -119, 31, -17, 33, 97, -94, -88, 60, 18, 67, -63, -44, 109, -97, 4, 75, 14, 24, -53, -76, 73, -32, 86, -88, 99, -108, -78, 60, -112, 59, -20, -78, -35, 75, 114, 41, -66, 60, 11, -80, 36, -83, -128, 19, 21, 18, 12, -87, -10, -78, -117, 112, -2, -58, -20, -65, -128, 58, -88, -22, -70, 24, -65, -118, -91, -128, 25, -27, 114, 82, 80, -30, -117, -127, -62, 104, -73, -56, 101, 2, 3, 1, 0, 1};

    public LicenseInfo readAndVerifyLicenseFromFile(File file) {
        System.setProperty(LICENSE_FILE_PROP, file.getAbsolutePath());
        if (file.getName().endsWith(".bin")) {
            return this.readAndVerifyFromBinFile(file);
        }
        return this.readAndVerifyFromTxtFile(file);
    }

    private LicenseInfo readAndVerifyFromTxtFile(File file) throws IOException {
        String licenseString = FileUtils.readFileToString((File)file, (Charset)Charset.defaultCharset());
        licenseString = StringUtils.trim((String)licenseString);
        License license = License.Create.from((byte[])Base64.getDecoder().decode(licenseString));
        return this.verifyLicense(license, file);
    }

    private LicenseInfo readAndVerifyFromBinFile(File file) throws IOException {
        try (javax0.license3j.io.LicenseReader reader = new javax0.license3j.io.LicenseReader(file);){
            License license = reader.read();
            LicenseInfo licenseInfo = this.verifyLicense(license, file);
            return licenseInfo;
        }
    }

    public LicenseInfo readAndVerifyLicenseFromString(String encodedLicenseString) {
        System.setProperty(LICENSE_KEY_PROP, encodedLicenseString);
        License license = License.Create.from((byte[])Base64.getDecoder().decode(encodedLicenseString));
        return this.verifyLicense(license, null);
    }

    LicenseInfo verifyLicense(License license, File file) {
        Feature expirationFeature = license.get(LicenseFeature.EXPIRATION.name().toLowerCase(Locale.ROOT));
        LocalDate expiration = expirationFeature.getDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        String entitlementsFeatureVal = license.get(LicenseFeature.ENTITLEMENT.name().toLowerCase(Locale.ROOT)).getString();
        List<Entitlement> entitlements = Entitlement.fromStringList(entitlementsFeatureVal);
        boolean isSignatureValid = true;
        if (!license.isOK(LICENSE_SIB_PUB_KEY)) {
            log.error("License's signature is not valid. License file {}", (Object)file);
            isSignatureValid = false;
            expiration = LocalDate.parse("1970-01-01");
        }
        return new LicenseInfo(expiration, entitlements, isSignatureValid, file);
    }

    File findWithLicenseFileExtensions(File licenseFile) {
        if (licenseFile.exists()) {
            return licenseFile;
        }
        if ((licenseFile = FilesUtils.replaceExt(licenseFile, "bin")).exists()) {
            return licenseFile;
        }
        if ((licenseFile = FilesUtils.replaceExt(licenseFile, "txt")).exists()) {
            return licenseFile;
        }
        return null;
    }

    LicenseInfo loadLicenseFromFile(String location, String propOrVarName) {
        File licenseFileOrDir = new File(location);
        if (!licenseFileOrDir.exists()) {
            throw new LicenseException("License file %s does not exist. This location was defined by the environment variable/system property %s", location, propOrVarName);
        }
        File licenseFile = licenseFileOrDir;
        if (licenseFileOrDir.isDirectory()) {
            licenseFile = this.findWithLicenseFileExtensions(new File(licenseFileOrDir, DEFAULT_LICENSE_FILE_NAME));
        }
        if (licenseFile == null || !licenseFile.exists()) {
            throw new LicenseException("License file %s does not exist. This location was defined by the environment variable or system property %s", location, propOrVarName);
        }
        return this.readAndVerifyLicenseFromFile(licenseFile);
    }
}

