/*
 * Decompiled with CFR 0.152.
 */
package hdi.license;

import hdi.license.LicenseException;
import hdi.license.LicenseInfo;
import hdi.license.LicenseReader;
import hdi.util.FilesUtils;
import java.io.File;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LicenseChecker.class);
    private final LicenseReader licenseReader = new LicenseReader();

    public void checkLicenseFromEnvVars() {
        this.checkLicenseWithException(this.checkEnvVar("EDI_LICENSE_KEY"), this.checkEnvVar("EDI_LICENSE_FILE"));
    }

    private String checkEnvVar(String envVar) {
        String val = System.getenv(envVar);
        if (StringUtils.isBlank((CharSequence)val)) {
            envVar = StringUtils.substringAfter((String)envVar, (String)"EDI_");
            val = System.getenv(envVar);
        }
        return val;
    }

    public LicenseInfo checkLicense(String licenseKey, String licenseFilePath) {
        LicenseInfo licenseInfo;
        if (StringUtils.isNotBlank((CharSequence)licenseKey)) {
            licenseInfo = this.licenseReader.readAndVerifyLicenseFromString(licenseKey);
        } else if (StringUtils.isNotBlank((CharSequence)licenseFilePath)) {
            File licenseFile = new File(licenseFilePath);
            if (!licenseFile.exists() && !(licenseFile = FilesUtils.replaceExt(licenseFile, "bin")).exists()) {
                log.error("License files {} or {} do not exist and LICENSE_KEY is not defined", (Object)licenseFilePath, (Object)licenseFile.getPath());
                return null;
            }
            licenseInfo = this.licenseReader.readAndVerifyLicenseFromFile(licenseFile);
        } else {
            throw new LicenseException("The path to the license file or the license key are undefined. Define 'LICENSE_FILE' environment variable to point to the license file or 'LICENSE_KEY' environment variable with the key. Request your license at https://datainsight.health/products/license-request", new Object[0]);
        }
        if (licenseInfo.isExpired()) {
            log.error("Your license has expired. Request your license at https://datainsight.health/products/license-request");
        }
        if (licenseInfo.expiresSoon()) {
            long nDays = licenseInfo.expirationInDays();
            log.warn("Your license will expire in {} days. {}", (Object)nDays, (Object)"Request your license at https://datainsight.health/products/license-request");
        }
        return licenseInfo;
    }

    public LicenseInfo checkLicenseWithException(String licenseKey, String licenseFilePath) {
        if (StringUtils.isBlank((CharSequence)licenseFilePath) && StringUtils.isBlank((CharSequence)licenseKey)) {
            throw new LicenseException("The path to the license file or the license key are undefined. Define '%s' environment variable to point to the license file or '%s' environment variable with the key", "EDI_LICENSE", "EDI_LICENSE_KEY");
        }
        LicenseInfo licenseInfo = this.checkLicense(licenseKey, licenseFilePath);
        if (licenseInfo == null) {
            throw new LicenseException("Could not find the license key. Define LICENSE_FILE or LICENSE_KEY environment variables.  Checked license file at '%s'", licenseFilePath);
        }
        if (licenseInfo.isExpired()) {
            throw new LicenseException("Your license has expired. Request your license at https://datainsight.health/products/license-request", new Object[0]);
        }
        return licenseInfo;
    }
}

