/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.validation;

import hdi.edi.dict.DictField;
import hdi.edi.qualifier.EdiQualifier;
import hdi.edi.validation.IssueType;
import lombok.Generated;

public class ValidationIssue {
    private String message;
    private String edi;
    private String loop;
    private IssueType issueType;
    private String fieldName;
    private String fieldDesc;
    private Integer maxNumberOfItems;
    private Integer actualNumberOfItems;
    private EdiQualifier ediQualifier;

    public ValidationIssue(IssueType issueType, DictField field) {
        this(issueType, field, null);
    }

    public ValidationIssue(IssueType issueType, DictField field, String name) {
        if (field != null) {
            this.fieldName = field.field().getName();
            this.edi = field.getEdiStr(true);
            this.loop = field.loop();
            this.fieldDesc = field.desc();
        } else {
            this.fieldName = name;
        }
        this.issueType = issueType;
    }

    public static ValidationIssue createMaxItemsIssue(DictField field, int actualNumberOfItems, EdiQualifier ediQualifier) {
        ValidationIssue issue = new ValidationIssue(IssueType.NUMBER_OF_ITEMS, field);
        issue.actualNumberOfItems = actualNumberOfItems;
        issue.ediQualifier = ediQualifier;
        return issue;
    }

    public String toTabbedString() {
        return String.format("%s\t%s\t%s", new Object[]{this.issueType, this.edi, this.fieldName});
    }

    @Generated
    public String message() {
        return this.message;
    }

    @Generated
    public String edi() {
        return this.edi;
    }

    @Generated
    public String loop() {
        return this.loop;
    }

    @Generated
    public IssueType issueType() {
        return this.issueType;
    }

    @Generated
    public String fieldName() {
        return this.fieldName;
    }

    @Generated
    public String fieldDesc() {
        return this.fieldDesc;
    }

    @Generated
    public Integer maxNumberOfItems() {
        return this.maxNumberOfItems;
    }

    @Generated
    public Integer actualNumberOfItems() {
        return this.actualNumberOfItems;
    }

    @Generated
    public EdiQualifier ediQualifier() {
        return this.ediQualifier;
    }

    @Generated
    public ValidationIssue message(String message) {
        this.message = message;
        return this;
    }

    @Generated
    public ValidationIssue edi(String edi) {
        this.edi = edi;
        return this;
    }

    @Generated
    public ValidationIssue loop(String loop) {
        this.loop = loop;
        return this;
    }

    @Generated
    public ValidationIssue issueType(IssueType issueType) {
        this.issueType = issueType;
        return this;
    }

    @Generated
    public ValidationIssue fieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    @Generated
    public ValidationIssue fieldDesc(String fieldDesc) {
        this.fieldDesc = fieldDesc;
        return this;
    }

    @Generated
    public ValidationIssue maxNumberOfItems(Integer maxNumberOfItems) {
        this.maxNumberOfItems = maxNumberOfItems;
        return this;
    }

    @Generated
    public ValidationIssue actualNumberOfItems(Integer actualNumberOfItems) {
        this.actualNumberOfItems = actualNumberOfItems;
        return this;
    }

    @Generated
    public ValidationIssue ediQualifier(EdiQualifier ediQualifier) {
        this.ediQualifier = ediQualifier;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidationIssue)) {
            return false;
        }
        ValidationIssue other = (ValidationIssue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$maxNumberOfItems = this.maxNumberOfItems();
        Integer other$maxNumberOfItems = other.maxNumberOfItems();
        if (this$maxNumberOfItems == null ? other$maxNumberOfItems != null : !((Object)this$maxNumberOfItems).equals(other$maxNumberOfItems)) {
            return false;
        }
        Integer this$actualNumberOfItems = this.actualNumberOfItems();
        Integer other$actualNumberOfItems = other.actualNumberOfItems();
        if (this$actualNumberOfItems == null ? other$actualNumberOfItems != null : !((Object)this$actualNumberOfItems).equals(other$actualNumberOfItems)) {
            return false;
        }
        String this$message = this.message();
        String other$message = other.message();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$edi = this.edi();
        String other$edi = other.edi();
        if (this$edi == null ? other$edi != null : !this$edi.equals(other$edi)) {
            return false;
        }
        String this$loop = this.loop();
        String other$loop = other.loop();
        if (this$loop == null ? other$loop != null : !this$loop.equals(other$loop)) {
            return false;
        }
        IssueType this$issueType = this.issueType();
        IssueType other$issueType = other.issueType();
        if (this$issueType == null ? other$issueType != null : !((Object)((Object)this$issueType)).equals((Object)other$issueType)) {
            return false;
        }
        String this$fieldName = this.fieldName();
        String other$fieldName = other.fieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        String this$fieldDesc = this.fieldDesc();
        String other$fieldDesc = other.fieldDesc();
        if (this$fieldDesc == null ? other$fieldDesc != null : !this$fieldDesc.equals(other$fieldDesc)) {
            return false;
        }
        EdiQualifier this$ediQualifier = this.ediQualifier();
        EdiQualifier other$ediQualifier = other.ediQualifier();
        return !(this$ediQualifier == null ? other$ediQualifier != null : !this$ediQualifier.equals(other$ediQualifier));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ValidationIssue;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $maxNumberOfItems = this.maxNumberOfItems();
        result = result * 59 + ($maxNumberOfItems == null ? 43 : ((Object)$maxNumberOfItems).hashCode());
        Integer $actualNumberOfItems = this.actualNumberOfItems();
        result = result * 59 + ($actualNumberOfItems == null ? 43 : ((Object)$actualNumberOfItems).hashCode());
        String $message = this.message();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $edi = this.edi();
        result = result * 59 + ($edi == null ? 43 : $edi.hashCode());
        String $loop = this.loop();
        result = result * 59 + ($loop == null ? 43 : $loop.hashCode());
        IssueType $issueType = this.issueType();
        result = result * 59 + ($issueType == null ? 43 : ((Object)((Object)$issueType)).hashCode());
        String $fieldName = this.fieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        String $fieldDesc = this.fieldDesc();
        result = result * 59 + ($fieldDesc == null ? 43 : $fieldDesc.hashCode());
        EdiQualifier $ediQualifier = this.ediQualifier();
        result = result * 59 + ($ediQualifier == null ? 43 : $ediQualifier.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ValidationIssue(message=" + this.message() + ", edi=" + this.edi() + ", loop=" + this.loop() + ", issueType=" + String.valueOf((Object)this.issueType()) + ", fieldName=" + this.fieldName() + ", fieldDesc=" + this.fieldDesc() + ", maxNumberOfItems=" + this.maxNumberOfItems() + ", actualNumberOfItems=" + this.actualNumberOfItems() + ", ediQualifier=" + String.valueOf(this.ediQualifier()) + ")";
    }

    @Generated
    public ValidationIssue() {
    }
}

