/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.validation;

import hdi.FieldNames;
import hdi.codeent.CodeEntity;
import hdi.edi.dict.DictField;
import hdi.edi.dict.VariantType;
import hdi.edi.parser.TransactionType;
import hdi.edi.qualifier.EdiQualifier;
import hdi.edi.validation.BaseValidator;
import hdi.edi.validation.CodeEntStats;
import hdi.edi.validation.CodeEntityValidator;
import hdi.edi.validation.FieldsHolder;
import hdi.edi.validation.IssueType;
import hdi.edi.validation.PartyValidator;
import hdi.edi.validation.ValidationIssue;
import hdi.model.claim.Claim;
import hdi.model.enumtype.DiagType;
import hdi.model.orgperson.OrgOrPerson;
import java.util.ArrayList;
import java.util.List;

public class ClaimValidator
extends BaseValidator
implements FieldNames {
    private final PartyValidator partyValidator = new PartyValidator();
    private final CodeEntityValidator codeEntityValidator = new CodeEntityValidator();

    public List<ValidationIssue> validate(Claim claim, TransactionType tranType) {
        ArrayList<ValidationIssue> issues = new ArrayList<ValidationIssue>();
        FieldsHolder fieldsHolder = this.getFieldsHolder(Claim.class, tranType);
        this.validateBasedOnAnnotation(issues, claim, fieldsHolder, tranType);
        if (!claim.diags().isEmpty()) {
            this.validateDiagCodes(issues, fieldsHolder, claim, tranType);
        }
        this.validateClaimProviders(issues, claim, tranType);
        return issues;
    }

    private void validateClaimProviders(List<ValidationIssue> issues, Claim claim, TransactionType tranType) {
        for (OrgOrPerson provider : claim.providers()) {
            issues.addAll(this.partyValidator.validate837Provider(provider, tranType));
        }
    }

    private void validateProcedures(List<ValidationIssue> issues, FieldsHolder fieldsHolder, Claim claim, TransactionType tranType) {
        CodeEntStats stats = new CodeEntStats(claim.procs());
    }

    private void validateMaxCount(CodeEntStats stats, DictField field, EdiQualifier ediQualifier, int maxCount, String fieldName) {
    }

    private void validateDiagCodes(List<ValidationIssue> issues, FieldsHolder fieldsHolder, Claim claim, TransactionType tranType) {
        List<CodeEntity> codEnts = claim.diags();
        int otherDiagCount = 0;
        int principalDiagCount = 0;
        for (CodeEntity codeEnt : codEnts) {
            EdiQualifier subType = codeEnt.subType();
            if (subType == DiagType.ICD_10_PRINCIPAL) {
                ++principalDiagCount;
            } else if (subType == DiagType.ICD_10) {
                ++otherDiagCount;
            }
            VariantType variantType = null;
            if (subType != DiagType.ICD_10_ADMITTING && tranType == TransactionType.INST) {
                variantType = VariantType.INST_DIAGNOSIS;
            }
            issues.addAll(this.codeEntityValidator.validate(codeEnt, tranType, variantType));
        }
        DictField diagField = fieldsHolder.getField("diags");
        if (principalDiagCount == 0) {
            ValidationIssue issue = new ValidationIssue(IssueType.REQUIRED_CODE, diagField, null).ediQualifier(DiagType.ICD_10_PRINCIPAL);
            issues.add(issue);
        }
        if (principalDiagCount > 1) {
            issues.add(ValidationIssue.createMaxItemsIssue(diagField, principalDiagCount, DiagType.ICD_10_PRINCIPAL).maxNumberOfItems(1));
        }
        if (otherDiagCount > 24) {
            issues.add(ValidationIssue.createMaxItemsIssue(diagField, otherDiagCount, DiagType.ICD_10).maxNumberOfItems(24));
        }
    }
}

