/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.validation;

import hdi.edi.dict.DictField;
import hdi.edi.dict.DictMgr;
import hdi.edi.dict.VariantType;
import hdi.edi.parser.TransactionType;
import hdi.edi.qualifier.EdiQualifier;
import hdi.edi.validation.FieldsHolder;
import hdi.edi.validation.IssueType;
import hdi.edi.validation.ValidationIssue;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public class BaseValidator {
    protected ValidationIssue checkRequired(List<ValidationIssue> issues, String name, Object value) {
        return this.checkRequired(issues, null, name, value);
    }

    protected ValidationIssue checkRequired(List<ValidationIssue> issues, DictField field, String name, Object value) {
        EdiQualifier qualifier;
        boolean isFailed = false;
        if (value == null) {
            isFailed = true;
        } else if (value instanceof Collection) {
            Collection list = (Collection)value;
            if (list.isEmpty()) {
                isFailed = true;
            }
        } else if (value instanceof String) {
            String str = (String)value;
            if (str.isBlank()) {
                isFailed = true;
            }
        } else if (value instanceof EdiQualifier && StringUtils.equalsIgnoreCase((CharSequence)(qualifier = (EdiQualifier)value).name(), (CharSequence)"NONE")) {
            isFailed = true;
        }
        ValidationIssue issue = null;
        if (isFailed) {
            issue = new ValidationIssue(IssueType.REQUIRED, field, name);
            issues.add(issue);
        }
        return issue;
    }

    protected void checkNotAllowed(List<ValidationIssue> issues, String name, Object value) {
        this.checkNotAllowed(issues, null, name, value);
    }

    protected void checkNotAllowed(List<ValidationIssue> issues, DictField field, String name, Object value) {
        boolean isNonEmpty = false;
        if (value instanceof Collection) {
            Collection list = (Collection)value;
            if (!list.isEmpty()) {
                isNonEmpty = true;
            }
        } else if (value != null) {
            isNonEmpty = true;
        }
        if (isNonEmpty) {
            issues.add(new ValidationIssue(IssueType.NOT_ALLOWED, field, name));
        }
    }

    protected void validateBasedOnAnnotation(List<ValidationIssue> issues, Object obj, FieldsHolder fieldsHolder, TransactionType tranType) {
        this.validateBasedOnAnnotation(issues, obj, fieldsHolder, tranType, null);
    }

    protected void validateBasedOnAnnotation(List<ValidationIssue> issues, Object obj, FieldsHolder fieldsHolder, TransactionType tranType, VariantType variantType) {
        List<DictField> allDictFields = fieldsHolder.fields();
        for (DictField df : allDictFields) {
            Object val;
            Field field = df.field();
            if (!df.isAllowedForTranType(tranType) || !df.isAllowedForVariantType(variantType)) {
                val = FieldUtils.readField((Field)field, (Object)obj, (boolean)true);
                this.checkNotAllowed(issues, df, null, val);
                continue;
            }
            if (!df.isRequired()) continue;
            val = FieldUtils.readField((Field)field, (Object)obj, (boolean)true);
            this.checkRequired(issues, df, null, val);
        }
    }

    protected FieldsHolder getFieldsHolder(Class<?> clazz, TransactionType primaryTranType) {
        List<DictField> fields = DictMgr.getAllDictFields(clazz, primaryTranType);
        return new FieldsHolder(fields);
    }
}

