/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.qualifier;

import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.SegmentType;
import hdi.edi.qualifier.EdiQualifier;
import hdi.edi.qualifier.EdiQualifierEnt;
import hdi.edi.qualifier.HierarchicalChildType;
import hdi.edi.qualifier.HierarchicalLevelType;
import hdi.model.claim.ambulance.AmbulanceConditionCode;
import hdi.model.claim.ambulance.AmbulanceTransportReason;
import hdi.model.enumtype.ClaimOrEncounterIdentifierType;
import hdi.model.enumtype.DateFormatType;
import hdi.model.enumtype.DateType;
import hdi.model.enumtype.DiagType;
import hdi.model.enumtype.DrugIdentificationType;
import hdi.model.enumtype.IdentificationType;
import hdi.model.enumtype.ProcType;
import hdi.model.enumtype.ReferenceType;
import hdi.model.enumtype.TransactionSetType;
import hdi.model.enumtype.UbCodeType;
import hdi.model.enumtype.UnitType;
import hdi.model.orgperson.EntityRole;
import hdi.model.orgperson.EntityType;
import hdi.model.orgperson.GenderType;
import hdi.model.orgperson.ProviderType;
import hdi.model.patientsubscriber.PayerRespSequenceType;
import hdi.model.patientsubscriber.RelationshipType;
import hdi.model.payment.AccountNumberQualifier;
import hdi.model.payment.AdjustmentGroup;
import hdi.model.payment.DfiQualifier;
import hdi.model.payment.PaymentMethodType;
import hdi.model.payment.TransactionHandlingType;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public class QualifierResolver {
    public EdiQualifier resolveEnums(EdiSeg seg, String name, Object rawVal) {
        if (!(rawVal instanceof String)) {
            return null;
        }
        String rawStr = StringUtils.strip((String)rawVal.toString());
        EdiQualifier q = null;
        if (StringUtils.endsWithAny((CharSequence)name, (CharSequence[])new CharSequence[]{"date_format", "date_time_period_format", "date_time_period_format_qualifier"})) {
            q = this.enumFromEdiCode(rawStr, DateFormatType::fromEdi);
        }
        if (StringUtils.endsWithAny((CharSequence)name, (CharSequence[])new CharSequence[]{"date_time_qualifier"})) {
            q = this.enumFromEdiCode(rawStr, DateType::fromEdi);
        }
        if (StringUtils.endsWith((CharSequence)name, (CharSequence)"gender_code")) {
            q = this.enumFromEdiCode(rawStr, GenderType::fromEdi);
        }
        if (StringUtils.endsWith((CharSequence)name, (CharSequence)"individual_relationship_code")) {
            q = this.enumFromEdiCode(rawStr, RelationshipType::fromEdi);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"Identification_Code_Qualifier", (CharSequence)name)) {
            q = this.enumFromEdiCode(rawStr, IdentificationType::fromEdi);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"Entity_Type_Qualifier", (CharSequence)name)) {
            q = this.enumFromEdiCode(rawStr, EntityType::fromEdi);
        } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)name, (CharSequence[])new CharSequence[]{"Entity_Identifier_Code"})) {
            q = this.enumFromEdiCode(rawStr, EntityRole::fromEdi);
        } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)name, (CharSequence[])new CharSequence[]{"Reference_Identification_Qualifier", "receiver_id_qualifier", "reference_id_qualifier"})) {
            q = this.enumFromEdiCode(rawStr, ReferenceType::fromEdi);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"payer_responsibility_sequence_number_code", (CharSequence)name)) {
            q = this.enumFromEdiCode(rawStr, PayerRespSequenceType::fromEdi);
        } else if (StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)"unit_or_basis_for_measurement")) {
            q = this.enumFromEdiCode(rawStr, UnitType::fromEdi);
        } else if (StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)"adjustment_group_code")) {
            q = this.enumFromEdiCode(rawStr, AdjustmentGroup::fromEdi);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"ambulance_transport_reason_code", (CharSequence)name)) {
            q = this.enumFromEdiCode(rawStr, AmbulanceTransportReason::fromEdi);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"diagnosis_type_code", (CharSequence)name)) {
            q = this.enumFromEdiCode(rawStr, DiagType::fromEdi);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"hierarchical_level_code", (CharSequence)name)) {
            q = this.enumFromEdiCode(rawStr, HierarchicalLevelType::fromEdi);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"hierarchical_child_code", (CharSequence)name)) {
            q = this.enumFromEdiCode(rawStr, HierarchicalChildType::fromEdi);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)"provider_code", (CharSequence)name)) {
            q = this.enumFromEdiCode(rawStr, ProviderType::fromEdi);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"transaction_set_identifier_code")) {
            q = this.enumFromEdiCode(rawStr, TransactionSetType::fromEdi);
        } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)name, (CharSequence[])new CharSequence[]{"claim_or_encounter_id", "transaction_type_code"})) {
            q = this.enumFromEdiCode(rawStr, ClaimOrEncounterIdentifierType::fromEdi);
        } else if (seg.isInType(SegmentType.CRC) && StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)"condition_code")) {
            q = this.enumFromEdiCode(rawStr, AmbulanceConditionCode::fromEdi);
        } else if (seg.isInType(SegmentType.BPR) && StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"transaction_handling_code")) {
            q = this.enumFromEdiCode(rawStr, TransactionHandlingType::fromEdi);
        } else if (seg.isInType(SegmentType.BPR) && StringUtils.startsWithIgnoreCase((CharSequence)name, (CharSequence)"dfi_id_number_qualifier")) {
            q = this.enumFromEdiCode(rawStr, DfiQualifier::fromEdi);
        } else if (StringUtils.startsWithIgnoreCase((CharSequence)name, (CharSequence)"acct_number_qualifier")) {
            q = this.enumFromEdiCode(rawStr, AccountNumberQualifier::fromEdi);
        } else if (StringUtils.startsWithIgnoreCase((CharSequence)name, (CharSequence)"payment_method_code")) {
            q = this.enumFromEdiCode(rawStr, PaymentMethodType::fromEdi);
        } else if (StringUtils.equalsAnyIgnoreCase((CharSequence)name, (CharSequence[])new CharSequence[]{"qualifier_code", "qualifier", "code_list_qualifier_code", "code_list_qualifier", "product_service_id_qualifier"}) || StringUtils.endsWithIgnoreCase((CharSequence)name, (CharSequence)"product_or_service_id_qualifier")) {
            q = ProcType.fromEdi(rawStr);
            if (q == null) {
                q = DrugIdentificationType.fromEdi(rawStr);
            }
            if (q == null) {
                q = UbCodeType.fromEdi(rawStr);
            }
            if (q == null) {
                q = DiagType.fromEdi(rawStr);
            }
        }
        return q;
    }

    private EdiQualifier enumFromEdiCode(String ediCode, Function<String, EdiQualifier> enumFromCodeFun) {
        EdiQualifier q = enumFromCodeFun.apply(ediCode);
        if (q == null) {
            q = new EdiQualifierEnt(ediCode);
        }
        return q;
    }
}

