/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.parserhelper;

import hdi.edi.parser.EdiSeg;
import hdi.edi.parser.SegmentType;
import hdi.edi.parserhelper.SegMatchingCriteria;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class SegMatcher {
    public List<EdiSeg> findByType(List<EdiSeg> sourceSegs, SegmentType ... types) {
        SegMatchingCriteria filterMeta = new SegMatchingCriteria().inclSegTypes(types);
        return this.match(sourceSegs, filterMeta);
    }

    public EdiSeg findFirstByType(List<EdiSeg> sourceSegs, SegmentType ... types) {
        SegMatchingCriteria filterMeta = new SegMatchingCriteria().inclSegTypes(types);
        return this.findFirst(sourceSegs, filterMeta);
    }

    public List<EdiSeg> findByLoopAndType(List<EdiSeg> segs, String loopNumber, SegmentType ... types) {
        SegMatchingCriteria filterMeta = new SegMatchingCriteria().inclLoopNumbers(loopNumber).inclSegTypes(types);
        return this.match(segs, filterMeta);
    }

    public EdiSeg findFirst(List<EdiSeg> sourceSegs, SegMatchingCriteria matchingCriteria) {
        List<EdiSeg> segs = this.match(sourceSegs, matchingCriteria);
        return !segs.isEmpty() ? segs.get(0) : null;
    }

    public EdiSeg findFirstByName(List<EdiSeg> sourceSegs, String ... names) {
        SegMatchingCriteria filterMeta = new SegMatchingCriteria().inclSegNames(names);
        List<EdiSeg> segs = this.match(sourceSegs, filterMeta);
        return !segs.isEmpty() ? segs.get(0) : null;
    }

    public List<EdiSeg> match(List<EdiSeg> sourceSegs, SegMatchingCriteria filterMeta) {
        ArrayList<EdiSeg> matchedSegs = new ArrayList<EdiSeg>();
        for (EdiSeg seg : sourceSegs) {
            this.matchSeg(seg, matchedSegs, filterMeta);
        }
        return matchedSegs;
    }

    private void matchSeg(EdiSeg seg, List<EdiSeg> matchedSegs, SegMatchingCriteria matchingCriteria) {
        HashSet<Operator> result = new HashSet<Operator>();
        if (matchingCriteria.isInLoop(seg)) {
            result.add(Operator.LOOP_INCLUDE);
        }
        if (matchingCriteria.includeSegTypes().isEmpty() || matchingCriteria.includeSegTypes().contains((Object)seg.type())) {
            result.add(Operator.SEG_TYPE_INCLUDE);
        }
        if (matchingCriteria.excludeSegTypes().isEmpty() || !matchingCriteria.excludeSegTypes().contains((Object)seg.type())) {
            result.add(Operator.SEG_TYPE_EXCLUDE);
        }
        if (matchingCriteria.includeSegNames().isEmpty() || this.stringContainsOneOf(seg.name(), matchingCriteria.includeSegNames()) || this.stringContainsOneOf(seg.friendlyName(), matchingCriteria.includeSegNames())) {
            result.add(Operator.SEG_NAME_INCLUDE);
        }
        if (matchingCriteria.ediQualifier() == null || seg.containsQualifier(matchingCriteria.ediQualifier())) {
            result.add(Operator.QUALIFIER);
        }
        if (result.size() == Operator.values().length) {
            matchedSegs.add(seg);
        }
        for (EdiSeg child : seg.childSegs()) {
            this.matchSeg(child, matchedSegs, matchingCriteria);
        }
    }

    private boolean stringContainsOneOf(String s, Collection<String> stringsToCheck) {
        return StringUtils.containsAnyIgnoreCase((CharSequence)s, (CharSequence[])stringsToCheck.toArray(new String[0]));
    }

    public static enum Operator {
        SEG_TYPE_INCLUDE,
        SEG_TYPE_EXCLUDE,
        SEG_NAME_INCLUDE,
        LOOP_INCLUDE,
        QUALIFIER;

    }
}

