/*
 * Decompiled with CFR 0.152.
 */
package hdi.edi.parserhelper;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import hdi.edi.parserhelper.ParsingError;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import lombok.NonNull;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class ParsedLine {
    @NonNull
    private String line;
    private final int lineNumber;
    private final List<ParsingError> parsingErrors = new ArrayList<ParsingError>();

    public void addError(ParsingError parsingError) {
        this.parsingErrors.add(parsingError);
    }

    public void addError(String errorMsg, Object ... msgParams) {
        if (msgParams.length > 0) {
            errorMsg = String.format(errorMsg, msgParams);
        }
        this.parsingErrors.add(new ParsingError(errorMsg));
    }

    public void appendToLine(String strToAppend) {
        this.line = this.line + strToAppend;
    }

    @NonNull
    @Generated
    public String line() {
        return this.line;
    }

    @Generated
    public int lineNumber() {
        return this.lineNumber;
    }

    @Generated
    public List<ParsingError> parsingErrors() {
        return this.parsingErrors;
    }

    @Generated
    public String toString() {
        return "ParsedLine(line=" + this.line() + ", lineNumber=" + this.lineNumber() + ", parsingErrors=" + String.valueOf(this.parsingErrors()) + ")";
    }

    @Generated
    public ParsedLine(@NonNull String line, int lineNumber) {
        if (line == null) {
            throw new NullPointerException("line is marked non-null but is null");
        }
        this.line = line;
        this.lineNumber = lineNumber;
    }
}

